<?php
$task = ! empty( $_GET['task'] ) ? $_GET['task'] : '';
$home = get_bloginfo( 'url' );

$menu_items = build_menu();

/**
	 * Customer dashboard menu items
	 *
	 * @since    1.0.0
	 * @return   array
	 */
	function build_menu() {
		$menu = array();
        
        $menu[ 'profile' ] = array(
			'task' => 'profile',
			'name' => __( 'حساب کاربری', 'edd_customer_dashboard' )
		);

		$menu[ 'purchases' ] = array(
			'task' => 'purchases',
			'name' => __( 'تاریخچه سفارشات', 'edd_customer_dashboard' )
		);

		$menu[ 'downloads' ] = array(
			'task' => 'download',
			'name' => __( 'دانلودها', 'edd_customer_dashboard' )
		);
        
        if( class_exists( 'EDD_Points_Renderer' ) ) {
        $menu[ 'points' ] = array(
        "task" => 'points',
        "name" => 'امتیازات'
        );
        }

		if( class_exists( 'EDD_Software_Licensing' ) ) {
        $menu[ 'license' ] = array(
        "task" => 'license',
        "name" => 'لایسنس ها'
        );
		}
		
		// Support for EDD Wallet
		if( class_exists( 'EDD_Wallet' ) ) {
			$menu[ 'wallet' ] = array(
				'task'=> 'wallet',
				'name' => __( 'کیف پول', 'edd_customer_dashboard' )
			);
		}
        
        /*
		if( class_exists( 'EDD_Wish_Lists' ) ) {
			$menu[ 'wishlists' ] = array(
				'task'=> 'wishlist',
				'name' => __( 'علاقه مندی ها', 'edd_customer_dashboard' )
			);
		}*/
		
		if( class_exists( 'Awesome_Support' ) ) {
            $ticket_submit_id = wpas_get_option( 'ticket_submit' );
            if(is_array($ticket_submit_id)){
                $ticket_submit = $ticket_submit_id[0];
            }
            else {
                $ticket_submit = $ticket_submit_id;
            }
            $tpost = get_post((int)$ticket_submit); 
            $tslug = $tpost->post_name;
			$menu[ 'submit-ticket' ] = array(
				'task'=> 'send-ticket',
				'name' => __( 'ارسال تیکت', 'edd_customer_dashboard' ),
                "link" => $tslug,
			);
		}
		
		if( class_exists( 'Awesome_Support' ) ) {
            $lpost = get_post((int)wpas_get_option( 'ticket_list' )); 
            $lslug = $lpost->post_name;
			$menu[ 'tickets' ] = array(
				'task'=> 'tickets',
				'name' => __( 'تیکت ها', 'edd_customer_dashboard' ),
                "link" => $lslug,
			);
		}

        $user_id = get_current_user_id();
        if( class_exists( 'EDD_Front_End_Submissions' ) && !EDD_FES()->vendors->user_is_vendor( $user_id ) ) {
			$menu[ 'fes_become_vendor' ] = array(
				'task'=> 'fes_become_vendor',
				'name' => __( 'فروشنده شوید!', 'edd_customer_dashboard' )
			);
		}
        
        if( class_exists( 'EDD_Front_End_Submissions' ) && EDD_FES()->vendors->user_is_vendor( $user_id ) ) {
			$menu[ 'fes_become_vendor' ] = array(
				'task'=> 'fes_become_vendor',
				'name' => __( 'پنل فروشندگان', 'edd_customer_dashboard' ),
                "link" => 'vendor-dashboard',
			);
		}
        
        if( class_exists( 'Affiliate_WP' ) ) {
            $apost = get_post(affwp_get_affiliate_area_page_id()); 
            $aslug = $apost->post_name;
			$menu[ 'affiliate' ] = array(
				'task'=> 'affiliate',
				'name' => __( 'همکاری در فروش', 'edd_customer_dashboard' ),
                "link" => $aslug,
			);
		}

		$menu = apply_filters( "edd_customer_dashboard_menu_links", $menu );
		
        return $menu;

	}

?>
<div class="row">
<div class="col-lg-3 col-12">
	<div class="dashboard-menu-con">
		<?php
			$user = wp_get_current_user(); 
			echo get_avatar(get_current_user_id() , 120,'' ,$user->display_name ); ?>
			<span class="side-uname">
				<?php echo $user->display_name; ?>
			</span>
		<?php
			if (class_exists('EDD_Wallet'))
			{  
				$wallet = edd_currency_filter( edd_wallet()->wallet->balance(get_current_user_id()) );
				echo '<span class="m-wallet">موجودی کیف پول: '.$wallet.'</span>';
			} 
		?>
		<nav class="customer-dashboard-menu">
			<ul>
				<?php
				
				global $post;
				$post_slug=$post->post_name;
				
				foreach ( $menu_items as $item => $value ) {
					if( $task == $value['task'] || $post_slug === $value['link'] ) {
						$class = ' active';
					} else {
						$class = '';
					}
				?>
				<?php
				
				if($value['link'] != '') { ?>
				<li class="customer-dashboard-menu-tab <?php echo $value[ 'task' ] . $class; ?>">
						<a href="<?php echo get_home_url() . '/' . $value['link']; ?>">
							<?php echo $value[ 'name' ]; ?>
						</a>
					</li>
				<?php } else { ?>
					<li class="customer-dashboard-menu-tab <?php echo $value[ 'task' ] . $class; ?>">
						<a href="<?php echo get_home_url().'/dashboard/?task='. $value['task']; ?>">
							<?php echo $value[ 'name' ]; ?>
						</a>
					</li>
					<?php } ?>
				<?php
				}
				?>
				<li class="customer-dashboard-menu-tab logout"><a href="<?php echo wp_logout_url( $home ); ?>">خروج</a></li>
			</ul>
		</nav>
	</div>
</div>