<?php
/**
 * This template is used to display the registration form with [edd_register]
 */
global $edd_register_redirect;

do_action( 'edd_print_errors' ); ?>

<?php if ( ! is_user_logged_in() ) : ?>

<form id="edd_register_form" class="edd_form" action="" method="post">
	<?php do_action( 'edd_register_form_fields_top' ); ?>

	<fieldset>
		<legend><?php _e( 'Register New Account', 'easy-digital-downloads' ); ?></legend>

		<?php do_action( 'edd_register_form_fields_before' ); ?>
        
        <div class="form-group">
				<div class="input-group">
                     <span class="input-group-prepend">
                        <span class="input-group-text">
                        <span class="fas fa-user"></span>
                        </span>
                     </span>
                     <input name="edd_user_login" id="edd-user-login" class="form-control edd-required" placeholder="<?php _e( 'Username', 'easy-digital-downloads' ); ?>" type="text" required="required"/>
                  </div>
        </div>
        
        <div class="form-group">
				<div class="input-group">
                     <span class="input-group-prepend">
                        <span class="input-group-text">
                        <span class="fas fa-envelope"></span>
                        </span>
                     </span>
                     <input name="edd_user_email" id="edd-user-email" class="form-control edd-required" placeholder="<?php _e( 'Email', 'easy-digital-downloads' ); ?>" type="email" required="required"/>
                  </div>
        </div>
        
        <div class="form-group">
				<div class="input-group">
                     <span class="input-group-prepend">
                        <span class="input-group-text">
                     <span class="fas fa-key"></span>
                     </span>
                     </span>
                     <input name="edd_user_pass" id="edd_user_pass" class="form-control edd-required" placeholder="<?php _e( 'Password', 'easy-digital-downloads' ); ?>" type="password" required="required"/>
                  </div>
        </div>
        
        <div class="form-group">
                <div class="input-group">
                     <span class="input-group-prepend">
                        <span class="input-group-text">
                        <span class="fas fa-key"></span>
                     </span>
                     </span>
                     <input name="edd_user_pass2" id="edd_user_pass2" class="form-control edd-required" placeholder="<?php _e( 'Confirm Password', 'easy-digital-downloads' ); ?>" type="password" required="required"/>
                  </div>
        </div>

		<?php do_action( 'edd_register_form_fields_before_submit' ); ?>

		<p>
			<input type="hidden" name="edd_honeypot" value="" />
			<input type="hidden" name="edd_action" value="user_register" />
			<input type="hidden" name="edd_redirect" value="<?php echo esc_url( $edd_register_redirect ); ?>"/>
			<input class="edd-submit" name="edd_register_submit" id="edd_register_submit" type="submit" value="<?php esc_attr_e( 'Register', 'easy-digital-downloads' ); ?>" />
		</p>

		<?php do_action( 'edd_register_form_fields_after' ); ?>
	</fieldset>

	<?php do_action( 'edd_register_form_fields_bottom' ); ?>
</form>

<?php else : ?>

	<?php do_action( 'edd_register_form_logged_in' ); ?>

<?php endif; ?>
