<div class="fes-vendor-dashboard-con">
<?php
    $user = get_current_user_id();
	$products = EDD_FES()->vendors->get_all_products($user);
	$pending = EDD_FES()->vendors->get_all_products_count(get_current_user_id(), 'pending');
	$approved = EDD_FES()->vendors->get_all_products_count(get_current_user_id(), 'publish');
    if ( EDD_FES()->integrations->is_commissions_active() ) {
	$unpaid_commission = edd_currency_filter( eddc_get_unpaid_totals( get_current_user_id() ) );
    }
	$sales = 0;
	$earnings = 0;

	if (!empty($products)) { 
		foreach ($products as $product) : 
		$sales+= $product['sales']; 
		endforeach;
	} 
	$message = $sales . ' فروش';
?>

<?php
$vendor_announcement = EDD_FES()->helper->get_option( 'fes-dashboard-notification', '' );
if ( $vendor_announcement ) : ?>
	<div id="fes-vendor-announcements" class="alert alert-info">
		<?php echo apply_filters( 'fes_dashboard_content', do_shortcode( $vendor_announcement ) ); ?>
	</div>
<?php endif; ?>
<div id="fes-vendor-store-link">
	<?php echo EDD_FES()->vendors->get_vendor_store_url_dashboard(); ?>
</div>
<?php if ( EDD_FES()->integrations->is_commissions_active() ) { ?>
<div class="account-overview-wrapper">
<div class="account-overview">
<div class="row">
				<div class="col-lg-3 col-md-6 col-12">
					<div class="stats-col">
					<h5>مجموع دریافتی</h5>
					<div class="result"><?php echo wp_kses( edd_currency_filter( eddc_get_paid_totals( get_current_user_id() ) ), wp_kses_allowed_html( 'post' ) ); ?></div>
					<div class="result text-subline"><?php echo wp_kses( $message, wp_kses_allowed_html( 'post' ) ); ?></div>
					<span class="fas fa-money-bill-alt"></span>
					</div>
				</div>
				
				<div class="col-lg-3 col-md-6 col-12 second">
					<div class="stats-col">
					<h5>موجودی</h5>
					<div class="result"><?php echo wp_kses( $unpaid_commission, wp_kses_allowed_html( 'post' ) ); ?></div>
					<div class="result text-subline">از آخرین پرداخت</div>
					<span class="fas fa-dollar-sign"></span>
					</div>
				</div>

				<div class="col-lg-3 col-md-6 col-12">
					<div class="stats-col">
					<h5>منتشر شده</h5>
					<div class="result"><?php echo esc_html( $approved ); ?></div>
					<div class="result text-subline">محصولات منتشر شده</div>
					<span class="fas fa-upload"></span>
					</div>	
				</div>
				
				<div class="col-lg-3 col-md-6 col-12 second">
					<div class="stats-col">
					<h5>در حال بررسی</h5>
					<div class="result"><?php echo esc_html( $pending ) ?></div>
					<div class="result text-subline">محصولات در حال بررسی</div>	
					<span class="fas fa-clock"></span>		
					</div>
				</div>
</div>

</div>
</div>
<?php } else {  ?>
<div class="alert comm-alert alert-info">
		برای نمایش کامل پنل فروشندگان افزونه EDD Commission را نصب و فعال نمایید.
	</div>
<?php } ?>

<div class="fes-comments-wrap">
	<table id="fes-comments-table" class="table table-striped">
		<tr>
			<th class="col-author fes-comments-table-authors-column"><?php  _e( 'Author', 'edd_fes' ); ?></th>
			<th class="col-content fes-comments-table-content-column"><?php  _e( 'Comment', 'edd_fes' ); ?></th>
		</tr>
		<?php echo EDD_FES()->dashboard->render_comments_table( 10 ); ?>
	</table>
</div>
</div>