<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Demo Website: Azin.Elmfile.ir
Author Website: Hosseinkhani.ir
*/
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}
//Theme constants
define('AZ_URI', get_template_directory_uri());
define('AZ_DIR', get_template_directory());

$az_data[] = '';

if (!class_exists('ReduxFramework') && file_exists(dirname(__FILE__) . '/includes/ReduxCore/framework.php')) {
    require_once(dirname(__FILE__) . '/includes/ReduxCore/framework.php');
}
if (!isset($redux_demo) && file_exists(dirname(__FILE__) . '/includes/sample/admin-panel-config.php')) {
    require_once(dirname(__FILE__) . '/includes/sample/admin-panel-config.php');
}


Redux::init('az_data');

   if ($az_data['ajax_search']) {
       require_once AZ_DIR . '/includes/searchwp-live-ajax-search/searchwp-live-ajax-search.php';
   }

   require_once AZ_DIR . '/meta-box/meta-box.php';
   require_once AZ_DIR . '/includes/recaptchalib.php';
   require_once AZ_DIR . '/includes/random-post.php';
   require_once AZ_DIR . '/includes/recent-post.php';
   require_once AZ_DIR . '/includes/epay.php';
   require_once AZ_DIR . '/includes/thumbnail-upscale.php';
   require_once AZ_DIR . '/includes/img-fix.php';
   require_once AZ_DIR . '/includes/logo-namad.php';
   require_once AZ_DIR . '/includes/fnews.php';
   require_once AZ_DIR . '/includes/d-sidebar.php';
   require_once AZ_DIR . '/includes/views.php';
   require_once AZ_DIR . '/includes/dynamic_style.php';
   require_once AZ_DIR . '/includes/breadcrumbs.php';
   require_once AZ_DIR . '/includes/azrating.php';
   require_once AZ_DIR . '/includes/image-banner.php';
   require_once AZ_DIR . '/includes/menu-icon.php';
   require_once AZ_DIR . '/includes/widget-icon/widget-icon.php';
   require_once AZ_DIR . '/includes/yamm-nav-walker.php';
   require_once AZ_DIR . '/includes/mmenu_walker.php';
   require_once AZ_DIR . '/includes/ajax-login.php';
   require_once AZ_DIR . '/includes/rich-text-tags/rich-text-tags.php';
   require_once AZ_DIR . '/plugins/plugin.php';
   require_once AZ_DIR . '/includes/simple-link-list-widget/simple-link-list-widget.php';
   require_once ABSPATH . 'wp-admin/includes/plugin.php';

   if (az_woo()) {
       require_once AZ_DIR . '/includes/woo.php';
       require_once AZ_DIR . '/includes/woo/woo-recent-downloads.php';
       require_once AZ_DIR . '/includes/woo/woo-random-downloads.php';
       require_once AZ_DIR . '/includes/woo/woo-most-saled.php';
       require_once AZ_DIR . '/includes/woo/woo-special-prod.php';
       require_once AZ_DIR . '/includes/woo/wauthor.php';
   } elseif (class_exists('Easy_Digital_Downloads')) {
       require_once AZ_DIR . '/includes/edd.php';
       require_once AZ_DIR . '/includes/edd-recent-downloads.php';
       require_once AZ_DIR . '/includes/edd-random-downloads.php';
       require_once AZ_DIR . '/includes/edd-most-saled.php';
       require_once AZ_DIR . '/includes/edd-special-prod.php';
       require_once AZ_DIR . '/includes/wauthor.php';
       require_once AZ_DIR . '/includes/fes.php';
   }

    //Register Elementor Widgets
    if (did_action('elementor/loaded')) {
        require_once AZ_DIR . '/includes/elementor.php';
    }



   //Add theme's styles
   add_action('wp_enqueue_scripts', 'azin_styles');
   function azin_styles()
   {
       global $az_data;
       if (class_exists( 'WeDevs_Dokan' )) {
        wp_dequeue_style( 'dokan-fontawesome' );
        wp_deregister_style( 'dokan-fontawesome' );
       }
       wp_register_style('az-boot', AZ_URI . '/css/bootstrap-rtl.min.css', array(), '2.7.1');
       wp_enqueue_style('az-boot');
       wp_register_style('az-fa', AZ_URI . '/css/fontawesome.min.css', array(), '2.7.1');
       wp_enqueue_style('az-fa');
       wp_register_style('az-style', AZ_URI . '/style.css', array(), '2.7.1');
       wp_enqueue_style('az-style');
       if (az_woo()) {
           wp_register_style('az-woo', AZ_URI . '/css/woo.css', array(), '2.7.1');
           wp_enqueue_style('az-woo');
       }
   }

   //Register Elementor Panel styles
    add_action('elementor/editor/before_enqueue_scripts', function () {
        wp_register_style('el-style', AZ_URI . '/css/elementor.css', array(), '2.7.1');
        wp_enqueue_style('el-style');
        wp_register_style('az-awe', AZ_URI . '/css/fontawesome.min.css');
        wp_enqueue_style('az-awe');
    });


    add_action('init', 'azin_js');
    //Add theme's JS
    function azin_js()
    {
        if (is_admin()) {
            return;
        }
        wp_enqueue_script('js_boot', AZ_URI . '/js/bootstrap.min.js', array('jquery'), '2.7.1', true);
        wp_enqueue_script('js_main', AZ_URI . '/js/main.js', array('jquery'), '2.7.1', true);
    }

   //Rregister navigation menu
   register_nav_menus(array(
           'primary' => 'منوی اصلی',
           'footer' => 'منوی فوتر',
           'header' => 'منوی هدر',
   ));

   function az_woo() {
       global $az_data;
       if (class_exists( 'WooCommerce' ) && $az_data['woo_mode']) {
           return true;
       }
   }
   
   //Wordpress page navigation
   function wp_pagination()
   {
       global $wp_query;
       $big = 999999999;
       $page_format = paginate_links(array(
       'base' => str_replace($big, '%#%', esc_url(get_pagenum_link($big))),
       'format' => '?paged=%#%',
       'current' => max(1, get_query_var('paged')),
       'total' => $wp_query->max_num_pages,
       'prev_text'    => '<i aria-hidden="true" class="fas fa-angle-right "></i>',
       'next_text'    => '<i aria-hidden="true" class="fas fa-angle-left "></i>',
       'type'  => 'array'
   ));
       if (is_array($page_format)) {
           $paged = (get_query_var('paged') == 0) ? 1 : get_query_var('paged');
           echo '<ul>';
           foreach ($page_format as $page) {
               echo "<li>$page</li>";
           }
           echo '</ul>';
       }
   }

   //Wordpress product navigation
   function wp_product_pagination()
   {
       global $products;
       $big = 999999999;
       $page_format = paginate_links(array(
   'base' => str_replace($big, '%#%', esc_url(get_pagenum_link($big))),
   'format' => '?paged=%#%',
   'current' => max(1, get_query_var('paged')),
   'total' => $products->max_num_pages,
   'prev_text'    => '<i aria-hidden="true" class="fas fa-angle-right "></i>',
       'next_text'    => '<i aria-hidden="true" class="fas fa-angle-left "></i>',
   'type'  => 'array'
   ));
       if (is_array($page_format)) {
           $paged = (get_query_var('paged') == 0) ? 1 : get_query_var('paged');
           echo '<ul>';
           foreach ($page_format as $page) {
               echo "<li>$page</li>";
           }
           echo '</ul>';
       }
   }
   
   // Add Theme Support
   add_theme_support('title-tag');
   add_theme_support('html5');
   add_theme_support('automatic-feed-links');

   // Add Thumbnail Theme Support
   add_theme_support('post-thumbnails');

   if ($az_data['square_thumb']) {
       add_image_size('single-download', 472, 472, true);
       add_image_size('single-download-m', 172, 172, true);
   } else {
       add_image_size('single-download', 472, 267, true);
       add_image_size('single-download-m', 172, 97, true);
   }

   add_image_size('widget-img', 64, 64, true);
   
   function fontawesome_dashboard()
   {
       wp_enqueue_style('fontawesome', AZ_URI .'/css/fontawesome.min.css');
   }
   add_action('admin_init', 'fontawesome_dashboard');
   /**
   * Loads admin-side menu-icon scripts and styles
   */
    function admin_menu_icon_styles($page)
    {
        if ($page == 'nav-menus.php' || $page == 'widgets.php') {
            wp_enqueue_style('select2', AZ_URI . '/includes/select2.min.css');
            wp_enqueue_style('menu-icon-admin-style', AZ_URI . '/includes/menu-icon-admin.css');
            wp_enqueue_script('my_s2', AZ_URI . '/includes/select2.min.js');
            wp_enqueue_script('my_s1', AZ_URI . '/includes/select2.js');
        }
    }
    add_action('admin_enqueue_scripts', 'admin_menu_icon_styles');
    function redux_custom_styles($page)
    {
        wp_enqueue_style('redux-custom-style', AZ_URI .'/includes/redux.css');
    }
    add_action('admin_enqueue_scripts', 'redux_custom_styles');
   
   /*** Remove Query String from Static Resources ***/
   function remove_cssjs_ver($src)
   {
       if (strpos($src, '?ver=')) {
           $src = remove_query_arg('ver', $src);
       }
       return $src;
   }
   add_filter('style_loader_src', 'remove_cssjs_ver', 10, 2);
   add_filter('script_loader_src', 'remove_cssjs_ver', 10, 2);

   if (get_option( 'show_on_front' ) == 'posts' ) {
    add_filter('pre_get_posts', 'my_get_posts');
   }
   
   function my_get_posts($query)
   {
       global $az_data;
       if (is_home() && $query->is_main_query()) {
           if ($az_data['main_type_post']) {
               $query->set('post_type', 'post');
           } else {
               if (az_woo()) {
                   $query->set('post_type', 'product');
               } else {
                   $query->set('post_type', 'download');
               }
           }
       }

       return $query;
   }

   add_filter('widget_tag_cloud_args', 'tj_tag_cloud_limit');
   function tj_tag_cloud_limit($args)
   {
       global $az_data;
       // Check if taxonomy option of the widget is set to tags
       if (isset($args['taxonomy'])) {
           $args['number'] = $az_data['tag_number']; // Number of tags to show
       }
       return $args;
   }
     
// unregister all widgets
 function unregister_default_widgets()
 {
     unregister_widget('WP_Widget_Links');
     unregister_widget('WP_Widget_Search');
     unregister_widget('WP_Widget_Recent_Posts');
     unregister_widget('Twenty_Eleven_Ephemera_Widget');
 }
  add_action('widgets_init', 'unregister_default_widgets', 11);
  /** remove redux menu under the tools **/
add_action('admin_menu', 'remove_redux_menu', 12);
function remove_redux_menu()
{
    remove_submenu_page('tools.php', 'redux-about');
}

//Post MetaBox
add_filter('rwmb_meta_boxes', 'azin_register_meta_boxes');
function azin_register_meta_boxes($meta_boxes)
{
    global $az_data;
    if ($az_data['show_fone']) {
        $foclass= 'fshow';
    } else {
        $foclass= 'fhide';
    }
    if ($az_data['show_ftwo']) {
        $ftwclass= 'fshow';
    } else {
        $ftwclass= 'fhide';
    }
    if ($az_data['show_fthree'] && $az_data['edit_fthree']) {
        $ftclass= 'fshow';
    } else {
        $ftclass= 'fhide';
    }
    if ($az_data['show_ffour'] && $az_data['edit_ffour']) {
        $ffclass= 'fshow';
    } else {
        $ffclass= 'fhide';
    }
    if ($az_data['show_ffive'] && $az_data['edit_ffive']) {
        $fficlass= 'fshow';
    } else {
        $fficlass= 'fhide';
    }
    if ($az_data['show_fsix'] && $az_data['edit_fsix']) {
        $fsclass= 'fshow';
    } else {
        $fsclass= 'fhide';
    }
    if ($az_data['woo_mode']) {
        $spclass= 'fhide';
    } else {
        $spclass= '';
    }
    if (!$az_data['woo_mode']) {
        $dclass= 'fhide';
    } else {
        $dclass= '';
    }
    $prefix = 'file_';
    // File Details
    $meta_boxes[] = array(
        'id'         => 'fdetails',
        'title'      => 'مشخصات محصول',
        'post_types' => array( 'download', 'product' ),
        'context'    => 'normal',
        'priority'   => 'high',
        'fields' => array(
           array(
                'name'  => 'محصول ویژه',
                'id'    => $prefix . 'special',
                'type'  => 'checkbox',
            ),
            array(
                'name'  => 'حالت به زودی',
                'id'    => $prefix . 'coming',
                'type'  => 'checkbox',
                'desc'  => 'نمایش عبارت به زودی به جای دکمه خرید',
            ),
            array(
                'name'  => 'فروش ویژه',
                'id'    => $prefix . 'spsale',
                'type'  => 'checkbox',
                'desc'  => 'نمایش در بلاک پیشنهاد شگفت انگیز در صفحه اصلی',
            ),
            array(
                'name'  => 'قیمت قبل از فروش ویژه (به تومان وارد کنید)',
                'id'    => $prefix . 'saleprice',
                'type'  => 'text',
                'desc'  => 'این قیمت به صورت خط خورده قبل از قیمت محصول نمایش داده می شود',
                'class' => $spclass,
            ),
            array(
                'name'  => $az_data['fone'],
                'id'    => $prefix . 'fone',
                'type'  => 'text',
                'class' => $foclass,
            ),
            array(
                'name'  => $az_data['ftwo'],
                'id'    => $prefix . 'ftwo',
                'type'  => 'text',
                'class' => $ftwclass,
            ),
            array(
                'name'  => $az_data['fthree'],
                'id'    => $prefix . 'fthree',
                'type'  => 'text',
                'class' => $ftclass,
            ),
            array(
                'name'  => $az_data['ffour'],
                'id'    => $prefix . 'ffour',
                'type'  => 'text',
                'class' => $ffclass,
            ),
            array(
                'name'  => $az_data['ffive'],
                'id'    => $prefix . 'ffive',
                'type'  => 'text',
                'class' => $fficlass,
            ),
            array(
                'name'  => $az_data['fsix'],
                'id'    => $prefix . 'fsix',
                'type'  => 'text',
                'class' => $fsclass,
            ),
            array(
                'name'  => 'نوع محصول',
                'id'    => $prefix . 'p_type',
                'type'  => 'radio',
                'inline' => true,
                'options' => array(
                    'graduation-cap' => 'آموزش',
                    'film' => 'فیلم',
                    'image' => 'تصویر',
                    'music' => 'آهنگ',
                    'book' => 'کتاب',
                    'file-alt' => 'سایر موارد',
                ),
            ),
            array(
                'type' => 'heading',
                'name' => '',
                'desc' => 'در بخش زیر می توانید فایل یا لینکی را به پیش نمایش محصول قرار دهید.',
            ),
            array(
                'name'  => 'فایل یا لینک پیش نمایش',
                'id'    => $prefix . 'pre',
                'type'  => 'file_input',
                'class' => 'file_pre',
            ),
        )
    );
    $meta_boxes[] = array(
    'id'         => $prefix .'preview',
    'post_types' => array( 'download', 'product' ),
    'title'  => 'بارگذاری فایل های پیش نمایش محصول',
    'fields' => array(
     array(
        'type' => 'heading',
        'name' => '',
        'desc' => 'نوع پیش نمایش محصول را انتخاب نمایید، توجه کنید که هر محصول فقط می تواند یک نوع پیش نمایش داشته باشد، مجموعه تصاویر، ویدیو یا آهنگ، در صورت عدم انتخاب فقط تصویر شاخص محصول نمایش داده میشود.
        <br><span class="'.$dclass.'">در حالت ووکامرس از بخش گالری محصول مجموعه تصاویر را آپلود نمایید.</span>',
    ),
      array(
                'name'  => 'نوع پیش نمایش',
                'id'    => $prefix . 'pre_type',
                'type'  => 'radio',
                'inline' => true,
                'options' => array(
                    'pre_slides' => 'مجموعه تصاویر',
                    'pre_video' => 'ویدیو',
                    'pre_music' => 'آهنگ',
                    'pre_aparat' => 'آپارات',
                ),
      ),
      array(
        'id'               => $prefix . 'images',
        'name'             => 'بارگذاری تصاویر',
        'type'             => 'image_advanced',
        'force_delete'     => false,
        'class' => 'az_image_file_input ' . $spclass,
      ),
      array(
        'name'             => 'بارگذاری ویدیو',
        'id'               => $prefix . 'video',
        'type'             => 'file_input',
        'force_delete'     => false,
        'class' => 'az_video_file_input',
      ),
      array(
        'name'             => 'بارگذاری آهنگ',
        'id'               => $prefix . 'audio',
        'type'             => 'file_input',
        'force_delete'     => false,
        'class' => 'az_music_file_input',
      ),
      array(
                'name'  => 'آپارات',
                'id'    => $prefix . 'aparat',
                'type'  => 'text',
                'desc'  => 'فقط شناسه ویدیو را وارد نمایید، مثال: Uxmit',
                'class' => 'az_aparat_text_input',
     ),
    ),
  );
    $meta_boxes[] = array(
        'id'         => $prefix .'psettings',
        'title'      => 'تنظیمات صفحه',
        'post_types' => array( 'page', 'post' ),
        'fields'     => array(
            array(
                'name'  => 'تنظیمات سایدبار',
                'id'    => $prefix . 'wside',
                'type'  => 'radio',
                'inline' => true,
                'options' => array(
                    'dside' => 'تنظیمات پیش فرض',
                    'noside' => 'بدون سایدبار',
                    'rside' => 'سایدبار راست',
                    'lside' => 'سایدبار چپ',
                ),
            ),
            array(
                'name'  => 'عدم نمایش نان ریزه ها (مسیر نوشته یا برگه)',
                'id'    => $prefix . 'bread',
                'type'  => 'checkbox',
            ),
            )
    );
    $meta_boxes[] = array(
        'id'         => $prefix .'links',
        'title'      => 'باکس دانلود',
        'post_types' => array( 'download', 'post', 'product' ),
        'fields'     => array(
            array(
                'name'  => 'نمایش باکس دانلود',
                'id'    => $prefix . 'dbox',
                'type'  => 'checkbox',
            ),
            array(
                'name'  => 'نام فایل',
                'id'    => $prefix . 'fname',
                'type'  => 'text',
            ),
            array(
                'name'  => 'حجم',
                'id'    => $prefix . 'fsize',
                'type'  => 'text',
            ),
            array(
                'name'  => 'کلمه عبور',
                'id'    => $prefix . 'fpass',
                'type'  => 'text',
                'std' => $az_data['dl_box_pass'],
            ),
            array(
            'type' => 'heading',
            'name' => '',
            'desc' => 'نوع باکس دانلود را مشخص نمایید، در حالت اول در هر فیلد متن بنویسید به صورت عنوان پارت ها نمایش داده شده و نام فایل موجود در لینک به صورت اتوماتیک به عنوان متن لینک دانلود نمایش داده می شود، در حالت دوم در کادر اول لینک فایل و در کادر دوم نام فایل را وارد نمایید تا به ترتیب به عنوان متن لینک و لینک نمایش داده شود.',
            ),
            array(
                'name'  => 'نوع باکس دانلود',
                'id'    => $prefix . 'box_type',
                'type'  => 'radio',
                'inline' => true,
                'options' => array(
                    'box_part' => 'مناسب فایل چند پارت',
                    'box_single' => 'مناسب فایل های تکی',
                ),
            ),
            array(
            'id'   => $prefix .'furl',
            'name' => 'لینک(ها)',
            'type' => 'text',
            'add_button' => 'اضافه کردن',
            'clone' => true,
            'sort_clone' => true
            ),
        )
    );
    return $meta_boxes;
}

add_filter('rwmb_media_add_string', 'prefix_change_add_string');
function prefix_change_add_string()
{
    return '+ اضافه کردن';
}
add_filter('rwmb_media_edit_string', 'prefix_change_edit_string');
function prefix_change_edit_string()
{
    return 'ویرایش';
}
add_filter('rwmb_media_remove_string', 'prefix_change_remove_string');
function prefix_change_remove_string()
{
    return 'حذف';
}

//Replace video cover by post thumbnail
function grunwell_video_embed($attr, $content='')
{
    if (! isset($attr['poster']) && has_post_thumbnail()) {
        $poster = wp_get_attachment_image_src(get_post_thumbnail_id(), 'full');
        $attr['poster'] = $poster['0'];
    }
 
    return wp_video_shortcode($attr, $content);
}
if($az_data['show_vcover_thumb']){
add_shortcode('video', 'grunwell_video_embed');
}

//Add role name to comment author's name
add_filter(
    'get_comment_author',
    function ($author, $comment_ID, $comment) {
        global $az_data;
        $post = get_post();
        $download_id = get_the_ID();
        $user_id = $comment->user_id;
        if (get_post_type() == 'download' && $az_data['show_scomm'] && !is_admin()) {
            if (user_can($user_id, 'manage_options')) {
                $author = $author . '<span class="comment-admin"> '.$az_data['text_admin'].'</span>';
            } elseif ($post->post_author == $comment->user_id) {
                $author = $author . '<span class="comment-seller"> '.$az_data['text_seller'].'</span>';
            } elseif (edd_has_user_purchased($user_id, $download_id)) {
                $author = $author . '<span class="comment-buyer"> '.$az_data['text_customer'].'</span>';
            } else {
                $author = $author;
            }
        }
        if (get_post_type() == 'post' && $az_data['show_scomm'] && !is_admin()) {
            if (user_can($user_id, 'manage_options')) {
                $author = $author . '<span class="comment-admin"> '.$az_data['text_admin'].'</span>';
            }
        }
        
        return $author;
    },
    10,
    3
);


function remove_admin_bar()
{
    global $az_data;
    if (current_user_can('administrator') && $az_data['show_abar_admin']) {
        add_filter('show_admin_bar', '__return_true');
    } else {
        add_filter('show_admin_bar', '__return_false');
    }
}
if ($az_data['show_abar']) {
    add_action('after_setup_theme', 'remove_admin_bar');
}

function posticon($p_id)
{
    global $az_data;
    $posticon = (rwmb_meta('file_p_type', '', $p_id) != '' ? rwmb_meta('file_p_type', '', $p_id) : 'download');
    if (!rwmb_meta('file_coming', '', $p_id)) {
        if (az_woo()) {
            if (azin_woo_free($p_id)) {
                $price = $az_data['text_dl'];
            } else {
                $price = $az_data['text_buy'];
            }
        } elseif (edd_is_free_download($p_id) && $az_data['free_price']) {
            $price = $az_data['text_dl'];
        } else {
            $price = $az_data['text_buy'];
        }
    } else {
        $price=$az_data['text_coming_soon'];
    }
    echo '<i class="fas fa-'.$posticon.'"></i> '.$price;
}

function p_img()
{
    if (has_post_thumbnail()) {
        the_post_thumbnail('single-download');
    } else {
        echo '<img src="'.esc_url(get_template_directory_uri()).'/images/tumb.png" alt="'.the_title_attribute('echo=0').'" class="post-tumb"/>';
    }
}

function p_mimg()
{
    if (has_post_thumbnail()) {
        $imgdata = wp_get_attachment_image_src(get_post_thumbnail_id(), 'single-download-m');
        if ($imgdata[3]) {
            the_post_thumbnail('single-download-m');
        } else {
            the_post_thumbnail('single-download');
        }
    } else {
        echo '<img src="'.esc_url(get_template_directory_uri()).'/images/tumb.png" alt="'.the_title_attribute('echo=0').'" class="post-tumb"/>';
    }
}

function add_classes_to_linked_images($html)
{
    $classes = 'timg'; //can do multiple classes, separate with space

    $patterns = array();
    $replacements = array();
    $patterns[0] = '/<a(?![^>]*class)([^>]*)>\s*<img([^>]*)>\s*<\/a>/'; //matches img tag wrapped in anchor tag where anchor tag has no existing classes
    $replacements[0] = '<a\1 class="' . $classes . '"><img\2></a>';
    $html = preg_replace($patterns, $replacements, $html);
    return $html;
}

if ($az_data['slide_img']) {
    add_filter('the_content', 'add_classes_to_linked_images', 100, 1);
}

remove_action('template_redirect', 'rest_output_link_header', 11, 0);
remove_action('wp_head', 'rest_output_link_wp_head', 10);

/**
 * Filter the except length to 20 words.
 *
 * @param int $length Excerpt length.
 * @return int (Maybe) modified excerpt length.
 */
function wpdocs_custom_excerpt_length($length)
{
    return 22;
}
add_filter('excerpt_length', 'wpdocs_custom_excerpt_length', 999);

//page or post sidebar setting
function p_sidebar($id)
{
    global $az_data;
    $class = '';
    $side_type = rwmb_meta('file_wside', '', $id);
    if ($side_type == 1 || $side_type == 'noside') {
        $class = 'wside col-12';
    } elseif ($side_type == 'rside') {
        $class = 'col-lg-9 col-12 right-side';
    } elseif ($side_type == 'lside') {
        $class = 'col-lg-9 col-12';
    } else {
        if ($az_data['side_type'] == 2) {
            $class = 'col-lg-9 col-12 right-side';
        } else {
            $class = 'col-lg-9 col-12';
        }
    }
    return $class;
}

/**
* Updating the subscriber role
*/


$subscriber_role = get_role('subscriber');

if ($subscriber_role) {
    // Adding a new capability to role
    $subscriber_role->add_cap('view_ticket');
    $subscriber_role->add_cap('create_ticket');
    $subscriber_role->add_cap('close_ticket');
    $subscriber_role->add_cap('reply_ticket');
    $subscriber_role->add_cap('attach_files');
}

$customer_role = get_role('customer');

if ($customer_role) {
    // Adding a new capability to role
    $customer_role->add_cap('view_ticket');
    $customer_role->add_cap('create_ticket');
    $customer_role->add_cap('close_ticket');
    $customer_role->add_cap('reply_ticket');
    $customer_role->add_cap('attach_files');
}

$seller_role = get_role('seller');

if ($seller_role) {
    // Adding a new capability to role
    $seller_role->add_cap('view_ticket');
    $seller_role->add_cap('create_ticket');
    $seller_role->add_cap('close_ticket');
    $seller_role->add_cap('reply_ticket');
    $seller_role->add_cap('attach_files');
}

if (class_exists('Affiliate_WP')) {
    add_filter('page_template', 'affiliate_page_template');
    function affiliate_page_template($page_template)
    {
        global $post;
        $post_id = $post->ID;
        if ($post_id === affwp_get_affiliate_area_page_id()) {
            $page_template = get_stylesheet_directory() . '/affiliate-area.php';
        }
        return $page_template;
    }
}

if (class_exists('Awesome_Support')) {
    add_filter('page_template', 'ticket_page_template');
    function ticket_page_template($page_template)
    {
        global $post;
        $ticket_id = wpas_get_option('ticket_list');
        $ticket_submit_id = wpas_get_option('ticket_submit');
        if (is_array($ticket_submit_id)) {
            $ticket_submit = $ticket_submit_id[0];
        } else {
            $ticket_submit = $ticket_submit_id;
        }
        $post_id = $post->ID;
        if (($post_id === (int)$ticket_id) || ($post_id === (int)$ticket_submit)) {
            $page_template = get_stylesheet_directory() . '/tickets.php';
        }
        return $page_template;
    }
}

add_action( 'wp_footer', 'azin_share_modal' );
function azin_share_modal() {
    global $post;
    if('post' == $post->post_type || 'product' == $post->post_type || 'download' == $post->post_type ) {
    ?>
    <!-- The Share Modal -->
<div class="modal fade" id="shareModal">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <!-- Share Modal Header -->
      <div class="modal-header">
        <h4 class="modal-title"><i class="fas fa-share-alt" aria-hidden="true"></i>اشتراک گذاری در شبکه های اجتماعی</h4>
        <button type="button" class="close" data-dismiss="modal">
            <i class="fas fa-times" aria-hidden="true"></i>
        </button>
      </div>
      <!-- Share Modal body -->
      <div class="modal-body">
        <ul class="social-box">
            <li><a data-toggle="tooltip" data-placement="top" title="فیسبوک" href="http://www.facebook.com/sharer.php?u=<?php echo wp_get_shortlink(); ?>" target="_blank"><i class="fab fa-facebook" aria-hidden="true"></i></a></li>
            <li><a data-toggle="tooltip" data-placement="top" title="گوگل پلاس" href="https://plus.google.com/share?url=<?php echo wp_get_shortlink(); ?>" target="_blank"><i class="fab fa-google-plus" aria-hidden="true"></i></a></li>
            <li><a data-toggle="tooltip" data-placement="top" title="پینترست" href="http://pinterest.com/pin/create/link/?url=<?php echo wp_get_shortlink(); ?>" target="_blank"><i class="fab fa-pinterest-p" aria-hidden="true"></i></a></li>
            <li><a data-toggle="tooltip" data-placement="top" title="توئیتر" href="http://www.twitter.com/share?url=<?php echo wp_get_shortlink(); ?>" target="_blank"><i class="fab fa-twitter" aria-hidden="true"></i></a></li>
            <li><a data-toggle="tooltip" data-placement="top" title="لینکداین" href="http://www.linkedin.com/shareArticle?mini=true&url=<?php echo wp_get_shortlink(); ?>" target="_blank"><i class="fab fa-linkedin" aria-hidden="true"></i></a></li>
            <li><a data-toggle="tooltip" data-placement="top" title="کلوب" href="http://www.cloob.com/share/link/add?url=<?php echo wp_get_shortlink(); ?>" target="_blank"><i class="ico-cloob" aria-hidden="true"></i></a></li>
            <li><a data-toggle="tooltip" data-placement="top" title="تلگرام" href="https://telegram.me/share/url?url=<?php echo wp_get_shortlink(); ?>" target="_blank"><i class="ico-telegram" aria-hidden="true"></i></a></li>
            <li><a data-toggle="tooltip" data-placement="top" title="ایمیل" href="mailto:?subject=<?php the_title(); ?>&body=<?php echo wp_get_shortlink(); ?>" target="_blank"><i class="fas fa-envelope" aria-hidden="true"></i></a></li>
        </ul>
        <div class="short-con">
            <span class="short-text">پیوند کوتاه:</span>
            <span class="short-link"><?php echo wp_get_shortlink(); ?></span>
            <span data-toggle="tooltip" data-placement="top" title="کپی پیوند" class="short-btn" onclick="copyToClipboard('.short-link')"><i class="fas fa-copy" aria-hidden="true"></i></span>
        </div>
        <div class="link-copy">پیوند کپی شد!</div>
      </div>

    </div>
  </div>
</div>
<?php } }

function azin_bread(){
    global $az_data;
    $page_bread = rwmb_meta('file_bread', '', get_the_ID());
    if ($az_data['show_bread'] && !is_front_page() && !is_home() && !$page_bread) { ?>
        <div class="row">
            <div class="col-12">
                <?php
                if( function_exists('yoast_breadcrumb') ) {
                $breadcrumbs_enabled = WPSEO_Options::get( 'breadcrumbs-enable', false );
                }
                if(az_woo()) {
                    woocommerce_breadcrumb();
                } elseif( function_exists('yoast_breadcrumb') && $breadcrumbs_enabled ) {
                    yoast_breadcrumb( '<p class="breadcrumbs" id="breadcrumbs">','</p>' );
                } else {
                    breadcrumb();
                } ?>
            </div>
        </div>
    <?php }
}

function side_type(){
    global $az_data;
    $side_type = rwmb_meta('file_wside', '', get_the_ID());
    if (($side_type == '' || $side_type == 'dside') && $az_data['side_type'] == 2) {
        $side_type = 'rside';
    } elseif ($side_type == 'rside') {
        $side_type = 'rside';
    }
    echo ' ' . $side_type;
}