<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: Hosseinkhani.ir
*/
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}
azinc();
global $az_data;
if (!current_user_can('administrator')) {
    if ($az_data['maintenance']) {
        get_template_part('under-page');
        die();
    }
}
?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=<?php bloginfo('charset'); ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <meta name="theme-color" content="<?php echo $az_data['msg_bgcolor']; ?>" />
    <meta name="fontiran.com:license" content="B3L8B">
    <link rel="shortcut icon" href="<?php echo $az_data['site_favicon']['url']; ?>" type="image/x-icon" />
    <?php
      if (is_singular()) {
          wp_enqueue_script('comment-reply');
      }
      ?>
    <link rel="alternate" type="appliction/rss+xml" href="<?php bloginfo('rss2_url'); ?>" title="<?php printf(__('آخرین مطالب %s', 'mytheme'), esc_html(get_bloginfo('name'), 1)); ?>" />
    <link rel="alternate" type="appliction/rss+xml" href="<?php bloginfo('comments_rss2_url'); ?>" title="<?php printf(__('آخرین نظرات %s', 'mytheme'), esc_html(get_bloginfo('name'), 1)); ?>" />
    <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
    <?php wp_head(); ?>
</head>

<body id="top" <?php body_class(); ?><?php if($az_data['site_schema']) {?> itemscope itemtype="https://schema.org/WebPage"<?php } ?>>

<?php edd_az();
if ($az_data['show_page_loading']) { ?>
<div class="se-pre-con"></div>
<?php } ?>

    <header <?php if ($az_data['site_schema']) { ?>itemscope itemtype="https://schema.org/Organization"<?php } ?>>
        <?php if ($az_data['site_schema']) { echo '<meta itemprop="url" content="'.esc_url(home_url()).'">'; } ?>
        
        <!-- mobile menu -->
        <div id="mSidenav" class="sidemnav">
            <div class="side-mhead">
                <a href="javascript:void(0)" class="closebtn" onclick="closemNav()">&times;</a>
                <?php if(!$az_data['mobile_search']){ ?>
                <form role="search" method="get" class="col-12 msform" action="<?php echo esc_url(home_url()); ?>">
                    <div class="input-group input-group-lg">
                        <?php if ($az_data['search_type']) { ?>
                        <span class="input-group-before s-select">
                            <select aria-label="Post type" name="post_type">
                                <?php if (az_woo()) { ?>
                                <option value="product">
                                <?php echo $az_data['text_shop']; ?>
                                </option>
                                <?php } else {  ?>
                                <option value="download">
                                <?php echo $az_data['text_shop']; ?>
                                </option>
                                <?php } ?>
                                <option value="post">
                                    <?php echo $az_data['text_blog']; ?>
                                </option>
                            </select>
                        </span>
                        <?php } else { ?>
                            <?php if (az_woo()) { ?>
                            <input type="hidden" value="product" name="post_type">
                            <?php } else {  ?>
                            <input type="hidden" value="download" name="post_type">
                            <?php } ?>
                        <?php } ?>
                        <input aria-label="Search" type="text" name="s" class="form-control msh<?php if (!$az_data['search_type']) { ?> sntype<?php } ?>" placeholder="<?php echo $az_data['text_search']; ?>" required>
                        <span class="input-group-append">
                            <button type="submit" aria-label="Search" id="searchsubmith" class="btn btn-search"><i class="fas fa-search"></i></button>
                        </span>
                    </div>
                </form>
                <?php } ?>
            </div>
            <nav <?php if ($az_data['site_schema']) {?>itemscope itemtype="https://schema.org/SiteNavigationElement"<?php } ?> id="cssmenu">
            <?php
            wp_nav_menu(array(
            'menu'              => 'primary',
            'theme_location'    => 'primary',
            'container_id' => 'cssmenu',
            'fallback_cb'       => 'CSS_Menu_Maker_fallback',
            'walker' => new CSS_Menu_Maker_Walker()
            ));
            ?>
            </nav>
        </div>
        <div id="mCanvasNav" class="overlay3" onclick="closemNav()"></div>
        <!-- mobile menu -->

        <?php if (is_user_logged_in()) { ?>
        <!-- side user-menu -->
        <div id="mySidenav" class="sidenav">
            <div class="side-head">
                <a href="javascript:void(0)" class="closebtn" onclick="closeNav()">&times;</a>
                <?php
                $user = wp_get_current_user();
                echo get_avatar(get_current_user_id(), 65, '', $user->display_name); ?>
                <span class="side-uname">
                    <?php echo $user->display_name; ?></span>
                <?php
                if (class_exists('EDD_Wallet')) {
                    $wallet = edd_currency_filter(edd_wallet()->wallet->balance(get_current_user_id()));
                    echo '<span class="m-wallet">'.$wallet.'</span>';
                }
                if (class_exists('WooWallet')) {
                    $wallet = woo_wallet()->wallet->get_wallet_balance(get_current_user_id());
                    echo '<span class="m-wallet">'.$wallet.'</span>';
                }
                ?>
            </div>
            <ul class="usmenu">
                <?php
                if (az_woo()) {
                    require AZ_DIR .'/includes/woo/umenu.php';
                } else {
                    require AZ_DIR .'/includes/umenu.php';
                }
                ?>
            </ul>
        </div>
        <div id="myCanvasNav" class="overlay3" onclick="closeNav()"></div>
        <!-- side user-menu -->
        <?php } ?>

        <!-- Massage Box -->
        <?php if ($az_data['show_msg']) { ?>
            <div class="container-fluid msg-con">
                <div class="container msg" role="alert">
                    <div class="row">
                        <div class="col-12 col-md-10 msg-txt">
                            <span class="<?php echo $az_data['msg_icon']; ?>" aria-hidden="true"></span>
                            <?php echo $az_data['site_msg']; ?>
                        </div>
                        <?php if ($az_data['msg_btn']) { ?>
                        <div class="col-12 col-md-2">
                        <a class="msg-btn btn <?php echo $az_data['msg_btn_color']; ?>" href="<?php echo $az_data['msg_btn_link']; ?>" title="<?php echo $az_data['msg_btn_text']; ?>">
                            <?php echo $az_data['msg_btn_text']; ?>
                            <i class="fas fa-angle-left"></i>
                        </a>
                        </div>
                        <?php } ?>
                    </div>
            </div>
            <?php if ($az_data['user_close']) { ?>
                    <span role="button" class="fas fa-times close" aria-label="Close" aria-hidden="true"></span>
            <?php } ?>
            </div>
        <?php } ?>
        <!-- Massage Box -->

        <div class="container-fluid head">

            <div class="container header hidden-xs">

                <!-- .row-social -->
                <div class="row row-social<?php if ($az_data['social_pos'] == 2) { echo ' social-right'; }?>">

                    <!-- Header Contact -->
                    <div class="col-md-6 col-12 head-contact">
                        <?php if ($az_data['header_nav']) { ?>
                        <nav class="header-nav" <?php if ($az_data['site_schema']) {?>itemscope itemtype="https://schema.org/SiteNavigationElement"<?php } ?>>
                            <?php
                            wp_nav_menu(
                                array(
                                    'menu'              => 'header',
                                    'theme_location'    => 'header',
                                    'depth'             => 1,
                                    'container'         => 'div'
                                )
                            );
                            ?>
                        </nav>
                        <?php } else { ?>
                        <?php if ($az_data['show_contact']) { ?>
                        <div class="tel">

                            <?php if ($az_data['site_tel']!='') { ?>
                            <div class="top-tel">
                                <span class="fas fa-phone-square" aria-hidden="true"></span> <span class="top-val" id="site-tel" <?php if ($az_data['site_schema']) {?>itemprop="telephone"<?php } ?>>
                                <?php echo $az_data['site_tel']; ?></span>
                            </div>
                            <?php } ?>

                            <?php if ($az_data['site_email']!='') { ?>
                            <div class="top-tel">
                                <span class="fas fa-envelope" aria-hidden="true"></span> <span class="top-val" id="site-email">
                                <?php echo $az_data['site_email']; ?></span>
                            </div>
                            <?php } ?>

                        </div>
                        <?php } else { ?>
                        <span class="date">
                            <?php echo $az_data['text_date'] . ' ' . parsidate('l، j F Y '); ?></span>
                        <?php } }?>
                    </div>
                    <!-- Header Contact -->

                    <!-- Header Social Buttons -->
                    <div class="col-md-6 col-12 head-social">
                        <ul class="social">
                            <?php if ($az_data['so_facebook']) { ?>
                            <li>
                            <a <?php if ($az_data['site_schema']) {?>itemprop="sameAs" <?php } ?> aria-label="فیسبوک" href="<?php echo $az_data['so_facebook_link']; ?>" target="_blank">
                            <i class="fab fa-facebook"></i>
                            </a>
                            </li>
                            <?php } ?>
                            <?php if ($az_data['so_google']) { ?>
                            <li>
                            <a <?php if ($az_data['site_schema']) {?>itemprop="sameAs" <?php } ?> aria-label="گوگل پلاس" href="<?php echo $az_data['so_google_link']; ?>" target="_blank">
                            <i class="fab fa-google-plus"></i>
                            </a>
                            </li>
                            <?php } ?>
                            <?php if ($az_data['so_twitter']) { ?>
                            <li>
                            <a <?php if ($az_data['site_schema']) {?>itemprop="sameAs" <?php } ?> aria-label="توئیتر" href="<?php echo $az_data['so_twitter_link']; ?>" target="_blank">
                            <i class="fab fa-twitter"></i>
                            </a>
                            </li>
                            <?php } ?>
                            <?php if ($az_data['so_youtube']) { ?>
                            <li>
                            <a <?php if ($az_data['site_schema']) {?>itemprop="sameAs" <?php } ?> aria-label="یوتیوب" href="<?php echo $az_data['so_youtube_link']; ?>" target="_blank">
                            <i class="fab fa-youtube"></i>
                            </a>
                            </li>
                            <?php } ?>
                            <?php if ($az_data['so_dribble']) { ?>
                            <li>
                            <a <?php if ($az_data['site_schema']) {?>itemprop="sameAs" <?php } ?> aria-label="دریبل" href="<?php echo $az_data['so_dribble_link']; ?>" target="_blank">
                            <i class="fab fa-dribbble"></i>
                            </a>
                            </li>
                            <?php } ?>
                            <?php if ($az_data['so_linkedin']) { ?>
                            <li>
                            <a <?php if ($az_data['site_schema']) {?>itemprop="sameAs" <?php } ?> aria-label="لینکداین" href="<?php echo $az_data['so_linkedin_link']; ?>" target="_blank">
                            <i class="fab fa-linkedin"></i>
                            </a>
                            </li>
                            <?php } ?>
                            <?php if ($az_data['so_instagram']) { ?>
                            <li>
                            <a <?php if ($az_data['site_schema']) {?>itemprop="sameAs" <?php } ?> aria-label="اینستاگرام" href="<?php echo $az_data['so_instagram_link']; ?>" target="_blank">
                            <i class="fab fa-instagram"></i>
                            </a>
                            </li>
                            <?php } ?>
                            <?php if ($az_data['so_cloob']) { ?>
                            <li>
                            <a <?php if ($az_data['site_schema']) {?>itemprop="sameAs" <?php } ?> aria-label="کلوپ" href="<?php echo $az_data['so_cloob_link']; ?>" target="_blank">
                            <i class="ico-cloob"></i>
                            </a>
                            </li>
                            <?php } ?>
                            <?php if ($az_data['so_telegram']) { ?>
                            <li>
                            <a <?php if ($az_data['site_schema']) {?>itemprop="sameAs" <?php } ?> aria-label="تلگرام" href="<?php echo $az_data['so_telegram_link']; ?>" target="_blank">
                            <i class="ico-telegram"></i>
                            </a>
                            </li>
                            <?php } ?>
                            <?php if ($az_data['so_aparat']) { ?>
                            <li>
                            <a <?php if ($az_data['site_schema']) {?>itemprop="sameAs" <?php } ?> aria-label="آپارات" href="<?php echo $az_data['so_aparat_link']; ?>" target="_blank">
                            <i class="ico-aparat"></i>
                            </a>
                            </li>
                            <?php } ?>
                            <?php if ($az_data['so_gap']) { ?>
                            <li>
                            <a <?php if ($az_data['site_schema']) {?>itemprop="sameAs" <?php } ?> aria-label="گپ" href="<?php echo $az_data['so_gap_link']; ?>" target="_blank">
                            <i class="ico-Gap"></i>
                            </a>
                            </li>
                            <?php } ?>
                            <?php if ($az_data['so_eitaa']) { ?>
                            <li>
                            <a <?php if ($az_data['site_schema']) {?>itemprop="sameAs" <?php } ?> aria-label="ایتا" href="<?php echo $az_data['so_eitaa_link']; ?>" target="_blank">
                            <i class="ico-Eitaa"></i>
                            </a>
                            </li>
                            <?php } ?>
                            <?php if ($az_data['so_bisphone']) { ?>
                            <li>
                            <a <?php if ($az_data['site_schema']) {?>itemprop="sameAs" <?php } ?> aria-label="بیسفون" href="<?php echo $az_data['so_bisphone_link']; ?>" target="_blank">
                            <i class="ico-Bisphone"></i>
                            </a>
                            </li>
                            <?php } ?>
                            <?php if ($az_data['so_bale']) { ?>
                            <li>
                            <a <?php if ($az_data['site_schema']) {?>itemprop="sameAs" <?php } ?> aria-label="بله" href="<?php echo $az_data['so_bale_link']; ?>" target="_blank">
                            <i class="ico-Bale"></i>
                            </a>
                            </li>
                            <?php } ?>
                            <?php if ($az_data['so_soroush']) { ?>
                            <li>
                            <a <?php if ($az_data['site_schema']) {?>itemprop="sameAs" <?php } ?> aria-label="سروش" href="<?php echo $az_data['so_soroush_link']; ?>" target="_blank">
                            <i class="ico-Soroush"></i>
                            </a>
                            </li>
                            <?php } ?>
                            <?php if ($az_data['so_igap']) { ?>
                            <li>
                            <a <?php if ($az_data['site_schema']) {?>itemprop="sameAs" <?php } ?> aria-label="آی گپ" href="<?php echo $az_data['so_igap_link']; ?>" target="_blank">
                            <i class="ico-iGap"></i>
                            </a>
                            </li>
                            <?php } ?>
                            <?php if ($az_data['so_pinterest']) { ?>
                            <li>
                            <a <?php if ($az_data['site_schema']) {?>itemprop="sameAs" <?php } ?> aria-label="پینترست" href="<?php echo $az_data['so_pinterest_link']; ?>" target="_blank" ><i class="fab fa-pinterest"></i>
                            </a>
                            </li>
                            <?php } ?>
                        </ul>
                    </div>
                    <!-- Header Social Buttons -->

                </div>
                <!-- /.row-social -->
                
                <!-- .row-logo -->
                <div class="row row-logo <?php if ($az_data['logo_pos'] == 2) { echo 'logo-right'; }?>">

                    <div class="col-md-3 hidden-xs user-btns">
                    <?php if ($az_data['show_user_btn']) {
                    if (is_user_logged_in()) {
                        $user = wp_get_current_user(); ?>
                        <div class="dropdown">
                            <button class="dropdown-toggle user-btn" type="button" data-toggle="dropdown">
                                <?php echo get_avatar(get_current_user_id(), 30, '', $user->display_name); ?>
                                <span class="user-name"><?php echo $user->display_name; ?></span>
                                <?php if (class_exists('EDD_Wallet')) { 
                                    echo '<span class="hidden-sm">';
                                    $wallet = edd_currency_filter(edd_wallet()->wallet->balance(get_current_user_id()));
                                    echo ' | '. $wallet;
                                    echo '</span>';
                                }
                                if (class_exists('WooWallet')) {
                                    echo '<span class="hidden-sm">';
                                    $wallet = woo_wallet()->wallet->get_wallet_balance(get_current_user_id());
                                    echo ' | '. $wallet;
                                    echo '</span>';
                                } ?>
                                <span class="caret"></span>
                            </button>
                            <ul class="dropdown-menu user-menu mu-menu">
                                <?php
                                    if (az_woo()) {
                                        require AZ_DIR .'/includes/woo/umenu.php';
                                    } else {
                                        require AZ_DIR .'/includes/umenu.php';
                                    } ?>
                            </ul>
                        </div>
                    <?php } else { ?>

                        <?php if ( function_exists('digits_version') && $az_data['digits_mode'] ) { ?>
                        <?php if( $az_data['digits_page']) { $digits_mode = 'digitlink';} else { $digits_mode = 'digitpopup'; } ?>
                            <span title="ورود یا عضویت" class="btn btn-primary user-btn reg-btn digitsbtn <?php echo $digits_mode; ?>">
                                <i aria-hidden="true" class="fas fa-user"></i>
                                <span class="hidden-sm">ورود</span>
                                /
                                <i aria-hidden="true" class="fas fa-user-plus"></i>
                                <span class="hidden-sm">عضویت</span>
                            </span>
                        <?php } else { ?>
                        <a class="user-btn login-btn btn btn-outline-primary" <?php if (!$az_data['ch_login_link']) { echo 'href="#" data-toggle="modal" data-target="#login"';
                            } else {
                            echo 'href="' .$az_data['login_link'].'"';
                            } ?>>
                            <span class="fas fa-user user-icon"></span>
                            <span class="hidden-sm"><?php echo $az_data['text_login']; ?></span>
                        </a>

                        <a <?php if (!$az_data['ch_register_link']) {
                            if (az_woo()) {
                                echo 'href="' .esc_url(home_url()).'/my-account"';
                            } else {
                                echo 'href="' .esc_url(home_url()).'/register"';
                            }
                        } else {
                            echo 'href="' .$az_data['register_link'].'"';
                        } ?> title="<?php echo $az_data['text_reg_hint']; ?>" class="btn btn-primary user-btn reg-btn">
                            <span class="fas fa-user-plus reg-icon"></span>
                            <span class="hidden-sm"><?php echo $az_data['text_register']; ?></span>
                        </a>

                        <?php }//End $az_data['digits_mode'] ?>

                        <?php }//End is_user_logged_in() ?>

                        <?php }//End $az_data['show_user_btn'] ?>
                    </div>
                    
                    <div class="col-md-6 s-form">
                        <form role="search" method="get" id="searchformh" class="col-md-11 col-12" action="<?php echo esc_url(home_url()); ?>">
                            <div class="input-group input-group-lg">
                            <?php if ($az_data['search_type']) { ?>
                                <span class="input-group-before s-select">
                                    <select aria-label="Post type" name="post_type">
                                    <?php if (az_woo()) { ?>
                                        <option value="product">
                                        <?php echo $az_data['text_shop']; ?>
                                        </option>
                                    <?php } else {  ?>
                                        <option value="download">
                                        <?php echo $az_data['text_shop']; ?>
                                        </option>
                                    <?php } ?>
                                        <option value="post">
                                        <?php echo $az_data['text_blog']; ?>
                                        </option>
                                    </select>
                                </span>
                                <?php } else { ?>
                                <?php if (az_woo()) { ?>
                                <input type="hidden" value="product" name="post_type">
                                <?php } else {  ?>
                                <input type="hidden" value="download" name="post_type">
                                <?php } ?>
                                <?php } ?>
                                <input autocomplete="off" <?php if ($az_data['ajax_search']) { echo ' data-swplive="true"' ; } ?> aria-label="Search" type="text" value="" name="s" id="sh" class="form-control <?php if (!$az_data['search_type']) { ?> sntype <?php } ?>" placeholder="<?php echo $az_data['text_search']; ?>" required>
                                <span class="input-group-append">
                                    <button type="submit" aria-label="Search" id="searchsubmith" class="btn btn-search"><i class="fas fa-search"></i></button>
                                </span>
                            </div>
                        </form>
                    </div>

                    <div role="banner" class="col-md-3 col-12 logo">
                        <?php if (!is_single() && !is_page()) { ?>
                        <?php if ( !$az_data['show_archive_desc'] || empty(get_the_archive_description()) ) { ?>
                            <h1>
                        <?php } } ?>
                        <a href="<?php echo esc_url(home_url()); ?>" title="<?php bloginfo('name'); ?> | <?php bloginfo('description'); ?>" rel="home">
                            <img <?php if ($az_data['site_schema']) {?>itemprop="logo" <?php } ?> src="<?php echo $az_data['site_logo']['url']; ?>" srcset="<?php echo $az_data['site_logo_retina']['url']; ?> 2x" alt="<?php bloginfo('name'); ?> | <?php bloginfo('description'); ?>" title="<?php bloginfo('name'); ?> | <?php bloginfo('description'); ?>" class="img-logo"/>
                            <strong>
                                <?php bloginfo('name'); ?> | <?php bloginfo('description'); ?>
                            </strong>
                        </a>
                        <?php if (!is_single() && !is_page()) { ?>
                        <?php if ( !$az_data['show_archive_desc'] || empty(get_the_archive_description()) ) { ?>
                            </h1>
                        <?php } } ?>
                    </div>

                </div>

            </div>

        </div>
        
        <nav class="nav navbar-expand-sm<?php if ($az_data['fixed_head_top']) { echo ' fixed-nav'; }?>" id="nav-row" <?php if ($az_data['site_schema']) {?>itemscope itemtype="https://schema.org/SiteNavigationElement"<?php } ?>>
            <div class="container hidden-xs nav-con">
                <!-- Collect the nav links from WordPress -->
                <div class="collapse navbar-collapse" id="bootstrap-nav-collapse">         
                    <?php 
                    $args = array(
                        'menu'              => 'primary',
                        'theme_location'    => 'primary',
                        'depth'             => 4,
                        'container'         => 'div',
                        'menu_class'        => 'nav navbar-nav yamm',
                        'fallback_cb'       => 'Yamm_Nav_Walker_menu_fallback',
                        'walker'            => new Yamm_Nav_Walker()
                        );
                    wp_nav_menu($args);
                ?>
                </div><!-- ./collapse -->
                <?php if ($az_data['blog_menu']) { ?>
                <a class="btn <?php echo $az_data['blog_color']; ?> blog-btn hidden-sm" href="<?php echo $az_data['blog_link']; ?>">
                    <?php echo '<span class="'.$az_data['blog_icon']. '"></span> ' . $az_data['blog_text']; ?>
                </a>
                <?php } ?>
            </div>

            <div class="visible-xs mobile-header">
                <span class="btn btn-outline-primary mm-btn" onclick="openmNav()">
                    <i class="fas fa-bars"></i>
                </span>
                <a class="m-logo" href="<?php echo esc_url(home_url()); ?>" title="<?php bloginfo('name'); ?> | <?php bloginfo('description'); ?>" rel="home">
                    <img src="<?php echo $az_data['site_logo']['url']; ?>" srcset="<?php echo $az_data['site_logo_retina']['url']; ?> 2x" alt="<?php bloginfo('name'); ?> | <?php bloginfo('description'); ?>" title="<?php bloginfo('name'); ?> | <?php bloginfo('description'); ?>" />
                </a>
                <?php if ($az_data['show_user_btn']) {
                if (is_user_logged_in()) { ?>
                <div class="muser-btns">
                    <span class="btn btn-outline-primary ml-btn" onclick="openNav()">
                        <i class="fas fa-user-circle"></i>
                    </span>
                </div>
                <?php } else { ?>
                <div class="muser-btns">

                    <?php if ( function_exists('digits_version') && $az_data['digits_mode'] ) { ?>
                        <?php if( $az_data['digits_page']) { $digits_mode = 'digitlink';} else { $digits_mode = 'digitpopup'; } ?>
                            <span title="ورود یا عضویت" class="btn btn-primary digitsbtn <?php echo $digits_mode; ?>">
                                <i aria-hidden="true" class="fas fa-user"></i>
                                /
                                <i aria-hidden="true" class="fas fa-user-plus"></i>
                            </span>
                    <?php } else { ?>
                        <a class="btn btn-outline-primary ml-btn" <?php if (!$az_data['ch_login_link']) { echo 'href="#" data-toggle="modal" data-target="#login"';
                        } else {
                            echo 'href="' .$az_data['login_link'].'"';
                        } ?>>
                            <span class="fas fa-sign-in-alt user-icon"></span>
                        </a>
                        <a <?php if (!$az_data['ch_register_link']) {
                        if (az_woo()) {
                            echo 'href="' .esc_url(home_url()).'/my-account"';
                        } else {
                            echo 'href="' .esc_url(home_url()).'/register"';
                        }
                        } else {
                            echo 'href="' .$az_data['register_link'].'"';
                        } ?> title="<?php echo $az_data['text_reg_hint']; ?>" class="btn btn-primary mu-btn">
                            <span class="fas fa-user-plus"></span>
                        </a>
                    <?php } ?>
                </div>
                <?php } } ?>

                <?php if($az_data['mobile_search']){ ?>
                <div class="mobile-search col-12 d-block d-md-none">
                    <form role="search" method="get" class="col-12 msform" action="<?php echo esc_url(home_url()); ?>">
                        <div class="input-group input-group-lg">
                            <?php if ($az_data['search_type']) { ?>
                            <span class="input-group-before s-select">
                                <select aria-label="Post type" name="post_type">
                                    <?php if (az_woo()) { ?>
                                    <option value="product">
                                    <?php echo $az_data['text_shop']; ?>
                                    </option>
                                    <?php } else {  ?>
                                    <option value="download">
                                    <?php echo $az_data['text_shop']; ?>
                                    </option>
                                    <?php } ?>
                                    <option value="post">
                                        <?php echo $az_data['text_blog']; ?>
                                    </option>
                                </select>
                            </span>
                            <?php } else { ?>
                                <?php if (az_woo()) { ?>
                                <input type="hidden" value="product" name="post_type">
                                <?php } else {  ?>
                                <input type="hidden" value="download" name="post_type">
                                <?php } ?>
                            <?php } ?>
                            <input aria-label="Search" type="text" name="s" class="form-control msh<?php if (!$az_data['search_type']) { ?> sntype<?php } ?>" placeholder="<?php echo $az_data['text_search']; ?>" required>
                            <span class="input-group-append">
                                <button type="submit" aria-label="Search" id="searchsubmith" class="btn btn-search"><i class="fas fa-search"></i></button>
                            </span>
                        </div>
                    </form>
                </div>
                <?php } ?>
            </div>
        </nav>
    </header>


		