<?php
   // remove the standard button that shows after the download's content
   remove_action( 'edd_after_download_content', 'edd_append_purchase_link' );
   /**
    * Easy Digital Downloads
    * Change the button text
  */
   function edd_text_args( $args ) {
    global $az_data;
            $args['text'] = $az_data['text_add_shop'];
            $args['class'] = 'col-md-11 col-12 btn btn-success btn-sm';
    return $args;
   }
   add_filter( 'edd_purchase_link_args', 'edd_text_args' );

   function custom_edd_add_custom_field_support( $supports ) {
    $new = array('custom-fields');
    return array_merge( $new, $supports );
   }
   add_action('init', 'my_custom_init');
   function my_custom_init() {
       add_post_type_support( 'download', 'publicize' );
   }
   //Theme Designed By: Meysam Hosseinkhani   
   //Enable comments on downloads
   function custom_enable_comments( $supports ) {
    return array_merge( $supports, array( 'comments' ) );
   }
   add_filter( 'edd_download_supports', 'custom_enable_comments' );
   
   //Modify Rss Feed to add download post_type
   function myfeed_request($qv) {
       if (isset($qv['feed'])) {
        $qv['post_type'] = array('post', 'download');
    }
    return $qv;
   }
   add_filter('request', 'myfeed_request');


   //Toman EDD Currency
   function edd_rial_currency( $formatted, $currency, $price ) {
       global $az_data;
       if (!is_admin()) {
        $price = str_replace(edd_get_option('thousands_separator', ','), '', $price);
        $price = (int)$price / 10;
        if ($az_data['currency_sep']) { 
        $price = edd_format_amount($price);}
        $price = $price;
           
        return $price . ' تومان';
    } else {
        return $price . ' ریال';
    }
}
  if ($az_data['toman_currency']) {   
   add_filter( 'edd_rial_currency_filter_after', 'edd_rial_currency', 10, 3 );
   add_filter( 'edd_rial_currency_filter_before', 'edd_rial_currency', 10, 3 );
  }

  //Create edit-profile page
   if (isset($_GET['activated']) && is_admin()){
           $new_page_title = 'حساب کاربری';
           $new_page_content = '[edd_profile_editor]';
           $new_page_addr = 'edit-profile';
           $new_page_template = ''; //ex. template-custom.php. Leave blank if you don't want a custom page template.
           //don't change the code bellow, unless you know what you're doing
           $page_check = get_page_by_title($new_page_title);
           $new_page = array(
                   'post_type' => 'page',
                   'post_title' => $new_page_title,
                   'post_name' => $new_page_addr,
                   'post_content' => $new_page_content,
                   'post_status' => 'publish',
                   'post_author' => 1,
           );
           if(!isset($page_check->ID)){
                   $new_page_id = wp_insert_post($new_page);
                   if(!empty($new_page_template)){
                           update_post_meta($new_page_id, '_wp_page_template', $new_page_template);
                   }
           }
   }
   //Create register page
   if (isset($_GET['activated']) && is_admin()){
           $new_page_title = 'ثبت نام';
           $new_page_content = '[edd_register]';
           $new_page_addr = 'register';
           $new_page_template = ''; //ex. template-custom.php. Leave blank if you don't want a custom page template.
           //don't change the code bellow, unless you know what you're doing
           $page_check = get_page_by_title($new_page_title);
           $new_page = array(
                   'post_type' => 'page',
                   'post_title' => $new_page_title,
                   'post_name' => $new_page_addr,
                   'post_content' => $new_page_content,
                   'post_status' => 'publish',
                   'post_author' => 1,
           );
           if(!isset($page_check->ID)){
                   $new_page_id = wp_insert_post($new_page);
                   if(!empty($new_page_template)){
                           update_post_meta($new_page_id, '_wp_page_template', $new_page_template);
                   }
           }
   }
   //Create login page
   if (isset($_GET['activated']) && is_admin()){
           $new_page_title = 'ورود';
           $new_page_content = '[edd_login]';
           $new_page_addr = 'login';
           $new_page_template = ''; //ex. template-custom.php. Leave blank if you don't want a custom page template.
           //don't change the code bellow, unless you know what you're doing
           $page_check = get_page_by_title($new_page_title);
           $new_page = array(
                   'post_type' => 'page',
                   'post_title' => $new_page_title,
                   'post_name' => $new_page_addr,
                   'post_content' => $new_page_content,
                   'post_status' => 'publish',
                   'post_author' => 1,
           );
           if(!isset($page_check->ID)){
                   $new_page_id = wp_insert_post($new_page);
                   if(!empty($new_page_template)){
                           update_post_meta($new_page_id, '_wp_page_template', $new_page_template);
                   }
           }
   }

//EDD Dis_price
function dis_price ($id){
    global $edd_options;
    $_currency = isset($edd_options['currency']) ? $edd_options['currency'] : '';
    if($_currency == 'RIAL'){
        $r_price = rwmb_meta( 'file_saleprice', '' , $id ) * 10;
    }else{
        $r_price = rwmb_meta( 'file_saleprice', '' , $id );
    }
    
    $s_price = str_replace(',' , '', edd_get_download_price($id));
    $d_price = $r_price - $s_price;
    $t_price = round(($d_price/$r_price)*100);
    return '<span>'. $t_price .'٪ تخفیف</span>';
}

// EDD Allowed Extensions
function az_edd_filetypes( $arr ) {
    global $az_data;
    $arr = array('jpg','png','gif','ogg');
    if(!empty($az_data['edd_ext'])){
	foreach($az_data['edd_ext'] as $ext)
                            {
                            $arr[] = $ext;
                            }
    }
    return $arr;
}
add_filter( 'edd_protected_directory_allowed_filetypes', 'az_edd_filetypes', 10, 1 );

//Remove EDD Microdata
remove_action( 'loop_start', 'edd_microdata_wrapper_open' );
remove_filter( 'the_content', 'edd_microdata_description' );
remove_filter( 'the_title', 'edd_microdata_title');
remove_action( 'edd_purchase_link_top', 'edd_purchase_link_single_pricing_schema' );
remove_action( 'loop_end', 'edd_microdata_wrapper_close' );

//EDD Prices
function p_price($p_id) { 
    global $az_data;
    $price = "";
    if(!rwmb_meta( 'file_coming','',$p_id )){
      if(edd_is_free_download($p_id) && $az_data['free_price']) { 
                                $price = '<span>'.$az_data['text_free'].'</span>';
                           }
        elseif ( edd_has_variable_prices( get_the_ID() ) ) {
                         $price = edd_price_range( $p_id );
						 $price = '<span>'.preg_replace("/<([a-z][a-z0-9]*)[^>]*?(\/?)>/i",'<$1$2>', $price).'</span>';
        }
        else {
      $price = edd_price($p_id,false);
      $price = preg_replace("/<([a-z][a-z0-9]*)[^>]*?(\/?)>/i",'<$1$2>', $price);
      if(rwmb_meta( 'file_saleprice', '' , get_the_ID() ) != '') { 
          $saleprice = edd_format_amount(rwmb_meta( 'file_saleprice', '' , get_the_ID() ));
          $price = '<span><del>'.$saleprice.' تومان</del> ' . $price . '</span>';
      }
      else {
          $price = '<span>'. $price .'</span>';
      }
      }
    } 
    else
    {
        $price="<span>".$az_data['text_coming_soon']."</span>";
    }
    echo $price;
}


/*
 * Convert variable prices from radio buttons to a dropdown
 */
function shoestrap_edd_purchase_variable_pricing( $download_id ) {
	$variable_pricing = edd_has_variable_prices( $download_id );
	if (!$variable_pricing) {
        return;
    }
    $prices = apply_filters( 'edd_purchase_variable_prices', edd_get_variable_prices( $download_id ), $download_id );
	$type   = edd_single_price_option_mode( $download_id ) ? 'checkbox' : 'radio';
	do_action( 'edd_before_price_options', $download_id );
	echo '<div class="edd_price_options">';
		if ( $prices ) {
			echo '<select class="form-control v-select" name="edd_options[price_id][]">';
			foreach ( $prices as $key => $price ) {
				printf(
					'<option for="%3$s" name="edd_options[price_id][]" id="%3$s" class="%4$s" value="%5$s" %7$s> %6$s</option>',
					checked( 0, $key, false ),
					$type,
					esc_attr( 'edd_price_option_' . $download_id . '_' . $key ),
					esc_attr( 'edd_price_option_' . $download_id ),
					esc_attr( $key ),
					esc_html( $price['name'] . ' - ' . edd_currency_filter( edd_format_amount( $price[ 'amount' ] ) ) ),
					selected( isset( $_GET['price_option'] ), $key, false )
				);
				do_action( 'edd_after_price_option', $key, $price, $download_id );
			}
			echo '</select>';
		}
		do_action( 'edd_after_price_options_list', $download_id, $prices, $type );
	echo '</div><!--end .edd_price_options-->';
	do_action( 'edd_after_price_options', $download_id );
}