<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: Hosseinkhani.ir
*/
   // Exit if accessed directly
   if (!defined('ABSPATH')) {
    exit;
}

/**
    *  /!\ This is a copy of Walker_Nav_Menu_Edit class in core
    * 
    * Create HTML list of nav menu input items.
    *
    * @package WordPress
    * @since 3.0.0
    * @uses Walker_Nav_Menu
    */
   class Walker_Nav_Menu_Edit_Custom extends Walker_Nav_Menu  {
   	private $icons_font_awesome = array(
   		"ad"=>"&#xf641;","address-book"=>"&#xf2b9;","address-card"=>"&#xf2bb;","adjust"=>"&#xf042;","air-freshener"=>"&#xf5d0;","align-center"=>"&#xf037;","align-justify"=>"&#xf039;","align-left"=>"&#xf036;","align-right"=>"&#xf038;","allergies"=>"&#xf461;","ambulance"=>"&#xf0f9;","american-sign-language-interpreting"=>"&#xf2a3;","anchor"=>"&#xf13d;","angle-double-down"=>"&#xf103;","angle-double-left"=>"&#xf100;","angle-double-right"=>"&#xf101;","angle-double-up"=>"&#xf102;","angle-down"=>"&#xf107;","angle-left"=>"&#xf104;","angle-right"=>"&#xf105;","angle-up"=>"&#xf106;","angry"=>"&#xf556;","ankh"=>"&#xf644;","apple-alt"=>"&#xf5d1;","archive"=>"&#xf187;","archway"=>"&#xf557;","arrow-alt-circle-down"=>"&#xf358;","arrow-alt-circle-left"=>"&#xf359;","arrow-alt-circle-right"=>"&#xf35a;","arrow-alt-circle-up"=>"&#xf35b;","arrow-circle-down"=>"&#xf0ab;","arrow-circle-left"=>"&#xf0a8;","arrow-circle-right"=>"&#xf0a9;","arrow-circle-up"=>"&#xf0aa;","arrow-down"=>"&#xf063;","arrow-left"=>"&#xf060;","arrow-right"=>"&#xf061;","arrow-up"=>"&#xf062;","arrows-alt"=>"&#xf0b2;","arrows-alt-h"=>"&#xf337;","arrows-alt-v"=>"&#xf338;","assistive-listening-systems"=>"&#xf2a2;","asterisk"=>"&#xf069;","at"=>"&#xf1fa;","atlas"=>"&#xf558;","atom"=>"&#xf5d2;","audio-description"=>"&#xf29e;","award"=>"&#xf559;","baby"=>"&#xf77c;","baby-carriage"=>"&#xf77d;","backspace"=>"&#xf55a;","backward"=>"&#xf04a;","bacon"=>"&#xf7e5;","bacteria"=>"&#xf959;","bacterium"=>"&#xf95a;","bahai"=>"&#xf666;","balance-scale"=>"&#xf24e;","balance-scale-left"=>"&#xf515;","balance-scale-right"=>"&#xf516;","ban"=>"&#xf05e;","band-aid"=>"&#xf462;","barcode"=>"&#xf02a;","bars"=>"&#xf0c9;","baseball-ball"=>"&#xf433;","basketball-ball"=>"&#xf434;","bath"=>"&#xf2cd;","battery-empty"=>"&#xf244;","battery-full"=>"&#xf240;","battery-half"=>"&#xf242;","battery-quarter"=>"&#xf243;","battery-three-quarters"=>"&#xf241;","bed"=>"&#xf236;","beer"=>"&#xf0fc;","bell"=>"&#xf0f3;","bell-slash"=>"&#xf1f6;","bezier-curve"=>"&#xf55b;","bible"=>"&#xf647;","bicycle"=>"&#xf206;","biking"=>"&#xf84a;","binoculars"=>"&#xf1e5;","biohazard"=>"&#xf780;","birthday-cake"=>"&#xf1fd;","blender"=>"&#xf517;","blender-phone"=>"&#xf6b6;","blind"=>"&#xf29d;","blog"=>"&#xf781;","bold"=>"&#xf032;","bolt"=>"&#xf0e7;","bomb"=>"&#xf1e2;","bone"=>"&#xf5d7;","bong"=>"&#xf55c;","book"=>"&#xf02d;","book-dead"=>"&#xf6b7;","book-medical"=>"&#xf7e6;","book-open"=>"&#xf518;","book-reader"=>"&#xf5da;","bookmark"=>"&#xf02e;","border-all"=>"&#xf84c;","border-none"=>"&#xf850;","border-style"=>"&#xf853;","bowling-ball"=>"&#xf436;","box"=>"&#xf466;","box-open"=>"&#xf49e;","box-tissue"=>"&#xf95b;","boxes"=>"&#xf468;","braille"=>"&#xf2a1;","brain"=>"&#xf5dc;","bread-slice"=>"&#xf7ec;","briefcase"=>"&#xf0b1;","briefcase-medical"=>"&#xf469;","broadcast-tower"=>"&#xf519;","broom"=>"&#xf51a;","brush"=>"&#xf55d;","bug"=>"&#xf188;","building"=>"&#xf1ad;","bullhorn"=>"&#xf0a1;","bullseye"=>"&#xf140;","burn"=>"&#xf46a;","bus"=>"&#xf207;","bus-alt"=>"&#xf55e;","business-time"=>"&#xf64a;","calculator"=>"&#xf1ec;","calendar"=>"&#xf133;","calendar-alt"=>"&#xf073;","calendar-check"=>"&#xf274;","calendar-day"=>"&#xf783;","calendar-minus"=>"&#xf272;","calendar-plus"=>"&#xf271;","calendar-times"=>"&#xf273;","calendar-week"=>"&#xf784;","camera"=>"&#xf030;","camera-retro"=>"&#xf083;","campground"=>"&#xf6bb;","candy-cane"=>"&#xf786;","cannabis"=>"&#xf55f;","capsules"=>"&#xf46b;","car"=>"&#xf1b9;","car-alt"=>"&#xf5de;","car-battery"=>"&#xf5df;","car-crash"=>"&#xf5e1;","car-side"=>"&#xf5e4;","caravan"=>"&#xf8ff;","caret-down"=>"&#xf0d7;","caret-left"=>"&#xf0d9;","caret-right"=>"&#xf0da;","caret-square-down"=>"&#xf150;","caret-square-left"=>"&#xf191;","caret-square-right"=>"&#xf152;","caret-square-up"=>"&#xf151;","caret-up"=>"&#xf0d8;","carrot"=>"&#xf787;","cart-arrow-down"=>"&#xf218;","cart-plus"=>"&#xf217;","cash-register"=>"&#xf788;","cat"=>"&#xf6be;","certificate"=>"&#xf0a3;","chair"=>"&#xf6c0;","chalkboard"=>"&#xf51b;","chalkboard-teacher"=>"&#xf51c;","charging-station"=>"&#xf5e7;","chart-area"=>"&#xf1fe;","chart-bar"=>"&#xf080;","chart-line"=>"&#xf201;","chart-pie"=>"&#xf200;","check"=>"&#xf00c;","check-circle"=>"&#xf058;","check-double"=>"&#xf560;","check-square"=>"&#xf14a;","cheese"=>"&#xf7ef;","chess"=>"&#xf439;","chess-bishop"=>"&#xf43a;","chess-board"=>"&#xf43c;","chess-king"=>"&#xf43f;","chess-knight"=>"&#xf441;","chess-pawn"=>"&#xf443;","chess-queen"=>"&#xf445;","chess-rook"=>"&#xf447;","chevron-circle-down"=>"&#xf13a;","chevron-circle-left"=>"&#xf137;","chevron-circle-right"=>"&#xf138;","chevron-circle-up"=>"&#xf139;","chevron-down"=>"&#xf078;","chevron-left"=>"&#xf053;","chevron-right"=>"&#xf054;","chevron-up"=>"&#xf077;","child"=>"&#xf1ae;","church"=>"&#xf51d;","circle"=>"&#xf111;","circle-notch"=>"&#xf1ce;","city"=>"&#xf64f;","clinic-medical"=>"&#xf7f2;","clipboard"=>"&#xf328;","clipboard-check"=>"&#xf46c;","clipboard-list"=>"&#xf46d;","clock"=>"&#xf017;","clone"=>"&#xf24d;","closed-captioning"=>"&#xf20a;","cloud"=>"&#xf0c2;","cloud-download-alt"=>"&#xf381;","cloud-meatball"=>"&#xf73b;","cloud-moon"=>"&#xf6c3;","cloud-moon-rain"=>"&#xf73c;","cloud-rain"=>"&#xf73d;","cloud-showers-heavy"=>"&#xf740;","cloud-sun"=>"&#xf6c4;","cloud-sun-rain"=>"&#xf743;","cloud-upload-alt"=>"&#xf382;","cocktail"=>"&#xf561;","code"=>"&#xf121;","code-branch"=>"&#xf126;","coffee"=>"&#xf0f4;","cog"=>"&#xf013;","cogs"=>"&#xf085;","coins"=>"&#xf51e;","columns"=>"&#xf0db;","comment"=>"&#xf075;","comment-alt"=>"&#xf27a;","comment-dollar"=>"&#xf651;","comment-dots"=>"&#xf4ad;","comment-medical"=>"&#xf7f5;","comment-slash"=>"&#xf4b3;","comments"=>"&#xf086;","comments-dollar"=>"&#xf653;","compact-disc"=>"&#xf51f;","compass"=>"&#xf14e;","compress"=>"&#xf066;","compress-alt"=>"&#xf422;","compress-arrows-alt"=>"&#xf78c;","concierge-bell"=>"&#xf562;","cookie"=>"&#xf563;","cookie-bite"=>"&#xf564;","copy"=>"&#xf0c5;","copyright"=>"&#xf1f9;","couch"=>"&#xf4b8;","credit-card"=>"&#xf09d;","crop"=>"&#xf125;","crop-alt"=>"&#xf565;","cross"=>"&#xf654;","crosshairs"=>"&#xf05b;","crow"=>"&#xf520;","crown"=>"&#xf521;","crutch"=>"&#xf7f7;","cube"=>"&#xf1b2;","cubes"=>"&#xf1b3;","cut"=>"&#xf0c4;","database"=>"&#xf1c0;","deaf"=>"&#xf2a4;","democrat"=>"&#xf747;","desktop"=>"&#xf108;","dharmachakra"=>"&#xf655;","diagnoses"=>"&#xf470;","dice"=>"&#xf522;","dice-d20"=>"&#xf6cf;","dice-d6"=>"&#xf6d1;","dice-five"=>"&#xf523;","dice-four"=>"&#xf524;","dice-one"=>"&#xf525;","dice-six"=>"&#xf526;","dice-three"=>"&#xf527;","dice-two"=>"&#xf528;","digital-tachograph"=>"&#xf566;","directions"=>"&#xf5eb;","disease"=>"&#xf7fa;","divide"=>"&#xf529;","dizzy"=>"&#xf567;","dna"=>"&#xf471;","dog"=>"&#xf6d3;","dollar-sign"=>"&#xf155;","dolly"=>"&#xf472;","dolly-flatbed"=>"&#xf474;","donate"=>"&#xf4b9;","door-closed"=>"&#xf52a;","door-open"=>"&#xf52b;","dot-circle"=>"&#xf192;","dove"=>"&#xf4ba;","download"=>"&#xf019;","drafting-compass"=>"&#xf568;","dragon"=>"&#xf6d5;","draw-polygon"=>"&#xf5ee;","drum"=>"&#xf569;","drum-steelpan"=>"&#xf56a;","drumstick-bite"=>"&#xf6d7;","dumbbell"=>"&#xf44b;","dumpster"=>"&#xf793;","dumpster-fire"=>"&#xf794;","dungeon"=>"&#xf6d9;","edit"=>"&#xf044;","egg"=>"&#xf7fb;","eject"=>"&#xf052;","ellipsis-h"=>"&#xf141;","ellipsis-v"=>"&#xf142;","envelope"=>"&#xf0e0;","envelope-open"=>"&#xf2b6;","envelope-open-text"=>"&#xf658;","envelope-square"=>"&#xf199;","equals"=>"&#xf52c;","eraser"=>"&#xf12d;","ethernet"=>"&#xf796;","euro-sign"=>"&#xf153;","exchange-alt"=>"&#xf362;","exclamation"=>"&#xf12a;","exclamation-circle"=>"&#xf06a;","exclamation-triangle"=>"&#xf071;","expand"=>"&#xf065;","expand-alt"=>"&#xf424;","expand-arrows-alt"=>"&#xf31e;","external-link-alt"=>"&#xf35d;","external-link-square-alt"=>"&#xf360;","eye"=>"&#xf06e;","eye-dropper"=>"&#xf1fb;","eye-slash"=>"&#xf070;","fan"=>"&#xf863;","fast-backward"=>"&#xf049;","fast-forward"=>"&#xf050;","faucet"=>"&#xf905;","fax"=>"&#xf1ac;","feather"=>"&#xf52d;","feather-alt"=>"&#xf56b;","female"=>"&#xf182;","fighter-jet"=>"&#xf0fb;","file"=>"&#xf15b;","file-alt"=>"&#xf15c;","file-archive"=>"&#xf1c6;","file-audio"=>"&#xf1c7;","file-code"=>"&#xf1c9;","file-contract"=>"&#xf56c;","file-csv"=>"&#xf6dd;","file-download"=>"&#xf56d;","file-excel"=>"&#xf1c3;","file-export"=>"&#xf56e;","file-image"=>"&#xf1c5;","file-import"=>"&#xf56f;","file-invoice"=>"&#xf570;","file-invoice-dollar"=>"&#xf571;","file-medical"=>"&#xf477;","file-medical-alt"=>"&#xf478;","file-pdf"=>"&#xf1c1;","file-powerpoint"=>"&#xf1c4;","file-prescription"=>"&#xf572;","file-signature"=>"&#xf573;","file-upload"=>"&#xf574;","file-video"=>"&#xf1c8;","file-word"=>"&#xf1c2;","fill"=>"&#xf575;","fill-drip"=>"&#xf576;","film"=>"&#xf008;","filter"=>"&#xf0b0;","fingerprint"=>"&#xf577;","fire"=>"&#xf06d;","fire-alt"=>"&#xf7e4;","fire-extinguisher"=>"&#xf134;","first-aid"=>"&#xf479;","fish"=>"&#xf578;","fist-raised"=>"&#xf6de;","flag"=>"&#xf024;","flag-checkered"=>"&#xf11e;","flag-usa"=>"&#xf74d;","flask"=>"&#xf0c3;","flushed"=>"&#xf579;","folder"=>"&#xf07b;","folder-minus"=>"&#xf65d;","folder-open"=>"&#xf07c;","folder-plus"=>"&#xf65e;","font"=>"&#xf031;","football-ball"=>"&#xf44e;","forward"=>"&#xf04e;","frog"=>"&#xf52e;","frown"=>"&#xf119;","frown-open"=>"&#xf57a;","funnel-dollar"=>"&#xf662;","futbol"=>"&#xf1e3;","gamepad"=>"&#xf11b;","gas-pump"=>"&#xf52f;","gavel"=>"&#xf0e3;","gem"=>"&#xf3a5;","genderless"=>"&#xf22d;","ghost"=>"&#xf6e2;","gift"=>"&#xf06b;","gifts"=>"&#xf79c;","glass-cheers"=>"&#xf79f;","glass-martini"=>"&#xf000;","glass-martini-alt"=>"&#xf57b;","glass-whiskey"=>"&#xf7a0;","glasses"=>"&#xf530;","globe"=>"&#xf0ac;","globe-africa"=>"&#xf57c;","globe-americas"=>"&#xf57d;","globe-asia"=>"&#xf57e;","globe-europe"=>"&#xf7a2;","golf-ball"=>"&#xf450;","gopuram"=>"&#xf664;","graduation-cap"=>"&#xf19d;","greater-than"=>"&#xf531;","greater-than-equal"=>"&#xf532;","grimace"=>"&#xf57f;","grin"=>"&#xf580;","grin-alt"=>"&#xf581;","grin-beam"=>"&#xf582;","grin-beam-sweat"=>"&#xf583;","grin-hearts"=>"&#xf584;","grin-squint"=>"&#xf585;","grin-squint-tears"=>"&#xf586;","grin-stars"=>"&#xf587;","grin-tears"=>"&#xf588;","grin-tongue"=>"&#xf589;","grin-tongue-squint"=>"&#xf58a;","grin-tongue-wink"=>"&#xf58b;","grin-wink"=>"&#xf58c;","grip-horizontal"=>"&#xf58d;","grip-lines"=>"&#xf7a4;","grip-lines-vertical"=>"&#xf7a5;","grip-vertical"=>"&#xf58e;","guitar"=>"&#xf7a6;","h-square"=>"&#xf0fd;","hamburger"=>"&#xf805;","hammer"=>"&#xf6e3;","hamsa"=>"&#xf665;","hand-holding"=>"&#xf4bd;","hand-holding-heart"=>"&#xf4be;","hand-holding-medical"=>"&#xf95c;","hand-holding-usd"=>"&#xf4c0;","hand-holding-water"=>"&#xf4c1;","hand-lizard"=>"&#xf258;","hand-middle-finger"=>"&#xf806;","hand-paper"=>"&#xf256;","hand-peace"=>"&#xf25b;","hand-point-down"=>"&#xf0a7;","hand-point-left"=>"&#xf0a5;","hand-point-right"=>"&#xf0a4;","hand-point-up"=>"&#xf0a6;","hand-pointer"=>"&#xf25a;","hand-rock"=>"&#xf255;","hand-scissors"=>"&#xf257;","hand-sparkles"=>"&#xf95d;","hand-spock"=>"&#xf259;","hands"=>"&#xf4c2;","hands-helping"=>"&#xf4c4;","hands-wash"=>"&#xf95e;","handshake"=>"&#xf2b5;","handshake-alt-slash"=>"&#xf95f;","handshake-slash"=>"&#xf960;","hanukiah"=>"&#xf6e6;","hard-hat"=>"&#xf807;","hashtag"=>"&#xf292;","hat-cowboy"=>"&#xf8c0;","hat-cowboy-side"=>"&#xf8c1;","hat-wizard"=>"&#xf6e8;","hdd"=>"&#xf0a0;","head-side-cough"=>"&#xf961;","head-side-cough-slash"=>"&#xf962;","head-side-mask"=>"&#xf963;","head-side-virus"=>"&#xf964;","heading"=>"&#xf1dc;","headphones"=>"&#xf025;","headphones-alt"=>"&#xf58f;","headset"=>"&#xf590;","heart"=>"&#xf004;","heart-broken"=>"&#xf7a9;","heartbeat"=>"&#xf21e;","helicopter"=>"&#xf533;","highlighter"=>"&#xf591;","hiking"=>"&#xf6ec;","hippo"=>"&#xf6ed;","history"=>"&#xf1da;","hockey-puck"=>"&#xf453;","holly-berry"=>"&#xf7aa;","home"=>"&#xf015;","horse"=>"&#xf6f0;","horse-head"=>"&#xf7ab;","hospital"=>"&#xf0f8;","hospital-alt"=>"&#xf47d;","hospital-symbol"=>"&#xf47e;","hospital-user"=>"&#xf80d;","hot-tub"=>"&#xf593;","hotdog"=>"&#xf80f;","hotel"=>"&#xf594;","hourglass"=>"&#xf254;","hourglass-end"=>"&#xf253;","hourglass-half"=>"&#xf252;","hourglass-start"=>"&#xf251;","house-damage"=>"&#xf6f1;","house-user"=>"&#xf965;","hryvnia"=>"&#xf6f2;","i-cursor"=>"&#xf246;","ice-cream"=>"&#xf810;","icicles"=>"&#xf7ad;","icons"=>"&#xf86d;","id-badge"=>"&#xf2c1;","id-card"=>"&#xf2c2;","id-card-alt"=>"&#xf47f;","igloo"=>"&#xf7ae;","image"=>"&#xf03e;","images"=>"&#xf302;","inbox"=>"&#xf01c;","indent"=>"&#xf03c;","industry"=>"&#xf275;","infinity"=>"&#xf534;","info"=>"&#xf129;","info-circle"=>"&#xf05a;","italic"=>"&#xf033;","jedi"=>"&#xf669;","joint"=>"&#xf595;","journal-whills"=>"&#xf66a;","kaaba"=>"&#xf66b;","key"=>"&#xf084;","keyboard"=>"&#xf11c;","khanda"=>"&#xf66d;","kiss"=>"&#xf596;","kiss-beam"=>"&#xf597;","kiss-wink-heart"=>"&#xf598;","kiwi-bird"=>"&#xf535;","landmark"=>"&#xf66f;","language"=>"&#xf1ab;","laptop"=>"&#xf109;","laptop-code"=>"&#xf5fc;","laptop-house"=>"&#xf966;","laptop-medical"=>"&#xf812;","laugh"=>"&#xf599;","laugh-beam"=>"&#xf59a;","laugh-squint"=>"&#xf59b;","laugh-wink"=>"&#xf59c;","layer-group"=>"&#xf5fd;","leaf"=>"&#xf06c;","lemon"=>"&#xf094;","less-than"=>"&#xf536;","less-than-equal"=>"&#xf537;","level-down-alt"=>"&#xf3be;","level-up-alt"=>"&#xf3bf;","life-ring"=>"&#xf1cd;","lightbulb"=>"&#xf0eb;","link"=>"&#xf0c1;","lira-sign"=>"&#xf195;","list"=>"&#xf03a;","list-alt"=>"&#xf022;","list-ol"=>"&#xf0cb;","list-ul"=>"&#xf0ca;","location-arrow"=>"&#xf124;","lock"=>"&#xf023;","lock-open"=>"&#xf3c1;","long-arrow-alt-down"=>"&#xf309;","long-arrow-alt-left"=>"&#xf30a;","long-arrow-alt-right"=>"&#xf30b;","long-arrow-alt-up"=>"&#xf30c;","low-vision"=>"&#xf2a8;","luggage-cart"=>"&#xf59d;","lungs"=>"&#xf604;","lungs-virus"=>"&#xf967;","magic"=>"&#xf0d0;","magnet"=>"&#xf076;","mail-bulk"=>"&#xf674;","male"=>"&#xf183;","map"=>"&#xf279;","map-marked"=>"&#xf59f;","map-marked-alt"=>"&#xf5a0;","map-marker"=>"&#xf041;","map-marker-alt"=>"&#xf3c5;","map-pin"=>"&#xf276;","map-signs"=>"&#xf277;","marker"=>"&#xf5a1;","mars"=>"&#xf222;","mars-double"=>"&#xf227;","mars-stroke"=>"&#xf229;","mars-stroke-h"=>"&#xf22b;","mars-stroke-v"=>"&#xf22a;","mask"=>"&#xf6fa;","medal"=>"&#xf5a2;","medkit"=>"&#xf0fa;","meh"=>"&#xf11a;","meh-blank"=>"&#xf5a4;","meh-rolling-eyes"=>"&#xf5a5;","memory"=>"&#xf538;","menorah"=>"&#xf676;","mercury"=>"&#xf223;","meteor"=>"&#xf753;","microchip"=>"&#xf2db;","microphone"=>"&#xf130;","microphone-alt"=>"&#xf3c9;","microphone-alt-slash"=>"&#xf539;","microphone-slash"=>"&#xf131;","microscope"=>"&#xf610;","minus"=>"&#xf068;","minus-circle"=>"&#xf056;","minus-square"=>"&#xf146;","mitten"=>"&#xf7b5;","mobile"=>"&#xf10b;","mobile-alt"=>"&#xf3cd;","money-bill"=>"&#xf0d6;","money-bill-alt"=>"&#xf3d1;","money-bill-wave"=>"&#xf53a;","money-bill-wave-alt"=>"&#xf53b;","money-check"=>"&#xf53c;","money-check-alt"=>"&#xf53d;","monument"=>"&#xf5a6;","moon"=>"&#xf186;","mortar-pestle"=>"&#xf5a7;","mosque"=>"&#xf678;","motorcycle"=>"&#xf21c;","mountain"=>"&#xf6fc;","mouse"=>"&#xf8cc;","mouse-pointer"=>"&#xf245;","mug-hot"=>"&#xf7b6;","music"=>"&#xf001;","network-wired"=>"&#xf6ff;","neuter"=>"&#xf22c;","newspaper"=>"&#xf1ea;","not-equal"=>"&#xf53e;","notes-medical"=>"&#xf481;","object-group"=>"&#xf247;","object-ungroup"=>"&#xf248;","oil-can"=>"&#xf613;","om"=>"&#xf679;","otter"=>"&#xf700;","outdent"=>"&#xf03b;","pager"=>"&#xf815;","paint-brush"=>"&#xf1fc;","paint-roller"=>"&#xf5aa;","palette"=>"&#xf53f;","pallet"=>"&#xf482;","paper-plane"=>"&#xf1d8;","paperclip"=>"&#xf0c6;","parachute-box"=>"&#xf4cd;","paragraph"=>"&#xf1dd;","parking"=>"&#xf540;","passport"=>"&#xf5ab;","pastafarianism"=>"&#xf67b;","paste"=>"&#xf0ea;","pause"=>"&#xf04c;","pause-circle"=>"&#xf28b;","paw"=>"&#xf1b0;","peace"=>"&#xf67c;","pen"=>"&#xf304;","pen-alt"=>"&#xf305;","pen-fancy"=>"&#xf5ac;","pen-nib"=>"&#xf5ad;","pen-square"=>"&#xf14b;","pencil-alt"=>"&#xf303;","pencil-ruler"=>"&#xf5ae;","people-arrows"=>"&#xf968;","people-carry"=>"&#xf4ce;","pepper-hot"=>"&#xf816;","percent"=>"&#xf295;","percentage"=>"&#xf541;","person-booth"=>"&#xf756;","phone"=>"&#xf095;","phone-alt"=>"&#xf879;","phone-slash"=>"&#xf3dd;","phone-square"=>"&#xf098;","phone-square-alt"=>"&#xf87b;","phone-volume"=>"&#xf2a0;","photo-video"=>"&#xf87c;","piggy-bank"=>"&#xf4d3;","pills"=>"&#xf484;","pizza-slice"=>"&#xf818;","place-of-worship"=>"&#xf67f;","plane"=>"&#xf072;","plane-arrival"=>"&#xf5af;","plane-departure"=>"&#xf5b0;","plane-slash"=>"&#xf969;","play"=>"&#xf04b;","play-circle"=>"&#xf144;","plug"=>"&#xf1e6;","plus"=>"&#xf067;","plus-circle"=>"&#xf055;","plus-square"=>"&#xf0fe;","podcast"=>"&#xf2ce;","poll"=>"&#xf681;","poll-h"=>"&#xf682;","poo"=>"&#xf2fe;","poo-storm"=>"&#xf75a;","poop"=>"&#xf619;","portrait"=>"&#xf3e0;","pound-sign"=>"&#xf154;","power-off"=>"&#xf011;","pray"=>"&#xf683;","praying-hands"=>"&#xf684;","prescription"=>"&#xf5b1;","prescription-bottle"=>"&#xf485;","prescription-bottle-alt"=>"&#xf486;","print"=>"&#xf02f;","procedures"=>"&#xf487;","project-diagram"=>"&#xf542;","pump-medical"=>"&#xf96a;","pump-soap"=>"&#xf96b;","puzzle-piece"=>"&#xf12e;","qrcode"=>"&#xf029;","question"=>"&#xf128;","question-circle"=>"&#xf059;","quidditch"=>"&#xf458;","quote-left"=>"&#xf10d;","quote-right"=>"&#xf10e;","quran"=>"&#xf687;","radiation"=>"&#xf7b9;","radiation-alt"=>"&#xf7ba;","rainbow"=>"&#xf75b;","random"=>"&#xf074;","receipt"=>"&#xf543;","record-vinyl"=>"&#xf8d9;","recycle"=>"&#xf1b8;","redo"=>"&#xf01e;","redo-alt"=>"&#xf2f9;","registered"=>"&#xf25d;","remove-format"=>"&#xf87d;","reply"=>"&#xf3e5;","reply-all"=>"&#xf122;","republican"=>"&#xf75e;","restroom"=>"&#xf7bd;","retweet"=>"&#xf079;","ribbon"=>"&#xf4d6;","ring"=>"&#xf70b;","road"=>"&#xf018;","robot"=>"&#xf544;","rocket"=>"&#xf135;","route"=>"&#xf4d7;","rss"=>"&#xf09e;","rss-square"=>"&#xf143;","ruble-sign"=>"&#xf158;","ruler"=>"&#xf545;","ruler-combined"=>"&#xf546;","ruler-horizontal"=>"&#xf547;","ruler-vertical"=>"&#xf548;","running"=>"&#xf70c;","rupee-sign"=>"&#xf156;","sad-cry"=>"&#xf5b3;","sad-tear"=>"&#xf5b4;","satellite"=>"&#xf7bf;","satellite-dish"=>"&#xf7c0;","save"=>"&#xf0c7;","school"=>"&#xf549;","screwdriver"=>"&#xf54a;","scroll"=>"&#xf70e;","sd-card"=>"&#xf7c2;","search"=>"&#xf002;","search-dollar"=>"&#xf688;","search-location"=>"&#xf689;","search-minus"=>"&#xf010;","search-plus"=>"&#xf00e;","seedling"=>"&#xf4d8;","server"=>"&#xf233;","shapes"=>"&#xf61f;","share"=>"&#xf064;","share-alt"=>"&#xf1e0;","share-alt-square"=>"&#xf1e1;","share-square"=>"&#xf14d;","shekel-sign"=>"&#xf20b;","shield-alt"=>"&#xf3ed;","shield-virus"=>"&#xf96c;","ship"=>"&#xf21a;","shipping-fast"=>"&#xf48b;","shoe-prints"=>"&#xf54b;","shopping-bag"=>"&#xf290;","shopping-basket"=>"&#xf291;","shopping-cart"=>"&#xf07a;","shower"=>"&#xf2cc;","shuttle-van"=>"&#xf5b6;","sign"=>"&#xf4d9;","sign-in-alt"=>"&#xf2f6;","sign-language"=>"&#xf2a7;","sign-out-alt"=>"&#xf2f5;","signal"=>"&#xf012;","signature"=>"&#xf5b7;","sim-card"=>"&#xf7c4;","sink"=>"&#xf96d;","sitemap"=>"&#xf0e8;","skating"=>"&#xf7c5;","skiing"=>"&#xf7c9;","skiing-nordic"=>"&#xf7ca;","skull"=>"&#xf54c;","skull-crossbones"=>"&#xf714;","slash"=>"&#xf715;","sleigh"=>"&#xf7cc;","sliders-h"=>"&#xf1de;","smile"=>"&#xf118;","smile-beam"=>"&#xf5b8;","smile-wink"=>"&#xf4da;","smog"=>"&#xf75f;","smoking"=>"&#xf48d;","smoking-ban"=>"&#xf54d;","sms"=>"&#xf7cd;","snowboarding"=>"&#xf7ce;","snowflake"=>"&#xf2dc;","snowman"=>"&#xf7d0;","snowplow"=>"&#xf7d2;","soap"=>"&#xf96e;","socks"=>"&#xf696;","solar-panel"=>"&#xf5ba;","sort"=>"&#xf0dc;","sort-alpha-down"=>"&#xf15d;","sort-alpha-down-alt"=>"&#xf881;","sort-alpha-up"=>"&#xf15e;","sort-alpha-up-alt"=>"&#xf882;","sort-amount-down"=>"&#xf160;","sort-amount-down-alt"=>"&#xf884;","sort-amount-up"=>"&#xf161;","sort-amount-up-alt"=>"&#xf885;","sort-down"=>"&#xf0dd;","sort-numeric-down"=>"&#xf162;","sort-numeric-down-alt"=>"&#xf886;","sort-numeric-up"=>"&#xf163;","sort-numeric-up-alt"=>"&#xf887;","sort-up"=>"&#xf0de;","spa"=>"&#xf5bb;","space-shuttle"=>"&#xf197;","spell-check"=>"&#xf891;","spider"=>"&#xf717;","spinner"=>"&#xf110;","splotch"=>"&#xf5bc;","spray-can"=>"&#xf5bd;","square"=>"&#xf0c8;","square-full"=>"&#xf45c;","square-root-alt"=>"&#xf698;","stamp"=>"&#xf5bf;","star"=>"&#xf005;","star-and-crescent"=>"&#xf699;","star-half"=>"&#xf089;","star-half-alt"=>"&#xf5c0;","star-of-david"=>"&#xf69a;","star-of-life"=>"&#xf621;","step-backward"=>"&#xf048;","step-forward"=>"&#xf051;","stethoscope"=>"&#xf0f1;","sticky-note"=>"&#xf249;","stop"=>"&#xf04d;","stop-circle"=>"&#xf28d;","stopwatch"=>"&#xf2f2;","stopwatch-20"=>"&#xf96f;","store"=>"&#xf54e;","store-alt"=>"&#xf54f;","store-alt-slash"=>"&#xf970;","store-slash"=>"&#xf971;","stream"=>"&#xf550;","street-view"=>"&#xf21d;","strikethrough"=>"&#xf0cc;","stroopwafel"=>"&#xf551;","subscript"=>"&#xf12c;","subway"=>"&#xf239;","suitcase"=>"&#xf0f2;","suitcase-rolling"=>"&#xf5c1;","sun"=>"&#xf185;","superscript"=>"&#xf12b;","surprise"=>"&#xf5c2;","swatchbook"=>"&#xf5c3;","swimmer"=>"&#xf5c4;","swimming-pool"=>"&#xf5c5;","synagogue"=>"&#xf69b;","sync"=>"&#xf021;","sync-alt"=>"&#xf2f1;","syringe"=>"&#xf48e;","table"=>"&#xf0ce;","table-tennis"=>"&#xf45d;","tablet"=>"&#xf10a;","tablet-alt"=>"&#xf3fa;","tablets"=>"&#xf490;","tachometer-alt"=>"&#xf3fd;","tag"=>"&#xf02b;","tags"=>"&#xf02c;","tape"=>"&#xf4db;","tasks"=>"&#xf0ae;","taxi"=>"&#xf1ba;","teeth"=>"&#xf62e;","teeth-open"=>"&#xf62f;","temperature-high"=>"&#xf769;","temperature-low"=>"&#xf76b;","tenge"=>"&#xf7d7;","terminal"=>"&#xf120;","text-height"=>"&#xf034;","text-width"=>"&#xf035;","th"=>"&#xf00a;","th-large"=>"&#xf009;","th-list"=>"&#xf00b;","theater-masks"=>"&#xf630;","thermometer"=>"&#xf491;","thermometer-empty"=>"&#xf2cb;","thermometer-full"=>"&#xf2c7;","thermometer-half"=>"&#xf2c9;","thermometer-quarter"=>"&#xf2ca;","thermometer-three-quarters"=>"&#xf2c8;","thumbs-down"=>"&#xf165;","thumbs-up"=>"&#xf164;","thumbtack"=>"&#xf08d;","ticket-alt"=>"&#xf3ff;","times"=>"&#xf00d;","times-circle"=>"&#xf057;","tint"=>"&#xf043;","tint-slash"=>"&#xf5c7;","tired"=>"&#xf5c8;","toggle-off"=>"&#xf204;","toggle-on"=>"&#xf205;","toilet"=>"&#xf7d8;","toilet-paper"=>"&#xf71e;","toilet-paper-slash"=>"&#xf972;","toolbox"=>"&#xf552;","tools"=>"&#xf7d9;","tooth"=>"&#xf5c9;","torah"=>"&#xf6a0;","torii-gate"=>"&#xf6a1;","tractor"=>"&#xf722;","trademark"=>"&#xf25c;","traffic-light"=>"&#xf637;","trailer"=>"&#xf941;","train"=>"&#xf238;","tram"=>"&#xf7da;","transgender"=>"&#xf224;","transgender-alt"=>"&#xf225;","trash"=>"&#xf1f8;","trash-alt"=>"&#xf2ed;","trash-restore"=>"&#xf829;","trash-restore-alt"=>"&#xf82a;","tree"=>"&#xf1bb;","trophy"=>"&#xf091;","truck"=>"&#xf0d1;","truck-loading"=>"&#xf4de;","truck-monster"=>"&#xf63b;","truck-moving"=>"&#xf4df;","truck-pickup"=>"&#xf63c;","tshirt"=>"&#xf553;","tty"=>"&#xf1e4;","tv"=>"&#xf26c;","umbrella"=>"&#xf0e9;","umbrella-beach"=>"&#xf5ca;","underline"=>"&#xf0cd;","undo"=>"&#xf0e2;","undo-alt"=>"&#xf2ea;","universal-access"=>"&#xf29a;","university"=>"&#xf19c;","unlink"=>"&#xf127;","unlock"=>"&#xf09c;","unlock-alt"=>"&#xf13e;","upload"=>"&#xf093;","user"=>"&#xf007;","user-alt"=>"&#xf406;","user-alt-slash"=>"&#xf4fa;","user-astronaut"=>"&#xf4fb;","user-check"=>"&#xf4fc;","user-circle"=>"&#xf2bd;","user-clock"=>"&#xf4fd;","user-cog"=>"&#xf4fe;","user-edit"=>"&#xf4ff;","user-friends"=>"&#xf500;","user-graduate"=>"&#xf501;","user-injured"=>"&#xf728;","user-lock"=>"&#xf502;","user-md"=>"&#xf0f0;","user-minus"=>"&#xf503;","user-ninja"=>"&#xf504;","user-nurse"=>"&#xf82f;","user-plus"=>"&#xf234;","user-secret"=>"&#xf21b;","user-shield"=>"&#xf505;","user-slash"=>"&#xf506;","user-tag"=>"&#xf507;","user-tie"=>"&#xf508;","user-times"=>"&#xf235;","users"=>"&#xf0c0;","users-cog"=>"&#xf509;","users-slash"=>"&#xf973;","utensil-spoon"=>"&#xf2e5;","utensils"=>"&#xf2e7;","vector-square"=>"&#xf5cb;","venus"=>"&#xf221;","venus-double"=>"&#xf226;","venus-mars"=>"&#xf228;","vial"=>"&#xf492;","vials"=>"&#xf493;","video"=>"&#xf03d;","video-slash"=>"&#xf4e2;","vihara"=>"&#xf6a7;","virus"=>"&#xf974;","virus-slash"=>"&#xf975;","viruses"=>"&#xf976;","voicemail"=>"&#xf897;","volleyball-ball"=>"&#xf45f;","volume-down"=>"&#xf027;","volume-mute"=>"&#xf6a9;","volume-off"=>"&#xf026;","volume-up"=>"&#xf028;","vote-yea"=>"&#xf772;","vr-cardboard"=>"&#xf729;","walking"=>"&#xf554;","wallet"=>"&#xf555;","warehouse"=>"&#xf494;","water"=>"&#xf773;","wave-square"=>"&#xf83e;","weight"=>"&#xf496;","weight-hanging"=>"&#xf5cd;","wheelchair"=>"&#xf193;","wifi"=>"&#xf1eb;","wind"=>"&#xf72e;","window-close"=>"&#xf410;","window-maximize"=>"&#xf2d0;","window-minimize"=>"&#xf2d1;","window-restore"=>"&#xf2d2;","wine-bottle"=>"&#xf72f;","wine-glass"=>"&#xf4e3;","wine-glass-alt"=>"&#xf5ce;","won-sign"=>"&#xf159;","wrench"=>"&#xf0ad;","x-ray"=>"&#xf497;","yen-sign"=>"&#xf157;","yin-yang"=>"&#xf6ad;"
   	);
   	/**
   	 * @see Walker_Nav_Menu::start_lvl()
   	 * @since 3.0.0
   	 *
   	 * @param string $output Passed by reference.
   	 */
   	function start_lvl(&$output, $depth = 0, $args = array()) {   
   }
   	
   	/**
   	 * @see Walker_Nav_Menu::end_lvl()
   	 * @since 3.0.0
   	 *
   	 * @param string $output Passed by reference.
   	 */
   	function end_lvl(&$output, $depth = 0, $args = array()) {
   }
   	
   	/**
   	 * @see Walker::start_el()
   	 * @since 3.0.0
   	 *
   	 * @param string $output Passed by reference. Used to append additional content.
   	 * @param object $item Menu item data object.
   	 * @param int $depth Depth of menu item. Used for padding.
   	 * @param object $args
   	 */
   	function start_el(&$output, $item,  $depth = 0, $args = array(), $current_object_id = 0){
   	    global $_wp_nav_menu_max_depth;
   	   
   	    $_wp_nav_menu_max_depth = $depth > $_wp_nav_menu_max_depth ? $depth : $_wp_nav_menu_max_depth;
   	
   	    $indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';
   	
   	    ob_start();
   	    $item_id = esc_attr( $item->ID );
   	    $removed_args = array(
   	        'action',
   	        'customlink-tab',
   	        'edit-menu-item',
   	        'menu-item',
   	        'page-tab',
   	        '_wpnonce',
   	    );
   	
   	    $original_title = '';
   	    if ( 'taxonomy' == $item->type ) {
   	        $original_title = get_term_field( 'name', $item->object_id, $item->object, 'raw' );
   	        if ( is_wp_error( $original_title ) )
   	            $original_title = false;
   	    } elseif ( 'post_type' == $item->type ) {
   	        $original_object = get_post( $item->object_id );
   	        $original_title = $original_object->post_title;
   	    }
   	
   	    $classes = array(
   	        'menu-item menu-item-depth-' . $depth,
   	        'menu-item-' . esc_attr( $item->object ),
   	        'menu-item-edit-' . ( ( isset( $_GET['edit-menu-item'] ) && $item_id == $_GET['edit-menu-item'] ) ? 'active' : 'inactive'),
   	    );
   	
   	    $title = $item->title;
   	
   	    if ( ! empty( $item->_invalid ) ) {
   	        $classes[] = 'menu-item-invalid';
   	        /* translators: %s: title of menu item which is invalid */
   	        $title = sprintf( __( '%s (Invalid)' ), $item->title );
   	    } elseif ( isset( $item->post_status ) && 'draft' == $item->post_status ) {
   	        $classes[] = 'pending';
   	        /* translators: %s: title of menu item in draft status */
   	        $title = sprintf( __('%s (Pending)'), $item->title );
   	    }
   	
   	    $title = empty( $item->label ) ? $title : $item->label;
   	
   	    ?>
<li id="menu-item-<?php echo $item_id; ?>" class="<?php echo implode(' ', $classes ); ?>">
   <dl class="menu-item-bar">
      <dt class="menu-item-handle">
         <span class="item-title"><?php echo esc_html( $title ); ?></span>
         <span class="item-controls">
         <span class="item-type"><?php echo esc_html( $item->type_label ); ?></span>
         <span class="item-order hide-if-js">
         <a href="<?php
            echo wp_nonce_url(
                add_query_arg(
                    array(
                        'action' => 'move-up-menu-item',
                        'menu-item' => $item_id,
                    ),
                    remove_query_arg($removed_args, admin_url( 'nav-menus.php' ) )
                ),
                'move-menu_item'
            );
            ?>" class="item-move-up"><abbr title="<?php esc_attr_e('Move up'); ?>">&#8593;</abbr></a>
         |
         <a href="<?php
            echo wp_nonce_url(
                add_query_arg(
                    array(
                        'action' => 'move-down-menu-item',
                        'menu-item' => $item_id,
                    ),
                    remove_query_arg($removed_args, admin_url( 'nav-menus.php' ) )
                ),
                'move-menu_item'
            );
            ?>" class="item-move-down"><abbr title="<?php esc_attr_e('Move down'); ?>">&#8595;</abbr></a>
         </span>
         <a class="item-edit" id="edit-<?php echo $item_id; ?>" title="<?php esc_attr_e('Edit Menu Item'); ?>" href="<?php
            echo ( isset( $_GET['edit-menu-item'] ) && $item_id == $_GET['edit-menu-item'] ) ? admin_url( 'nav-menus.php' ) : add_query_arg( 'edit-menu-item', $item_id, remove_query_arg( $removed_args, admin_url( 'nav-menus.php#menu-item-settings-' . $item_id ) ) );
            ?>"><?php _e( 'Edit Menu Item' ); ?></a>
         </span>
      </dt>
   </dl>
   <div class="menu-item-settings" id="menu-item-settings-<?php echo $item_id; ?>">
      <?php if( 'custom' == $item->type ) : ?>
      <p class="field-url description description-wide">
         <label for="edit-menu-item-url-<?php echo $item_id; ?>">
         <?php _e( 'URL' ); ?><br />
         <input type="text" id="edit-menu-item-url-<?php echo $item_id; ?>" class="widefat code edit-menu-item-url" name="menu-item-url[<?php echo $item_id; ?>]" value="<?php echo esc_attr( $item->url ); ?>" />
         </label>
      </p>
      <?php endif; ?>
      <p class="description description-thin">
         <label for="edit-menu-item-title-<?php echo $item_id; ?>">
         <?php _e( 'Navigation Label' ); ?><br />
         <input type="text" id="edit-menu-item-title-<?php echo $item_id; ?>" class="widefat edit-menu-item-title" name="menu-item-title[<?php echo $item_id; ?>]" value="<?php echo esc_attr( $item->title ); ?>" />
         </label>
      </p>
      <p class="description description-thin">
         <label for="edit-menu-item-attr-title-<?php echo $item_id; ?>">
         <?php _e( 'Title Attribute' ); ?><br />
         <input type="text" id="edit-menu-item-attr-title-<?php echo $item_id; ?>" class="widefat edit-menu-item-attr-title" name="menu-item-attr-title[<?php echo $item_id; ?>]" value="<?php echo esc_attr( $item->post_excerpt ); ?>" />
         </label>
      </p>
      <p class="field-link-target description">
         <label for="edit-menu-item-target-<?php echo $item_id; ?>">
         <input type="checkbox" id="edit-menu-item-target-<?php echo $item_id; ?>" value="_blank" name="menu-item-target[<?php echo $item_id; ?>]"<?php checked( $item->target, '_blank' ); ?> />
         <?php _e( 'Open link in a new window/tab' ); ?>
         </label>
      </p>
      <p class="field-css-classes description description-thin">
         <label for="edit-menu-item-classes-<?php echo $item_id; ?>">
         <?php _e( 'CSS Classes (optional)' ); ?><br />
         <input type="text" id="edit-menu-item-classes-<?php echo $item_id; ?>" class="widefat code edit-menu-item-classes" name="menu-item-classes[<?php echo $item_id; ?>]" value="<?php echo esc_attr( implode(' ', $item->classes ) ); ?>" />
         </label>
      </p>
      <p class="field-xfn description description-thin">
         <label for="edit-menu-item-xfn-<?php echo $item_id; ?>">
         <?php _e( 'Link Relationship (XFN)' ); ?><br />
         <input type="text" id="edit-menu-item-xfn-<?php echo $item_id; ?>" class="widefat code edit-menu-item-xfn" name="menu-item-xfn[<?php echo $item_id; ?>]" value="<?php echo esc_attr( $item->xfn ); ?>" />
         </label>
      </p>
      <p class="field-description description description-wide">
         <label for="edit-menu-item-description-<?php echo $item_id; ?>">
         <?php _e( 'Description' ); ?><br />
         <textarea id="edit-menu-item-description-<?php echo $item_id; ?>" class="widefat edit-menu-item-description" rows="3" cols="20" name="menu-item-description[<?php echo $item_id; ?>]"><?php echo esc_html( $item->description ); // textarea_escaped ?></textarea>
         <span class="description"><?php _e('The description will be displayed in the menu if the current theme supports it.'); ?></span>
         </label>
      </p>
      <?php
         /* New fields insertion starts here */
         ?>      
      <p class="field-custom description description-wide">
         <label for="edit-menu-item-icon-<?php echo $item_id; ?>">
         <?php _e( 'آیکن منو' ); ?><br />
         <?php $icon_font_awesome = '
            <select id="edit-menu-item-icon-'.$item_id.'" name="menu-item-icon['.$item_id.']" class="widefat code edit-menu-item-custom js-example-basic-single icons-font-awesome">
            	<option value="none" '.selected(esc_attr( 'fa-'.$item->icon ), 'none', FALSE).'>-- خالی --</option>';
            
            foreach($this->icons_font_awesome as $name => $code)
            {
            $icon_font_awesome .= '
            	<option value="fa-'.$name.'" '.selected(esc_attr( $item->icon ), 'fa-'.$name, FALSE).'>'.$name.'&nbsp;&nbsp;'.$code.'</option>';
            }
            
            $icon_font_awesome .= '
            </select>';
            
            echo $icon_font_awesome;
            
            ?>
         </label>
      </p>
      <p class="field-custom description description-wide">
         <label style="margin-top:5px;float:right;" for="edit-menu-item-cmega-<?php echo $item_id; ?>">
         <?php echo '<input type="checkbox" id="edit-menu-item-cmega-'.$item_id.'" name="menu-item-cmega['.$item_id.']" class="menu-item-cmega widefat"';
        if ($item->cmega) {echo 'checked';}
        echo '/>';
            ?>
         <?php _e( 'غیرفعال سازی مگامنو' ); ?>
         </label>
      </p>
      <p class="field-custom description description-wide">
         <label style="margin-top:5px;float:right;" for="edit-menu-item-cimage-<?php echo $item_id; ?>">
         <?php echo '<input type="checkbox" id="edit-menu-item-cimage-'.$item_id.'" name="menu-item-cimage['.$item_id.']" class="menu-item-cimage widefat"';
        if ($item->cimage) {echo 'checked';}
        echo '/>';
            ?>
         <?php _e( 'استفاده به عنوان تصویر منو' ); ?>
         </label>
      </p>
      <p class="field-custom menu-image description description-wide">
         <label for="edit-menu-item-image-<?php echo $item_id; ?>">
         <?php _e( 'آدرس تصویر' ); ?><br />
         <?php echo '<input type="text" id="edit-menu-item-image-'.$item_id.'" name="menu-item-image['.$item_id.']" class="widefat code custom_media_url" value="'.esc_attr( $item->image ).'" />';
            ?>
            <input type="button" class="button button-primary custom_media_button" id="custom_media_button" name="menu-item-image-btn[<?php echo $item_id; ?>]" value="بارگذاری تصویر" style="margin-top:5px;" />
         </label>
      </p>
      <?php
         /* New fields insertion ends here */
         ?>
      <div class="menu-item-actions description-wide submitbox">
         <?php if( 'custom' != $item->type && $original_title !== false ) : ?>
         <p class="link-to-original">
            <?php printf( __('Original: %s'), '<a href="' . esc_attr( $item->url ) . '">' . esc_html( $original_title ) . '</a>' ); ?>
         </p>
         <?php endif; ?>
         <a class="item-delete submitdelete deletion" id="delete-<?php echo $item_id; ?>" href="<?php
            echo wp_nonce_url(
                add_query_arg(
                    array(
                        'action' => 'delete-menu-item',
                        'menu-item' => $item_id,
                    ),
                    remove_query_arg($removed_args, admin_url( 'nav-menus.php' ) )
                ),
                'delete-menu_item_' . $item_id
            ); ?>"><?php _e('Remove'); ?></a> <span class="meta-sep"> | </span> <a class="item-cancel submitcancel" id="cancel-<?php echo $item_id; ?>" href="<?php echo esc_url( add_query_arg( array('edit-menu-item' => $item_id, 'cancel' => time()), remove_query_arg( $removed_args, admin_url( 'nav-menus.php' ) ) ) );
            ?>#menu-item-settings-<?php echo $item_id; ?>"><?php _e('Cancel'); ?></a>
      </div>
      <input class="menu-item-data-db-id" type="hidden" name="menu-item-db-id[<?php echo $item_id; ?>]" value="<?php echo $item_id; ?>" />
      <input class="menu-item-data-object-id" type="hidden" name="menu-item-object-id[<?php echo $item_id; ?>]" value="<?php echo esc_attr( $item->object_id ); ?>" />
      <input class="menu-item-data-object" type="hidden" name="menu-item-object[<?php echo $item_id; ?>]" value="<?php echo esc_attr( $item->object ); ?>" />
      <input class="menu-item-data-parent-id" type="hidden" name="menu-item-parent-id[<?php echo $item_id; ?>]" value="<?php echo esc_attr( $item->menu_item_parent ); ?>" />
      <input class="menu-item-data-position" type="hidden" name="menu-item-position[<?php echo $item_id; ?>]" value="<?php echo esc_attr( $item->menu_order ); ?>" />
      <input class="menu-item-data-type" type="hidden" name="menu-item-type[<?php echo $item_id; ?>]" value="<?php echo esc_attr( $item->type ); ?>" />
   </div>
   <!-- .menu-item-settings-->
   <ul class="menu-item-transport"></ul>
   <?php
      $output .= ob_get_clean();
      
      }
      }
            