<?php

class My_Elementor_Widgets {

	protected static $instance = null;

	public static function get_instance() {
		if ( ! isset( static::$instance ) ) {
			static::$instance = new static;
		}

		return static::$instance;
	}

	protected function __construct() {
		require_once('widgets/services.php');
        if (az_woo()) {
            require_once('widgets/woo-products.php');
        } else {
            require_once('widgets/edd-products.php');
		}
		if (az_woo()) {
			require_once('widgets/woo-products-block.php');
		} else {
			require_once('widgets/edd-products-block.php');
		}
		require_once('widgets/posts.php');
		require_once('widgets/posts-block.php');
		require_once('widgets/special-offer.php');
		require_once('widgets/ads-image.php');
		require_once('widgets/slider.php');
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'register_widgets' ] );
	}

	public function register_widgets() {
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Our_Service_Box() );
		if(az_woo()) {
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type(new \Elementor\Azin_Woo_Products());
		} else {
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type(new \Elementor\Azin_Edd_Products());
		}
		if (az_woo()) {
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type(new \Elementor\Azin_Woo_Products_Block());
		} else {
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type(new \Elementor\Azin_Edd_Products_Block());
		}
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Azin_Blog_Posts() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Azin_Blog_Posts_Block() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Special_Offer() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Ads_Image() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Slider() );
	}

}

add_action( 'init', 'my_elementor_init' );
function my_elementor_init() {
	My_Elementor_Widgets::get_instance();
}

function add_elementor_widget_categories( $elements_manager ) {

	$elements_manager->add_category(
		'azin-file',
		[
			'title' => 'آذین فایل',
			'icon' => 'fas fa-plug',
		]
	);

}
add_action( 'elementor/elements/categories_registered', 'add_elementor_widget_categories' );

//For Google Fonts:
add_filter( 'elementor/frontend/print_google_fonts', '__return_false' );

//For Font Awesome:
add_action( 'elementor/frontend/after_register_styles',function() {
	foreach( [ 'solid', 'regular', 'brands' ] as $style ) {
		wp_deregister_style( 'elementor-icons-fa-' . $style );
	}
}, 20 );