<?php /* Additional dashboard links */
if ( class_exists( 'EDD_Front_End_Submissions' ) ) {
  function az_fes_dashboard_menus() {
    $menu_items = array();
    
      // Dashboard tab
    $menu_items['home'] = array(
      "icon" => "tachometer-alt",
      "task" => array( 'dashboard', '' ),
      "name" => 'پیشخوان',
    );
    
    // Profile tab
    $menu_items['profile'] = array(
      "icon" => "pen-square",
      "task" => array( 'profile' ),
      "name" => 'نمایه',
    );
    
    // "Products" tab
    $menu_items['my_products'] = array(
      "icon" => "briefcase",
      "task" => array( 'products' ),
      "name" => 'محصولات',
    );
    
    // Add "Product" tab
    if ( EDD_FES()->vendors->vendor_can_create_product() ) {
      $menu_items['new_product'] = array(
        "icon" => "plus-circle",
        "task" => array( 'new-product' ),
        "name" => 'محصول جدید',
      );
    }
    
    // Earnings tab
    if ( EDD_FES()->integrations->is_commissions_active() ) {
      $menu_items['earnings'] = array(
        "icon" => "dollar-sign",
        "task" => array( 'earnings' ),
        "name" => 'درآمد',
      );
    }
    
    // Orders tab
    if ( EDD_FES()->vendors->vendor_can_view_orders() ){
      $menu_items['orders'] = array(
        "icon" => "shopping-cart",
        "task" => array( 'orders' ),
        "name" => 'فروش های من',
      );
    }
    
    /* Support for EDD Wishlists
    if( class_exists( 'EDD_Wish_Lists' ) ) {
      $menu_items[ 'wishlists' ] = array(
        "task" => array( 'wishlist' ),
        "icon" => "heart",
        "name" => 'علاقه مندی ها'
      );
    }*/

    // Download tab :: Purchased items for download
    $menu_items[ 'downloads' ] = array(
      "task" => array( 'download' ),
      "icon" => "download",
      "name" => 'دانلودها'
    );
    
    if( class_exists( 'EDD_Points_Renderer' ) ) {
        $menu_items[ 'points' ] = array(
        "task" => array( 'points' ),
        "icon" => "gift",
        "name" => 'امتیازات'
    );
    }

    if( class_exists( 'EDD_Software_Licensing' ) ) {
        $menu_items[ 'license' ] = array(
        "task" => array( 'license' ),
        "icon" => "key",
        "name" => 'لایسنس ها'
    );
    }
    
    // Invoice tab
    $menu_items[ 'purchases' ] = array(
        "task" => array( 'purchases' ),
        "icon" => "list-alt",
        "name" => 'خریدهای من'
    );
     
    if( class_exists( 'EDD_Wallet' ) ) {
     $menu_items['wallet'] = array(
        "icon" => "credit-card",
        "task" => array( 'wallet' ),
        "name" => 'کیف پول',
      );  
    }
      if( class_exists( 'Awesome_Support' ) ) { 
      $ticket_submit_id = wpas_get_option( 'ticket_submit' );
            if(is_array($ticket_submit_id)){
                $ticket_submit = $ticket_submit_id[0];
            }
            else {
                $ticket_submit = $ticket_submit_id;
            }
            $tpost = get_post((int)$ticket_submit); 
      $tslug = $tpost->post_name;
      $menu_items['submit-ticket'] = array(
        "icon" => "paper-plane",
        "task" => $tslug,
        "name" => 'ارسال تیکت',
        "link" => $tslug,
      );
      }
      if( class_exists( 'Awesome_Support' ) ) { 
      $lpost = get_post((int)wpas_get_option( 'ticket_list' )); 
      $lslug = $lpost->post_name;
      $menu_items['tickets'] = array(
        "icon" => "list",
        "task" => $lslug,
        "name" => 'تیکت ها',
        "link" => $lslug,
      );
      }
      if( class_exists( 'Affiliate_WP' ) ) { 
      $apost = get_post(affwp_get_affiliate_area_page_id()); 
      $aslug = $apost->post_name;
      $menu_items['affiliate'] = array(
        "icon" => "handshake",
        "task" => $aslug,
        "name" => 'همکاری در فروش',
        "link" => $aslug,
      );
      }
      $menu_items['logout'] = array(
        "icon" => "power-off",
        "task" => array( 'logout' ),
        "name" => 'خروج',
      );  
      return $menu_items;
  }

add_filter( 'fes_vendor_dashboard_menu', 'az_fes_dashboard_menus', 10, 2 ); 
}   


function az_custom_task_wishlist($custom,$task){
  
    if( 'wishlist' == $task ) {
      $custom = 'wishlist';
    } 
    
    if( 'download' == $task ) {
      $custom = 'download';
    }
    
    if( 'points' == $task ) {
      $custom = 'points';
    }

    if( 'license' == $task ) {
      $custom = 'license';
    }
    
    if( 'purchases' == $task ) {
      $custom = 'purchases';
    }
    if( 'wallet' == $task ) {
      $custom = 'wallet';
    }

return $custom; 
}

add_filter('fes_signal_custom_task', 'az_custom_task_wishlist', 10, 2 ); 


 function az_custom_template_wishlist($task){
  
  if($_GET[ 'task' ] == 'wishlist') {   
    $template = EDD_FES()->templates->fes_get_template_part( 'frontend', 'wishlist' );  
    return $template;
  } 
  
  if($_GET[ 'task' ] == 'download') {   
    $template = EDD_FES()->templates->fes_get_template_part( 'frontend', 'download' );  
    return $template;
  } 
     
  if($_GET[ 'task' ] == 'points') {   
    $template = EDD_FES()->templates->fes_get_template_part( 'frontend', 'points' );  
    return $template;
  } 

  if($_GET[ 'task' ] == 'license') {   
    $template = EDD_FES()->templates->fes_get_template_part( 'frontend', 'license' );  
    return $template;
  } 
  
  if($_GET[ 'task' ] == 'purchases') {    
    $template = EDD_FES()->templates->fes_get_template_part( 'frontend', 'invoices' );  
    return $template;
  } 
    
  if($_GET[ 'task' ] == 'wallet') {   
    $template = EDD_FES()->templates->fes_get_template_part( 'frontend', 'wallet' );  
    return $template;
  }
}

add_action('fes_custom_task_wishlist', 'az_custom_template_wishlist', 10, 2 ); 
add_action('fes_custom_task_download', 'az_custom_template_wishlist', 10, 2 );
add_action('fes_custom_task_purchases', 'az_custom_template_wishlist', 10, 2 );
add_action('fes_custom_task_points', 'az_custom_template_wishlist', 10, 2 );
add_action('fes_custom_task_license', 'az_custom_template_wishlist', 10, 2 );
add_action('fes_custom_task_withdraw', 'az_custom_template_wishlist', 10, 2 );
add_action('fes_custom_task_wallet', 'az_custom_template_wishlist', 10, 2 );
?>