<?php
    /**
     * ReduxFramework Sample Config File
     * For full documentation, please visit: http://docs.reduxframework.com/
     */

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }
    if ( ! class_exists( 'ReduxFramework_extension_vendor_support' ) ) {
        if ( file_exists( dirname( __FILE__ ) . '/vendor_support/extension_vendor_support.php' ) ) {
            require dirname( __FILE__ ) . '/vendor_support/extension_vendor_support.php';
            new ReduxFramework_extension_vendor_support();
        }
    }
    //FontAwesome Icons
    require_once( dirname( __FILE__ ) . '/fa.php' );
    // This is your option name where all the Redux data is stored.
    $opt_name = "az_data";

    // Background Patterns Reader
    $sample_patterns_path = ReduxFramework::$_dir . 'assets/img/patterns/';
    $sample_patterns_url  = ReduxFramework::$_url . 'assets/img/patterns/';
    $sample_patterns      = array();
    
    if ( is_dir( $sample_patterns_path ) ) {

        if ( $sample_patterns_dir = opendir( $sample_patterns_path ) ) {
            $sample_patterns = array();

            while ( ( $sample_patterns_file = readdir( $sample_patterns_dir ) ) !== false ) {

                if ( stristr( $sample_patterns_file, '.png' ) !== false || stristr( $sample_patterns_file, '.jpg' ) !== false ) {
                    $name              = explode( '.', $sample_patterns_file );
                    $name              = str_replace( '.' . end( $name ), '', $sample_patterns_file );
                    $sample_patterns[] = array(
                        'alt' => $name,
                        'img' => $sample_patterns_url . $sample_patterns_file
                    );
                }
            }
        }
    }

    //Footer Background Patterns Reader
    $footer_patterns_path = ReduxFramework::$_dir . 'assets/img/fbg/';
    $footer_patterns_url  = ReduxFramework::$_url . 'assets/img/fbg/';
    $footer_patterns      = array();
    
    if ( is_dir( $footer_patterns_path ) ) {

        if ( $footer_patterns_dir = opendir( $footer_patterns_path ) ) {
            $footer_patterns = array();

            while ( ( $footer_patterns_file = readdir( $footer_patterns_dir ) ) !== false ) {

                if ( stristr( $footer_patterns_file, '.png' ) !== false || stristr( $footer_patterns_file, '.jpg' ) !== false ) {
                    $name              = explode( '.', $footer_patterns_file );
                    $name              = str_replace( '.' . end( $name ), '', $footer_patterns_file );
                    $footer_patterns[] = array(
                        'alt' => $name,
                        'img' => $footer_patterns_url . $footer_patterns_file
                    );
                }
            }
        }
    }

    /**
     * ---> SET ARGUMENTS
     * All the possible arguments for Redux.
     * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
     * */

    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        // TYPICAL -> Change these values as you need/desire
        'opt_name'             => $opt_name,
        // This is where your data is stored in the database and also becomes your global variable name.
        'display_name'         => $theme->get( 'Name' ),
        // Name that appears at the top of your panel
        'display_version'      => $theme->get( 'Version' ),
        // Version that appears at the top of your panel
        'menu_type'            => 'submenu',
        //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
        'allow_sub_menu'       => true,
        // Show the sections below the admin menu item or not
        'menu_title'           => __( 'تنظیمات پوسته', 'redux-framework-demo' ),
        'page_title'           => __( 'تنظیمات پوسته', 'redux-framework-demo' ),
        // You will need to generate a Google API key to use this feature.
        // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
        'google_api_key'       => '',
        // Set it you want google fonts to update weekly. A google_api_key value is required.
        'google_update_weekly' => false,
        // Must be defined to add google fonts to the typography module
        'async_typography'     => true,
        // Use a asynchronous font on the front end or font string
        //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
        'admin_bar'            => true,
        // Show the panel pages on the admin bar
        'admin_bar_icon'       => 'dashicons-admin-generic',
        // Choose an icon for the admin bar menu
        'admin_bar_priority'   => 50,
        // Choose an priority for the admin bar menu
        'global_variable'      => '',
        // Set a different name for your global variable other than the opt_name
        'dev_mode'             => false,
        // Show the time the page took to load, etc
        'update_notice'        => true,
        // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
        'customizer'           => true,
        // Enable basic customizer support
        //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
        //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

        // OPTIONAL -> Give you extra features
        'page_priority'        => null,
        // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
        'page_parent'          => 'themes.php',
        // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
        'page_permissions'     => 'manage_options',
        // Permissions needed to access the options panel.
        'menu_icon'            => '',
        // Specify a custom URL to an icon
        'last_tab'             => '',
        // Force your panel to always open to a specific tab (by id)
        'page_icon'            => 'icon-themes',
        // Icon displayed in the admin panel next to your menu_title
        'page_slug'            => '',
        // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
        'save_defaults'        => true,
        // On load save the defaults to DB before user clicks save or not
        'default_show'         => false,
        // If true, shows the default value next to each field that is not the default value.
        'default_mark'         => '',
        // What to print by the field's title if the value shown is default. Suggested: *
        'show_import_export'   => true,
        // Shows the Import/Export panel when not used as a field.

        // CAREFUL -> These options are for advanced use only
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
        'output_tag'           => true,
        // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
        // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

        // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
        'database'             => '',
        // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
        'use_cdn'              => false,
        'show_options_object' => false,
        // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

        // HINTS
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => 'lightgray',
            'icon_size'     => 'normal',
            'tip_style'     => array(
                'color'   => 'red',
                'shadow'  => true,
                'rounded' => false,
                'style'   => '',
            ),
            'tip_position'  => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    );
    // Panel Intro text -> before the form
    if ( ! isset( $args['global_variable'] ) || $args['global_variable'] !== false ) {
        if ( ! empty( $args['global_variable'] ) ) {
            $v = $args['global_variable'];
        } else {
            $v = str_replace( '-', '_', $args['opt_name'] );
        }
        $args['intro_text'] = '';
    } else {
        $args['intro_text'] = '';
    }

    // Add content after the form.
    $args['footer_text'] = '';

    Redux::setArgs( $opt_name, $args );

    /*
     * ---> END ARGUMENTS
     */


    /*
     * ---> START HELP TABS
     */

    $tabs = array(
        array(
            'id'      => 'redux-help-tab-1',
            'title'   => __( 'راهنمای پوسته آذین فایل', 'redux-framework-demo' ),
            'content' => __( '<p>لطفا قبل از استفاده از امکانات پوسته فایل راهنمای ارائه شده به همراه پوسته را به دقت مطالعه نمایید.<br />پوسته آذین فایل فقط از طریق سایت ژاکت به فروش می رسد و نسخه های منتشر شده توسط سایت های دیگر به هیچ هنوان قانونی نبوده و فروش آنها حرام می باشد. <br />لطفا در صورت سوال، مشکل، انتقادات و پیشنهادات با تلگرام بنده به شماره تلفن 09127729027 (حسینخانی) در تماس باشید.</p>', 'redux-framework-demo' )
        ),
    );
    Redux::setHelpTab( $opt_name, $tabs );
    /*
     * <--- END HELP TABS
     */
    if ( class_exists( 'WooCommerce' )) {
        $block_cat = 'product_cat';
    } else {
        $block_cat = 'download_category';
    }

    /*
     *
     * ---> START SECTIONS
     *
     */

    // -> START Basic Fields
    Redux::setSection( $opt_name, array(
        'title'            => __( 'تنظیمات خانه', 'redux-framework-demo' ),
        'id'               => 'menu_home',
        'desc'             => __( 'تنظیمات صفحه اول سایت', 'redux-framework-demo' ),
        'customizer_width' => '400px',
        'icon'             => 'el el-home'
    ) );

    Redux::setSection( $opt_name, array(
        'title'            => __( 'لوگو سایت', 'redux-framework-demo' ),
        'icon'             => 'el el-picasa',
        'id'               => 'sitelogo',
        'subsection'       => true,
        'customizer_width' => '450px',
        'desc'             => 'تنظیمات مربوط به لوگوی سایت',
        'fields'           => array(
            array(
                'id'       => 'site_logo',
                'type'     => 'media',
                'url'      => true,
                'readonly' => false,
                'title'    => __( 'لوگو شما', 'redux-framework-demo' ),
                'compiler' => 'true',
                'desc'     => __( 'لوگوی سایت خود را از این بخش آپلود نمایید.', 'redux-framework-demo' ),
                'subtitle' => __( 'اندازه مناسب: 140 در 60', 'redux-framework-demo' ),
                'default'  => array( 'url' => get_template_directory_uri()."/images/logo.png" ),
            ),
            array(
                'id'       => 'site_logo_retina',
                'type'     => 'media',
                'url'      => true,
                'readonly' => false,
                'title'    => __( 'لوگو رتینا', 'redux-framework-demo' ),
                'compiler' => 'true',
                'desc'     => __( 'لوگو سایت را در اندازه دو برابر لوگو آپلود نمایید', 'redux-framework-demo' ),
                'subtitle' => __( 'اندازه مناسب: 280 در 120', 'redux-framework-demo' ),
                'default'  => array( 'url' => get_template_directory_uri()."/images/logo2x.png" ),
            ),
            array(
                'id'       => 'site_favicon',
                'type'     => 'media',
                'url'      => true,
                'readonly' => false,
                'title'    => __( 'فاوآیکون', 'redux-framework-demo' ),
                'compiler' => 'true',
                'mode'      => false, 
                'desc'     => __( 'آیکن سایت خود را آپلود نمایید. این آیکن در برخی از مرورگرها کنار آدرس شما نمایش داده می شود.', 'redux-framework-demo' ),
                'subtitle' => __( '', 'redux-framework-demo' ),
                'default'  => array( 'url' => get_template_directory_uri()."/images/favicon.png" ),
            ),
        )
    ) );
    Redux::setSection( $opt_name, array(
        'title'            => __( 'استایل پوسته', 'redux-framework-demo' ),
        'icon'             => 'el el-brush',
        'id'               => 'theme-style',
        'subsection'       => true,
        'customizer_width' => '500px',
        'desc'             => __( 'رنگبندی و شخصی سازی استایل پوسته', 'redux-framework-demo' ),
        'fields'           => array(
            array(
            'id'       => 'custom_color',
            'type'     => 'color',
            'title'    => 'رنگبندی پوسته',
            'subtitle' => 'رنگبندی کلی پوسته را انتخاب نمایید، این رنگ به عنوان تم اصلی سایت در بیشتر بخش ها مانند منو و ابزارک ها نمایش داده می شود.',
            'default'  => '#1E88E5',
            'validate' => 'color',
            'transparent' => false,
            ),
            array(
                'id'       => 'site_bg',
                'type'     => 'image_select',
                'output'    => array('body'), // An array of CSS selectors
                'tiles'    => true,
                'title'    => 'پس زمینه',
                'subtitle' => 'تصویری را به عنوان پس زمینه انتخاب نمایید.',
                'options'  => $sample_patterns,
                'required' => array( 'bg_switch', '!=', true ),
            ),
            array(
                'id'       => 'bg_switch',
                'type'     => 'switch',
                'title'    => 'پس زمینه سفارشی',
                'subtitle' => 'انتخاب رنگ پس زمینه یا آپلود عکس دلخواه',
                'default'  => false
            ),
            array(         
                'id'       => 'site_bg_custom',
                'output'    => array('body'), // An array of CSS selectors
                'type'     => 'background',
                'title'    => 'پس زمینه سایت را مطابق سلیقه شخصی سازی نمایید.',
                'default'  => array(
                    'background-color' => '#F5F5F5',
                ),
                'required' => array( 'bg_switch', '=', true ),
            ),
            array(
                'id'       => 'footer_bg',
                'type'     => 'image_select',
                'output'    => array('footer.sfooter'), // An array of CSS selectors
                'tiles'    => true,
                'title'    => 'پس زمینه فوتر سایت',
                'subtitle' => 'تصویری را به عنوان پس زمینه فوتر سایت انتخاب نمایید.',
                'options'  => $footer_patterns,
                'required' => array( 'fbg_switch', '!=', true ),
            ),
            array(
                'id'       => 'fbg_switch',
                'type'     => 'switch',
                'title'    => 'پس زمینه سفارشی فوتر',
                'subtitle' => 'انتخاب رنگ پس زمینه یا آپلود عکس دلخواه برای فوتر سایت',
                'default'  => false
            ),
            array(         
                'id'       => 'site_fbg_custom',
                'output'    => array('footer.sfooter'), // An array of CSS selectors
                'type'     => 'background',
                'title'    => 'پس زمینه فوتر سایت را مطابق سلیقه شخصی سازی نمایید.',
                'default'  => array(
                    'background-color' => '#2d2d2d',
                ),
                'required' => array( 'fbg_switch', '=', true ),
            ),
            array(
                'id' => 'hstyle-section-start',
                'type' => 'section',
                'title' => 'رنگبندی هدر',
                'subtitle' => 'رنگبندی نواحی مختلف هدر را مدیریت نمایید.',
                'indent' => true,
            ),
            array(
                'id'       => 'htop_bar',
                'type'     => 'color',
                'title'    => 'رنگ نوار بالای هدر',
                'default'  => '#ef5662',
                'validate' => 'color',
                'transparent' => false,
            ),
            array(
                'id'       => 'head_color',
                'type'     => 'color',
                'title'    => 'رنگ پس زمینه هدر',
                'default'  => '#ffffff',
                'validate' => 'color',
                'transparent' => false,
            ),
            array(
                'id'       => 'head_text_color',
                'type'     => 'color',
                'title'    => 'رنگ متن های هدر',
                'default'  => '#212529',
                'validate' => 'color',
                'transparent' => false,
            ),
            array(
                'id'       => 'head_link_color',
                'type'     => 'color',
                'title'    => 'رنگ لینک های هدر',
                'default'  => '#212529',
                'validate' => 'color',
                'transparent' => false,
            ),
            array(
                'id'       => 'head_lhover_color',
                'type'     => 'color',
                'title'    => 'رنگ لینک های هدر هنگام عبور ماوس',
                'default'  => '#000000',
                'validate' => 'color',
                'transparent' => false,
            ),
            array(
                'id'       => 'menu_color',
                'type'     => 'color',
                'title'    => 'رنگ پس زمینه منوی اصلی',
                'default'  => '#F7F6F6',
                'validate' => 'color',
                'transparent' => false,
            ),
            array(
                'id'       => 'menu_text_color',
                'type'     => 'color',
                'title'    => 'رنگ متن های منوی اصلی',
                'default'  => '#4D4D4D',
                'validate' => 'color',
                'transparent' => false,
            ),
            array(
                 'id'     => 'hstyle-section-end',
                 'type'   => 'section',
                 'indent' => false,
            ),
        )
    ) );
Redux::setSection( $opt_name, array(
        'title'      => 'نحوه نمایش صفحه اصلی',
        'icon'       => 'el el-th',
        'id'         => 'home_blocks_prod',
        'subsection' => true,
        'desc'       => 'بلاک های مطالب صفحه اصلی (در صورت عدم مدیریت صفحه اصلی قالب توسط المنتور)',
        'fields'     => array(
            array(
                'id'       => 'main_type_post',
                'type'     => 'switch',
                'title'    => 'نمایش نوشته های معمولی',
                'subtitle' => 'نمایش نوشته های معمولی به جای محصولات در صفحه اصلی',
                'default'  => false,
                'required' => array( 'show_blocks', '!=', true ),
            ),
            array(
                'id'       => 'show_prod_block',
                'type'     => 'switch',
                'title'    => 'محصولات جدید',
                'subtitle' => 'نمایش بلاک محصولات جدید در حالت نمایش نوشته های معمولی در صفحه اصلی',
                'default'  => false,
                'required' => array( 'main_type_post', '=', true ),
            ),
            array(
                'id'       => 'prod_block_title',
                'type'     => 'text',
                'title'    => 'عنوان بلاک',
                'default'  => 'جدیدترین محصولات',
                'required' => array( 'show_prod_block', '=', true ),
            ),
            array(
                'id'       => 'prod_block_play',
                'type'     => 'switch',
                'title'    => 'حرکت خودکار',
                'default'  => false,
                'required' => array( 'show_prod_block', '=', true ),
            ),
            array(
                'id'       => 'prod_block_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fas' ),
                'title'    => 'آیکن',
                'class'    => ' font-icons fas',
                'default'  => 'fa fa-shopping-bag',
                'options'  => $iconArray,
                'required' => array( 'show_prod_block', '=', true ),
            ),
            array(
                'id'       => 'show_blocks',
                'type'     => 'switch',
                'title'    => 'نمایش به صورت بلاک بندی شده',
                'subtitle' => 'به صورت پیش فرض آخرین محصولات به صورت صفحه بندی شده نمایش داده میشود',
                'default'  => false
            ),
            array(
                'id'       => 'show_recent_prod',
                'type'     => 'switch',
                'title'    => 'محصولات جدید',
                'subtitle' => 'نمایش بلاک محصولات جدید',
                'default'  => false,
                'required' => array( 'show_blocks', '=', true ),
            ),
            array(
                'id'       => 'recent_prod_title',
                'type'     => 'text',
                'title'    => 'عنوان بلاک',
                'default'  => 'جدیدترین محصولات',
                'required' => array( 'show_recent_prod', '=', true ),
            ),
            array(
                'id'       => 'recent_prod_play',
                'type'     => 'switch',
                'title'    => 'حرکت خودکار',
                'default'  => false,
                'required' => array( 'show_recent_prod', '=', true ),
            ),
            array(
                'id'       => 'recent_prod_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fas' ),
                'title'    => 'آیکن',
                'class'    => ' font-icons fas',
                'default'  => 'fa fa-shopping-bag',
                'options'  => $iconArray,
                'required' => array( 'show_recent_prod', '=', true ),
            ),
            array(
                'id'       => 'show_block_one',
                'type'     => 'switch',
                'title'    => 'نمایش بلاک اول',
                'default'  => false,
                'required' => array( 'show_blocks', '=', true ),
            ),
            array(
                'id'       => 'block_one_title',
                'type'     => 'text',
                'title'    => 'عنوان بلاک اول',
                'default'  => 'بلاک اول',
                'required' => array( 'show_block_one', '=', true ),
            ),
            array(
                'id'       => 'block_one_play',
                'type'     => 'switch',
                'title'    => 'حرکت خودکار',
                'default'  => false,
                'required' => array( 'show_block_one', '=', true ),
            ),
            array(
                'id'       => 'block_one_cat',
                'type'     => 'select',
                'data'     => 'terms',
                'args' => array('taxonomies'=>$block_cat, 'args'=>array()),
                'multi'    => false,
                'title'    => 'دسته بندی بلاک اول',
                'required' => array( 'show_block_one', '=', true ),
           ),
           array(
                'id'       => 'block_one_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fas' ),
                'title'    => 'آیکن بلاک اول',
                'class'    => ' font-icons fas',
                'default'  => 'fa fa-bell',
                'options'  => $iconArray,
                'required' => array( 'show_block_one', '=', true ),
            ),
            array(
                'id'       => 'show_block_two',
                'type'     => 'switch',
                'title'    => 'نمایش بلاک دوم',
                'required' => array( 'show_blocks', '=', true ),
                'default'  => false
            ),
            array(
                'id'       => 'block_two_title',
                'type'     => 'text',
                'title'    => 'عنوان بلاک دوم',
                'default'  => 'بلاک دوم',
                'required' => array( 'show_block_two', '=', true ),
            ),
            array(
                'id'       => 'block_two_play',
                'type'     => 'switch',
                'title'    => 'حرکت خودکار',
                'default'  => false,
                'required' => array( 'show_block_two', '=', true ),
            ),
            array(
                'id'       => 'block_two_cat',
                'type'     => 'select',
                'data'     => 'terms',
                'args' => array('taxonomies'=>$block_cat, 'args'=>array()),
                'multi'    => false,
                'title'    => 'دسته بندی بلاک دوم',
                'required' => array( 'show_block_two', '=', true ),
           ),
           array(
                'id'       => 'block_two_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fas' ),
                'title'    => 'آیکن بلاک دوم',
                'class'    => ' font-icons fas',
                'default'  => 'fa fa-bell',
                'options'  => $iconArray,
                'required' => array( 'show_block_two', '=', true ),
            ),
             array(
                'id'       => 'show_block_three',
                'type'     => 'switch',
                'title'    => 'نمایش بلاک سوم',
                'required' => array( 'show_blocks', '=', true ),
                'default'  => false
            ),
            array(
                'id'       => 'block_three_title',
                'type'     => 'text',
                'title'    => 'عنوان بلاک سوم',
                'default'  => 'بلاک سوم',
                'required' => array( 'show_block_three', '=', true ),
            ),
            array(
                'id'       => 'block_three_play',
                'type'     => 'switch',
                'title'    => 'حرکت خودکار',
                'default'  => false,
                'required' => array( 'show_block_three', '=', true ),
            ),
            array(
                'id'       => 'block_three_cat',
                'type'     => 'select',
                'data'     => 'terms',
                'args' => array('taxonomies'=>$block_cat, 'args'=>array()),
                'multi'    => false,
                'title'    => 'دسته بندی بلاک سوم',
                'required' => array( 'show_block_three', '=', true ),
           ),
           array(
                'id'       => 'block_three_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fas' ),
                'title'    => 'آیکن بلاک سوم',
                'class'    => ' font-icons fas',
                'default'  => 'fa fa-bell',
                'options'  => $iconArray,
                'required' => array( 'show_block_three', '=', true ),
            ),
            array(
                'id'       => 'show_block_four',
                'type'     => 'switch',
                'title'    => 'نمایش بلاک چهارم',
                'required' => array( 'show_blocks', '=', true ),
                'default'  => false
            ),
            array(
                'id'       => 'block_four_title',
                'type'     => 'text',
                'title'    => 'عنوان بلاک چهارم',
                'default'  => 'بلاک چهارم',
                'required' => array( 'show_block_four', '=', true ),
            ),
            array(
                'id'       => 'block_four_play',
                'type'     => 'switch',
                'title'    => 'حرکت خودکار',
                'default'  => false,
                'required' => array( 'show_block_four', '=', true ),
            ),
            array(
                'id'       => 'block_four_cat',
                'type'     => 'select',
                'data'     => 'terms',
                'args' => array('taxonomies'=>$block_cat, 'args'=>array()),
                'multi'    => false,
                'title'    => 'دسته بندی بلاک چهارم',
                'required' => array( 'show_block_four', '=', true ),
           ),
           array(
                'id'       => 'block_four_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fas' ),
                'title'    => 'آیکن بلاک چهارم',
                'class'    => ' font-icons fas',
                'default'  => 'fa fa-bell',
                'options'  => $iconArray,
                'required' => array( 'show_block_four', '=', true ),
            ),
             array(
                'id'       => 'show_block_five',
                'type'     => 'switch',
                'title'    => 'نمایش بلاک پنجم',
                'required' => array( 'show_blocks', '=', true ),
                'default'  => false
            ),
            array(
                'id'       => 'block_five_title',
                'type'     => 'text',
                'title'    => 'عنوان بلاک پنجم',
                'default'  => 'بلاک پنجم',
                'required' => array( 'show_block_five', '=', true ),
            ),
            array(
                'id'       => 'block_five_play',
                'type'     => 'switch',
                'title'    => 'حرکت خودکار',
                'default'  => false,
                'required' => array( 'show_block_five', '=', true ),
            ),
            array(
                'id'       => 'block_five_cat',
                'type'     => 'select',
                'data'     => 'terms',
                'args' => array('taxonomies'=>$block_cat, 'args'=>array()),
                'multi'    => false,
                'title'    => 'دسته بندی بلاک پنجم',
                'required' => array( 'show_block_five', '=', true ),
           ),
           array(
                'id'       => 'block_five_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fas' ),
                'title'    => 'آیکن بلاک پنجم',
                'class'    => ' font-icons fas',
                'default'  => 'fa fa-bell',
                'options'  => $iconArray,
                'required' => array( 'show_block_five', '=', true ),
            ),
           array(
                'id'       => 'show_pblock_one',
                'type'     => 'switch',
                'title'    => 'نمایش بلاک نوشته اول',
                'default'  => false,
                'required' => array( 'show_blocks', '=', true ),
            ),
            array(
                'id'       => 'pblock_one_title',
                'type'     => 'text',
                'title'    => 'عنوان بلاک نوشته اول',
                'default'  => 'بلاک نوشته اول',
                'required' => array( 'show_pblock_one', '=', true ),
            ),
            array(
                'id'       => 'pblock_one_play',
                'type'     => 'switch',
                'title'    => 'حرکت خودکار',
                'default'  => false,
                'required' => array( 'show_pblock_one', '=', true ),
            ),
            array(
                'id'       => 'pblock_one_cat',
                'type'     => 'select',
                'data'     => 'categories',
                'multi'    => false,
                'title'    => 'دسته بندی بلاک نوشته اول',
                'required' => array( 'show_pblock_one', '=', true ),
           ),
           array(
                'id'       => 'pblock_one_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fas' ),
                'title'    => 'آیکن بلاک نوشته اول',
                'class'    => ' font-icons fas',
                'default'  => 'fa fa-bell',
                'options'  => $iconArray,
                'required' => array( 'show_pblock_one', '=', true ),
            ),
            array(
                'id'       => 'show_pblock_two',
                'type'     => 'switch',
                'title'    => 'نمایش بلاک نوشته دوم',
                'required' => array( 'show_blocks', '=', true ),
                'default'  => false
            ),
            array(
                'id'       => 'pblock_two_title',
                'type'     => 'text',
                'title'    => 'عنوان بلاک نوشته دوم',
                'default'  => 'بلاک نوشته دوم',
                'required' => array( 'show_pblock_two', '=', true ),
            ),
            array(
                'id'       => 'pblock_two_play',
                'type'     => 'switch',
                'title'    => 'حرکت خودکار',
                'default'  => false,
                'required' => array( 'show_pblock_two', '=', true ),
            ),
            array(
                'id'       => 'pblock_two_cat',
                'type'     => 'select',
                'data'     => 'categories',
                'multi'    => false,
                'title'    => 'دسته بندی بلاک نوشته دوم',
                'required' => array( 'show_pblock_two', '=', true ),
           ),
           array(
                'id'       => 'pblock_two_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fas' ),
                'title'    => 'آیکن بلاک نوشته دوم',
                'class'    => ' font-icons fas',
                'default'  => 'fa fa-bell',
                'options'  => $iconArray,
                'required' => array( 'show_pblock_two', '=', true ),
            ),
             array(
                'id'       => 'show_pblock_three',
                'type'     => 'switch',
                'title'    => 'نمایش بلاک نوشته سوم',
                'required' => array( 'show_blocks', '=', true ),
                'default'  => false
            ),
            array(
                'id'       => 'pblock_three_title',
                'type'     => 'text',
                'title'    => 'عنوان بلاک نوشته سوم',
                'default'  => 'بلاک نوشته سوم',
                'required' => array( 'show_pblock_three', '=', true ),
            ),
            array(
                'id'       => 'pblock_three_play',
                'type'     => 'switch',
                'title'    => 'حرکت خودکار',
                'default'  => false,
                'required' => array( 'show_pblock_three', '=', true ),
            ),
            array(
                'id'       => 'pblock_three_cat',
                'type'     => 'select',
                'data'     => 'categories',
                'multi'    => false,
                'title'    => 'دسته بندی بلاک نوشته سوم',
                'required' => array( 'show_pblock_three', '=', true ),
           ),
           array(
                'id'       => 'pblock_three_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fas' ),
                'title'    => 'آیکن بلاک نوشته سوم',
                'class'    => ' font-icons fas',
                'default'  => 'fa fa-bell',
                'options'  => $iconArray,
                'required' => array( 'show_pblock_three', '=', true ),
            ),
            array(
                'id'       => 'show_pblock_four',
                'type'     => 'switch',
                'title'    => 'نمایش بلاک نوشته چهارم',
                'required' => array( 'show_blocks', '=', true ),
                'default'  => false
            ),
            array(
                'id'       => 'pblock_four_title',
                'type'     => 'text',
                'title'    => 'عنوان بلاک نوشته چهارم',
                'default'  => 'بلاک نوشته چهارم',
                'required' => array( 'show_pblock_four', '=', true ),
            ),
            array(
                'id'       => 'pblock_four_play',
                'type'     => 'switch',
                'title'    => 'حرکت خودکار',
                'default'  => false,
                'required' => array( 'show_pblock_four', '=', true ),
            ),
            array(
                'id'       => 'pblock_four_cat',
                'type'     => 'select',
                'data'     => 'categories',
                'multi'    => false,
                'title'    => 'دسته بندی بلاک نوشته چهارم',
                'required' => array( 'show_pblock_four', '=', true ),
           ),
           array(
                'id'       => 'pblock_four_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fas' ),
                'title'    => 'آیکن بلاک نوشته چهارم',
                'class'    => ' font-icons fas',
                'default'  => 'fa fa-bell',
                'options'  => $iconArray,
                'required' => array( 'show_pblock_four', '=', true ),
            ),
             array(
                'id'       => 'show_pblock_five',
                'type'     => 'switch',
                'title'    => 'نمایش بلاک نوشته پنجم',
                'required' => array( 'show_blocks', '=', true ),
                'default'  => false
            ),
            array(
                'id'       => 'pblock_five_title',
                'type'     => 'text',
                'title'    => 'عنوان بلاک نوشته پنجم',
                'default'  => 'بلاک نوشته پنجم',
                'required' => array( 'show_pblock_five', '=', true ),
            ),
            array(
                'id'       => 'pblock_five_play',
                'type'     => 'switch',
                'title'    => 'حرکت خودکار',
                'default'  => false,
                'required' => array( 'show_pblock_five', '=', true ),
            ),
            array(
                'id'       => 'pblock_five_cat',
                'type'     => 'select',
                'data'     => 'categories',
                'multi'    => false,
                'title'    => 'دسته بندی بلاک نوشته پنجم',
                'required' => array( 'show_pblock_five', '=', true ),
           ),
           array(
                'id'       => 'pblock_five_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fas' ),
                'title'    => 'آیکن بلاک نوشته پنجم',
                'class'    => ' font-icons fas',
                'default'  => 'fa fa-bell',
                'options'  => $iconArray,
                'required' => array( 'show_pblock_five', '=', true ),
            ),
            
        ) 
    ) );

        Redux::setSection( $opt_name, array(
        'title'      => 'تنظیمات تبلیغات',
        'icon'       => 'el el-bullhorn',
        'id'         => 'home_ads',
        'subsection' => true,
        'desc'       => 'مدیریت تبلیغات (در صورت عدم مدیریت صفحه اصلی توسط المنتور به جز تبلیغات هدر)',
        'fields'     => array(
            array(
                'id'       => 'show_head_banner',
                'type'     => 'switch',
                'title'    => 'نمایش تبلیغ هدر',
                'default'  => false
            ),
            array(
                'id'       => 'show_head_mobile',
                'type'     => 'switch',
                'title'    => 'نمایش تبلیغ هدر در موبایل',
                'default'  => false,
                'required' => array( 'show_head_banner', '=', true ),
            ),
            array(
                'id'       => 'head_banner',
                'type'     => 'media',
                'url'      => true,
                'readonly' => false,
                'title'    => __( 'تبلیغات هدر', 'redux-framework-demo' ),
                'compiler' => 'true',
                'desc'     => __( 'تبلیغ نمایش داده شده در هدر', 'redux-framework-demo' ),
                'subtitle' => __( 'اندازه مناسب: 1188 در 134', 'redux-framework-demo' ),
                'default'  => array( 'url' => get_template_directory_uri()."/images/hbanner.png" ),
                'required' => array( 'show_head_banner', '=', true ),
            ),
            array(
                'id'       => 'head_banner_link',
                'type'     => 'text',
                'title'    => 'لینک بنر',
                'default'  => '#',
                'required' => array( 'show_head_banner', '=', true ),
            ),
            array(
                'id'       => 'head_banner_title',
                'type'     => 'text',
                'title'    => 'عنوان',
                'default'  => '#',
                'required' => array( 'show_head_banner', '=', true ),
            ),
            array(
                'id'       => 'show_foot_banner',
                'type'     => 'switch',
                'title'    => 'نمایش تبلیغ فوتر',
                'default'  => false
            ),
            array(
                'id'       => 'foot_banner',
                'type'     => 'media',
                'url'      => true,
                'readonly' => false,
                'title'    => __( 'تبلیغات فوتر', 'redux-framework-demo' ),
                'compiler' => 'true',
                'desc'     => __( 'تبلیغ نمایش داده شده در فوتر', 'redux-framework-demo' ),
                'subtitle' => __( 'اندازه مناسب: 840 در 150', 'redux-framework-demo' ),
                'default'  => array( 'url' => get_template_directory_uri()."/images/fbanner.png" ),
                'required' => array( 'show_foot_banner', '=', true ),
            ),
            array(
                'id'       => 'foot_banner_link',
                'type'     => 'text',
                'title'    => 'لینک بنر',
                'default'  => '#',
                'required' => array( 'show_foot_banner', '=', true ),
            ),
            array(
                'id'       => 'foot_banner_title',
                'type'     => 'text',
                'title'    => 'عنوان',
                'default'  => '#',
                'required' => array( 'show_foot_banner', '=', true ),
            ),
            // ads banner #1
            array(
                'id'       => 'show_ads_banner1',
                'type'     => 'switch',
                'title'    => 'نمایش تبلیغ بالای محصولات صفحه اصلی',
                'default'  => false
            ),
            array(
                'id'       => 'show_ads_banner1_down',
                'type'     => 'switch',
                'title'    => 'نمایش در صفحه محصول',
                'subtitle'     => 'در صفحه محصول زیر محصول نمایش داده میشود',
                'default'  => true,
                'required' => array( 'show_ads_banner1', '=', true ),
            ),
            array(
                'id'       => 'show_ads_banner1_post',
                'type'     => 'switch',
                'title'    => 'نمایش در صفحه نوشته',
                'subtitle'     => 'در صفحه نوشته زیر نوشته نمایش داده میشود',
                'default'  => true,
                'required' => array( 'show_ads_banner1', '=', true ),
            ),
            array(
                'id'       => 'banner1_one',
                'type'     => 'media',
                'url'      => true,
                'readonly' => false,
                'title'    => __( 'تبلیغ اول', 'redux-framework-demo' ),
                'compiler' => 'true',
                'desc'     => __( 'اولین تبلیغ نمایش داده شده بالای محصولات', 'redux-framework-demo' ),
                'subtitle' => __( 'اندازه مناسب: 472 در 170', 'redux-framework-demo' ),
                'default'  => array( 'url' => get_template_directory_uri()."/images/ads.png" ),
                'required' => array( 'show_ads_banner1', '=', true ),
            ),
            array(
                'id'       => 'banner1_one_link',
                'type'     => 'text',
                'title'    => 'لینک بنر',
                'default'  => '#',
                'required' => array( 'show_ads_banner1', '=', true ),
            ),
            array(
                'id'       => 'banner1_one_title',
                'type'     => 'text',
                'title'    => 'عنوان',
                'default'  => '#',
                'required' => array( 'show_ads_banner1', '=', true ),
            ),
            array(
                'id'       => 'banner1_two',
                'type'     => 'media',
                'url'      => true,
                'readonly' => false,
                'title'    => __( 'تبلیغ دوم', 'redux-framework-demo' ),
                'compiler' => 'true',
                'desc'     => __( 'دومین تبلیغ نمایش داده شده بالای محصولات', 'redux-framework-demo' ),
                'subtitle' => __( 'اندازه مناسب: 472 در 170', 'redux-framework-demo' ),
                'default'  => array( 'url' => get_template_directory_uri()."/images/ads.png" ),
                'required' => array( 'show_ads_banner1', '=', true ),
            ),
            array(
                'id'       => 'banner1_two_link',
                'type'     => 'text',
                'title'    => 'لینک بنر',
                'default'  => '#',
                'required' => array( 'show_ads_banner1', '=', true ),
            ),
            array(
                'id'       => 'banner1_two_title',
                'type'     => 'text',
                'title'    => 'عنوان',
                'default'  => '#',
                'required' => array( 'show_ads_banner1', '=', true ),
            ),
            array(
                'id'       => 'banner1_three',
                'type'     => 'media',
                'url'      => true,
                'readonly' => false,
                'title'    => __( 'تبلیغ سوم', 'redux-framework-demo' ),
                'compiler' => 'true',
                'desc'     => __( 'سومین تبلیغ نمایش داده شده بالای محصولات', 'redux-framework-demo' ),
                'subtitle' => __( 'اندازه مناسب: 472 در 170', 'redux-framework-demo' ),
                'default'  => array( 'url' => get_template_directory_uri()."/images/ads.png" ),
                'required' => array( 'show_ads_banner1', '=', true ),
            ),
            array(
                'id'       => 'banner1_three_link',
                'type'     => 'text',
                'title'    => 'لینک بنر',
                'default'  => '#',
                'required' => array( 'show_ads_banner1', '=', true ),
            ),
            array(
                'id'       => 'banner1_three_title',
                'type'     => 'text',
                'title'    => 'عنوان',
                'default'  => '#',
                'required' => array( 'show_ads_banner1', '=', true ),
            ),
            // ads banner #2
            array(
                'id'       => 'show_ads_banner2',
                'type'     => 'switch',
                'title'    => 'نمایش تبلیغ پایین محصولات صفحه اصلی',
                'subtitle'     => 'در صفحه محصول زیر محصول نمایش داده میشود',
                'default'  => false
            ),
            array(
                'id'       => 'show_ads_banner2_down',
                'type'     => 'switch',
                'title'    => 'نمایش در صفحه محصول',
                'subtitle'     => 'در صفحه محصول زیر محصول نمایش داده میشود',
                'default'  => true,
                'required' => array( 'show_ads_banner2', '=', true ),
            ),
            array(
                'id'       => 'show_ads_banner2_post',
                'type'     => 'switch',
                'title'    => 'نمایش در صفحه نوشته',
                'subtitle'     => 'در صفحه نوشته زیر نوشته نمایش داده میشود',
                'default'  => true,
                'required' => array( 'show_ads_banner2', '=', true ),
            ),
            array(
                'id'       => 'banner2_one',
                'type'     => 'media',
                'url'      => true,
                'readonly' => false,
                'title'    => __( 'تبلیغ اول', 'redux-framework-demo' ),
                'compiler' => 'true',
                'desc'     => __( 'اولین تبلیغ نمایش داده شده زیر محصولات', 'redux-framework-demo' ),
                'subtitle' => __( 'اندازه مناسب: 472 در 170', 'redux-framework-demo' ),
                'default'  => array( 'url' => get_template_directory_uri()."/images/ads.png" ),
                'required' => array( 'show_ads_banner2', '=', true ),
            ),
            array(
                'id'       => 'banner2_one_link',
                'type'     => 'text',
                'title'    => 'لینک بنر',
                'default'  => '#',
                'required' => array( 'show_ads_banner2', '=', true ),
            ),
            array(
                'id'       => 'banner2_one_title',
                'type'     => 'text',
                'title'    => 'عنوان',
                'default'  => '#',
                'required' => array( 'show_ads_banner2', '=', true ),
            ),
            array(
                'id'       => 'banner2_two',
                'type'     => 'media',
                'url'      => true,
                'readonly' => false,
                'title'    => __( 'تبلیغ دوم', 'redux-framework-demo' ),
                'compiler' => 'true',
                'desc'     => __( 'دومین تبلیغ نمایش داده شده زیر محصولات', 'redux-framework-demo' ),
                'subtitle' => __( 'اندازه مناسب: 472 در 170', 'redux-framework-demo' ),
                'default'  => array( 'url' => get_template_directory_uri()."/images/ads.png" ),
                'required' => array( 'show_ads_banner2', '=', true ),
            ),
            array(
                'id'       => 'banner2_two_link',
                'type'     => 'text',
                'title'    => 'لینک بنر',
                'default'  => '#',
                'required' => array( 'show_ads_banner2', '=', true ),
            ),
            array(
                'id'       => 'banner2_two_title',
                'type'     => 'text',
                'title'    => 'عنوان',
                'default'  => '#',
                'required' => array( 'show_ads_banner2', '=', true ),
            ),
            array(
                'id'       => 'banner2_three',
                'type'     => 'media',
                'url'      => true,
                'readonly' => false,
                'title'    => __( 'تبلیغ سوم', 'redux-framework-demo' ),
                'compiler' => 'true',
                'desc'     => __( 'سومین تبلیغ نمایش داده شده زیر محصولات', 'redux-framework-demo' ),
                'subtitle' => __( 'اندازه مناسب: 472 در 170', 'redux-framework-demo' ),
                'default'  => array( 'url' => get_template_directory_uri()."/images/ads.png" ),
                'required' => array( 'show_ads_banner2', '=', true ),
            ),
            array(
                'id'       => 'banner2_three_link',
                'type'     => 'text',
                'title'    => 'لینک بنر',
                'default'  => '#',
                'required' => array( 'show_ads_banner2', '=', true ),
            ),
            array(
                'id'       => 'banner2_three_title',
                'type'     => 'text',
                'title'    => 'عنوان',
                'default'  => '#',
                'required' => array( 'show_ads_banner2', '=', true ),
            ),
            //Download Page Header Banner
            array(
                'id'       => 'show_down_head_banner',
                'type'     => 'switch',
                'title'    => 'نمایش تبلیغ بالای محصول',
                'default'  => false
            ),
            array(
                'id'       => 'down_head_banner',
                'type'     => 'media',
                'url'      => true,
                'readonly' => false,
                'title'    => __( 'تبلیغ بالای محصول', 'redux-framework-demo' ),
                'compiler' => 'true',
                'desc'     => __( 'تبلیغ نمایش داده شده در بالای باکس محصول در صفحه محصول', 'redux-framework-demo' ),
                'subtitle' => __( 'اندازه مناسب: 840 در 150', 'redux-framework-demo' ),
                'default'  => array( 'url' => get_template_directory_uri()."/images/fbanner.png" ),
                'required' => array( 'show_down_head_banner', '=', true ),
            ),
            array(
                'id'       => 'down_head_banner_link',
                'type'     => 'text',
                'title'    => 'لینک بنر',
                'default'  => '#',
                'required' => array( 'show_down_head_banner', '=', true ),
            ),
            array(
                'id'       => 'down_head_banner_title',
                'type'     => 'text',
                'title'    => 'عنوان',
                'default'  => '#',
                'required' => array( 'show_down_head_banner', '=', true ),
            ),
            //Download Page Footer Banner
            array(
                'id'       => 'show_down_foot_banner',
                'type'     => 'switch',
                'title'    => 'نمایش تبلیغ پایین محصول',
                'default'  => false
            ),
            array(
                'id'       => 'down_foot_banner',
                'type'     => 'media',
                'url'      => true,
                'readonly' => false,
                'title'    => __( 'تبلیغ پایین محصول', 'redux-framework-demo' ),
                'compiler' => 'true',
                'desc'     => __( 'تبلیغ نمایش داده شده در زیر باکس محصول در صفحه محصول', 'redux-framework-demo' ),
                'subtitle' => __( 'اندازه مناسب: 840 در 150', 'redux-framework-demo' ),
                'default'  => array( 'url' => get_template_directory_uri()."/images/fbanner.png" ),
                'required' => array( 'show_down_foot_banner', '=', true ),
            ),
            array(
                'id'       => 'down_foot_banner_link',
                'type'     => 'text',
                'title'    => 'لینک بنر',
                'default'  => '#',
                'required' => array( 'show_down_foot_banner', '=', true ),
            ),
            array(
                'id'       => 'down_foot_banner_title',
                'type'     => 'text',
                'title'    => 'عنوان',
                'default'  => '#',
                'required' => array( 'show_down_foot_banner', '=', true ),
            ),
            //Post Page Header Banner
            array(
                'id'       => 'show_post_head_banner',
                'type'     => 'switch',
                'title'    => 'نمایش تبلیغ بالای نوشته',
                'default'  => false
            ),
            array(
                'id'       => 'post_head_banner',
                'type'     => 'media',
                'url'      => true,
                'readonly' => false,
                'title'    => __( 'تبلیغ بالای نوشته', 'redux-framework-demo' ),
                'compiler' => 'true',
                'desc'     => __( 'تبلیغ نمایش داده شده در بالای باکس نوشته در صفحه نوشته', 'redux-framework-demo' ),
                'subtitle' => __( 'اندازه مناسب: 840 در 150', 'redux-framework-demo' ),
                'default'  => array( 'url' => get_template_directory_uri()."/images/fbanner.png" ),
                'required' => array( 'show_post_head_banner', '=', true ),
            ),
            array(
                'id'       => 'post_head_banner_link',
                'type'     => 'text',
                'title'    => 'لینک بنر',
                'default'  => '#',
                'required' => array( 'show_post_head_banner', '=', true ),
            ),
            array(
                'id'       => 'post_head_banner_title',
                'type'     => 'text',
                'title'    => 'عنوان',
                'default'  => '#',
                'required' => array( 'show_post_head_banner', '=', true ),
            ),
            //Post Page Footer Banner
            array(
                'id'       => 'show_post_foot_banner',
                'type'     => 'switch',
                'title'    => 'نمایش تبلیغ پایین نوشته',
                'default'  => false
            ),
            array(
                'id'       => 'post_foot_banner',
                'type'     => 'media',
                'url'      => true,
                'readonly' => false,
                'title'    => __( 'تبلیغ پایین نوشته', 'redux-framework-demo' ),
                'compiler' => 'true',
                'desc'     => __( 'تبلیغ نمایش داده شده در زیر باکس نوشته در صفحه نوشته', 'redux-framework-demo' ),
                'subtitle' => __( 'اندازه مناسب: 840 در 150', 'redux-framework-demo' ),
                'default'  => array( 'url' => get_template_directory_uri()."/images/fbanner.png" ),
                'required' => array( 'show_post_foot_banner', '=', true ),
            ),
            array(
                'id'       => 'post_foot_banner_link',
                'type'     => 'text',
                'title'    => 'لینک بنر',
                'default'  => '#',
                'required' => array( 'show_post_foot_banner', '=', true ),
            ),
            array(
                'id'       => 'post_foot_banner_title',
                'type'     => 'text',
                'title'    => 'عنوان',
                'default'  => '#',
                'required' => array( 'show_post_foot_banner', '=', true ),
            ),
        ) 
    ) );


    Redux::setSection( $opt_name, array(
        'title'      => 'تنظیمات بلاک ها',
        'icon'       => 'el el-th-large',
        'id'         => 'home_blocks',
        'subsection' => true,
        'desc'       => 'بلاک های صفحه اصلی (در صورت عدم مدیریت صفحه اصلی قالب توسط المنتور به جز بلاک متن صفحه اصلی)',
        'fields'     => array(
            array(
                'id'       => 'show_special',
                'type'     => 'switch',
                'title'    => 'باکس پیشنهاد شگفت انگیز',
                'subtitle' => 'نمایش محصولات تخفیف خورده به صورت اسلایدر در صفحه اصلی',
                'default'  => false
            ),
            array(
                'id'       => 'show_most_viewed',
                'type'     => 'switch',
                'title'    => 'محصولات پربازدید',
                'subtitle' => 'نمایش محصولات پربازدید در صفحه اصلی',
                'default'  => false
            ),
            array(
                'id'       => 'most_saled',
                'type'     => 'switch',
                'title'    => 'نمایش محصولات پر فروش',
                'subtitle' => 'با فعال سازی این گزینه محصولات پر فروش به جای محصولات پر بازدید نمایش داده می شود',
                'default'  => false,
                'required' => array( 'show_most_viewed', '=', true ),
            ),
            array(
                'id'       => 'most_viewed_title',
                'type'     => 'text',
                'title'    => 'عنوان بلاک',
                'default'  => 'محصولات پربازدید',
                'required' => array( 'show_most_viewed', '=', true ),
            ),
            array(
                'id'       => 'most_viewed_play',
                'type'     => 'switch',
                'title'    => 'حرکت خودکار',
                'default'  => false,
                'required' => array( 'show_most_viewed', '=', true ),
            ),
            array(
                'id'       => 'most_viewed_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fas' ),
                'title'    => 'آیکن',
                'class'    => ' font-icons fas',
                'default'  => 'fa fa-shopping-bag',
                'options'  => $iconArray,
                'required' => array( 'show_most_viewed', '=', true ),
            ),
            array(
                'id'       => 'show_main_blog',
                'type'     => 'switch',
                'title'    => 'نمایش بلاک مطالب وبلاگ',
                'subtitle' => 'نمایش یک بلاک جهت نمایش آخرین مطالب وبلاگ در صفحه اصلی',
                'default'  => true
            ),
            array(
                'id'       => 'main_blog_title',
                'type'     => 'text',
                'title'    => 'عنوان بلاک',
                'default'  => 'مطالب رایگان',
                'required' => array( 'show_main_blog', '=', true ),
            ),
            array(
                'id'       => 'main_blog_play',
                'type'     => 'switch',
                'title'    => 'حرکت خودکار',
                'default'  => false,
                'required' => array( 'show_main_blog', '=', true ),
            ),
            array(
                'id'       => 'main_blog_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fas' ),
                'title'    => 'آیکن',
                'class'    => ' font-icons fas',
                'default'  => 'fa fa-file-alt',
                'options'  => $iconArray,
                'required' => array( 'show_main_blog', '=', true ),
            ),
            array(
                'id'       => 'main_blog_count',
                'type'     => 'text',
                'title'    => 'تعداد مطالب جهت  نمایش',
                'default'  => 8,
                'required' => array( 'show_main_blog', '=', true ),
            ),
            array(
                'id'       => 'main_blog_cat',
                'type'     => 'select',
                'data'     => 'categories',
                'multi'    => true,
                'title'    => 'دسته بندی',
                'subtitle' => 'نمایش مطالب دسته بندی (های) خاص',
                'desc'     => 'برای نمایش همه خالی رها کنید.',
                'required' => array( 'show_main_blog', '=', true ),
            ),
            array(
                'id'       => 'show_mbtn',
                'type'     => 'switch',
                'title'    => 'نمایش دکمه همه',
                'default'  => true,
                'required' => array( 'show_main_blog', '=', true )
            ),
            array(
                'id'       => 'show_main_page',
                'type'     => 'switch',
                'title'    => 'نمایش بلاک متن صفحه اصلی',
                'subtitle' => 'نمایش یک بلاک جهت نمایش متن در صفحه اصلی',
                'default'  => true
            ),
            array(
                'id'       => 'main_title',
                'type'     => 'text',
                'title'    => 'عنوان بلاک',
                'default'  => 'متن صفحه اصلی',
                'required' => array( 'show_main_page', '=', true ),
            ),
            array(
                'id'      => 'main_text',
                'type'    => 'editor',
                'title'   => 'متن بلاک',
                'default' => '<p>این متن از طریق بخش تنظیمات قالب قابل تغییر است. شما می توانید متنی را در صفحه اصلی سایت نمایش دهید.<br />
لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است. چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است و برای شرایط فعلی تکنولوژی مورد نیاز و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد. کتابهای زیادی در شصت و سه درصد گذشته، حال و آینده شناخت فراوان جامعه و متخصصان را می طلبد تا با نرم افزارها شناخت بیشتری را برای طراحان رایانه ای علی الخصوص طراحان خلاقی و فرهنگ پیشرو در زبان فارسی ایجاد کرد. در این صورت می توان امید داشت که تمام و دشواری موجود در ارائه راهکارها و شرایط سخت تایپ به پایان رسد وزمان مورد نیاز شامل حروفچینی دستاوردهای اصلی و جوابگوی سوالات پیوسته اهل دنیای موجود طراحی اساسا مورد استفاده قرار گیرد.</p>',
                'args'    => array(
                    'wpautop'       => false,
                    'media_buttons' => false,
                    'textarea_rows' => 5,
                    'teeny'         => false,
                    'quicktags'     => true,
                ),
                'required' => array( 'show_main_page', '=', true ),            
            ),
        ) 
    ) );

    Redux::setSection( $opt_name, array(
        'title'            => 'اسلایدر',
        'icon'             => 'el el-video',
        'desc'             => 'تنظیمات اسلایدر (در صورت عدم مدیریت صفحه اصلی قالب توسط المنتور)',
        'id'               => 'home_slider',
        'subsection'       => true,
        'customizer_width' => '700px',
        'fields'           => array(
            array(
                'id'       => 'show_slider',
                'type'     => 'switch',
                'title'    => 'نمایش اسلایدر در صفحه اصلی',
                'default'  => false
            ),
            array(
                'id'       => 'show_slider_mobile',
                'type'     => 'switch',
                'title'    => 'نمایش اسلایدر در حالت موبایل',
                'default'  => true,
                'required' => array( 'show_slider', '=', true ),
            ),
            array(
                'id'          => 'main_slider',
                'type'        => 'slides',
                'title'       => 'تنظیمات اسلایدر',
                'subtitle'    => 'تصاویر مربوط به اسلایدر را از این بخش وارد نمایید.',
                'desc'        => '',
                'placeholder' => array(
                    'title'       => 'عنوان',
                    'description' => 'توضیحات',
                    'url'         => 'پیوند',
                ),
                'required' => array( 'show_slider', '=', true ),
            ),
        )
    ) );

    Redux::setSection( $opt_name, array(
        'title'            => 'باکس خدمات',
        'icon'             => 'el el-certificate',
        'desc'             => 'تنظیمات باکس خدمات (در صورت عدم مدیریت صفحه اصلی قالب توسط المنتور)',
        'id'               => 'home_services',
        'subsection'       => true,
        'customizer_width' => '700px',
        'fields'           => array(
            array(
                'id'       => 'show_services',
                'type'     => 'switch',
                'title'    => 'نمایش باکس خدمات در صفحه اصلی و صفحه محصول',
                'default'  => true
            ),
            array(
                'id'       => 'show_services_main',
                'type'     => 'switch',
                'title'    => 'نمایش باکس خدمات در صفحه اصلی',
                'default'  => true,
                'required' => array( 'show_services', '=', true ),
            ),
            array(
                'id'       => 'show_services_prod',
                'type'     => 'switch',
                'title'    => 'نمایش باکس خدمات در صفحه محصول',
                'default'  => true,
                'required' => array( 'show_services', '=', true ),
            ),
            array(
                'id'       => 'show_services_mobile',
                'type'     => 'switch',
                'title'    => 'نمایش باکس در حالت موبایل',
                'default'  => true,
                'required' => array( 'show_services', '=', true ),
            ),
            array(
                'id'       => 'ser_one_title',
                'type'     => 'text',
                'title' => 'عنوان باکس اول',
                'default'  => 'پرداخت امن',
                'required' => array( 'show_services', '=', true ),
            ),
            array(
                'id'       => 'ser_one_des',
                'type'     => 'text',
                'title' => 'توضیحات باکس اول',
                'default'  => 'توسط کارتهای شتاب',
                'required' => array( 'show_services', '=', true ),
            ),
            array(
                'id'       => 'ser_one_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fas' ),
                'title'    => 'آیکن',
                'class'    => ' font-icons fas',
                'default'  => 'fa fa-credit-card',
                'options'  => $iconArray,
                'required' => array( 'show_services', '=', true ),
            ),
            array(
                'id'       => 'ser_two_title',
                'type'     => 'text',
                'title'    => 'عنوان باکس دوم',
                'default'  => 'بازگشت وجه',
                'required' => array( 'show_services', '=', true ),
            ),
            array(
                'id'       => 'ser_two_des',
                'type'     => 'text',
                'title'    => 'توضیحات باکس دوم',
                'default'  => 'ضمانت بازگشت تا 7 روز',
                'required' => array( 'show_services', '=', true ),
            ),
            array(
                'id'       => 'ser_two_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fas' ),
                'title'    => 'آیکن',
                'class'    => ' font-icons fas',
                'default'  => 'fa fa-calendar-check',
                'options'  => $iconArray,
                'required' => array( 'show_services', '=', true ),
            ),
            array(
                'id'       => 'ser_three_title',
                'type'     => 'text',
                'title'    => 'عنوان باکس سوم',
                'default'  => 'تضمین کیفیت',
                'required' => array( 'show_services', '=', true ),
            ),
            array(
                'id'       => 'ser_three_des',
                'type'     => 'text',
                'title'    => 'توضیحات باکس سوم',
                'default'  => 'ضمانت تضمین کیفیت',
                'required' => array( 'show_services', '=', true ),
            ),
            array(
                'id'       => 'ser_three_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fas' ),
                'title'    => 'آیکن',
                'class'    => ' font-icons fas',
                'default'  => 'fa fa-certificate',
                'options'  => $iconArray,
                'required' => array( 'show_services', '=', true ),
            ),
            array(
                'id'       => 'ser_four_title',
                'type'     => 'text',
                'title'    => 'عنوان باکس چهارم',
                'default'  => 'پشتیبانی',
                'required' => array( 'show_services', '=', true ),
            ),
            array(
                'id'       => 'ser_four_des',
                'type'     => 'text',
                'title'    => 'توضیحات باکس چهارم',
                'default'  => '24 ساعته 7 روز هفته',
                'required' => array( 'show_services', '=', true ),
            ),
            array(
                'id'       => 'ser_four_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fas' ),
                'title'    => 'آیکن',
                'class'    => ' font-icons fas',
                'default'  => 'fa fa-question-circle',
                'options'  => $iconArray,
                'required' => array( 'show_services', '=', true ),
            ),
        )
    ) );

    // -> START Editors
    Redux::setSection( $opt_name, array(
        'title'            => 'تنظیمات عمومی',
        'id'               => 'general_setting',
        'customizer_width' => '500px',
        'icon'             => 'el el-cogs',
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => 'حالت تعمیرات',
        'icon'       => 'el el-wrench',
        'id'         => 'maintenance_mode',
        'desc'       => 'در حالت تعمیر سایت از دسترس کاربران خارج خواهد شد و فقط مدیر امکان مشاهده دارد.',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'maintenance',
                'type'     => 'switch',
                'title'    => 'فعال نمودن حالت تعمیرات',
                'subtitle' => 'در این حالت سایت از دسترس کاربران خارج خواهد شد.',
                'default'  => false,
            ),
            array(
                'id'       => 'maintenance_title',
                'type'     => 'text',
                'title'    => 'عنوان',
                'subtitle' => 'عنوان صفحه حالت تعمیرات',
                'default'  => 'حالت تعمیر',
                'required' => array( 'maintenance', '=', true ),
            ),
            array(
                'id'      => 'maintenance_msg',
                'type'    => 'editor',
                'title'   => 'پیام',
                'default' => 'در حال بروزرسانی، لطفا صبور باشید.',
                'args'    => array(
                    'wpautop'       => false,
                    'media_buttons' => false,
                    'textarea_rows' => 5,
                    'teeny'         => false,
                    'quicktags'     => true,
                ),
                'required' => array( 'maintenance', '=', true ),
            ),
        ),
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => 'تنظیمات هدر',
        'icon'       => 'el el-credit-card',
        'id'         => 'header-setting',
        'subsection' => true,
        'desc'       => 'شخصی سازی هدر سایت',
        'fields'     => array(
            array(
                'id'       => 'social_pos',
                'type'     => 'image_select',
                'title'    => 'موقعیت شبکه های اجتماعی',
                'subtitle' => 'محل قرارگیری لوگو شبکه های اجتماعی و اطلاعات تماس را مشخص نمایید.',
                'options'  => array(
                    '2' => array(
                        'alt' => 'سمت راست',
                        'img' => ReduxFramework::$_url . 'assets/img/rso.png'
                    ),
                    '1' => array(
                        'alt' => 'سمت چپ',
                        'img' => ReduxFramework::$_url . 'assets/img/lso.png'
                    ),
                ),
                'default'  => '1'
            ),
            array(
                'id'       => 'logo_pos',
                'type'     => 'image_select',
                'title'    => 'موقعیت لوگو',
                'subtitle' => 'محل قرارگیری لوگو سایت را مشخص نمایید.',
                'options'  => array(
                    '2' => array(
                        'alt' => 'سمت راست',
                        'img' => ReduxFramework::$_url . 'assets/img/rlogo.png'
                    ),
                    '1' => array(
                        'alt' => 'سمت چپ',
                        'img' => ReduxFramework::$_url . 'assets/img/llogo.png'
                    ),
                ),
                'default'  => '1'
            ),
            array(
                'id'       => 'mobile_search',
                'type'     => 'switch',
                'title'    => 'انتقال باکس جستجو از منوی سایت به زیر لوگو سایت در موبایل',
                'default'  => false,
            ),
            array(
                'id'       => 'ajax_search',
                'type'     => 'switch',
                'title'    => 'جستجوی زنده Ajax',
                'subtitle' => 'با فعال شدن این قابلیت نتایج جستجو با وارد شدن کلیدواژه نمایش داده می شود',
                'default'  => true,
            ),
            array(
                'id'       => 'search_type',
                'type'     => 'switch',
                'title'    => 'نوع جستجو',
                'subtitle' => 'نتایج جستجو در فایل ها یا نوشته ها (در صورت غیرفعال بودن فقط در فایل ها جستجو می شود)',
                'default'  => true,
            ),
            array(
                'id'       => 'fixed_head_top',
                'type'     => 'switch',
                'title'    => 'منوی ثابت', 
                'subtitle' => 'نمایش منوی هدر به صورت ثابت در هنگام پیمایش سایت',
                'default'  => true,
            ),
            array(
                'id'       => 'show_user_btn',
                'type'     => 'switch',
                'title'    => 'دکمه های کاربری',
                'subtitle' => 'نمایش دکمه های کاربری (ورود، عضویت و منوی کاربری) در بخش هدر',
                'default'  => true,
            ),
            array(
                'id'       => 'show_mo_btn',
                'type'     => 'switch',
                'title'    => 'نمایش دکمه های کاربری در حالت موبایل',
                'default'  => true,
                'required' => array( 'show_user_btn', '=', true ),
            ),
            array(
                'id'       => 'digits_mode',
                'type'     => 'switch',
                'title'    => 'سازگاری با افزونه دیجیتز',
                'subtitle' => 'با فعال بودن این حالت اگر افزونه دیجیتز را نصب کرده باشید، دکمه های ورود و عضویت به این افزونه متصل خواهد شد.',
                'default'  => true,
                'required' => array( 'show_user_btn', '=', true ),
            ),
            array(
                'id'       => 'digits_page',
                'type'     => 'switch',
                'title'    => 'اتصال به صفحه ورود به جای حالت پاپ آپ دیجیتز',
                'default'  => false,
                'required' => array( 'digits_mode', '=', true ),
            ),
            array(
                'id'       => 'recapcha_login',
                'type'     => 'switch',
                'title'    => 'گوگل کپچا در ورود',
                'subtitle' => 'فعال شدن گوگل کپچا در فرم ورود پاپ آپ',
                'default'  => false,
                'required' => array( 'show_user_btn', '=', true ),
            ),
            array(
                'id'       => 'site_key',
                'type'     => 'text',
                'title' => 'کلید سایت',
                'description' => 'دریافت از لینک رو به رو: <a href="https://www.google.com/recaptcha/" target="_blank">گوگل</a>',
                'required' => array( 'recapcha_login', '=', true ),
            ),
            array(
                'id'       => 'site_secret',
                'type'     => 'text',
                'title' => 'کلید امنیتی',
                'description' => 'دریافت از لینک رو به رو: <a href="https://www.google.com/recaptcha/" target="_blank">گوگل</a>',
                'required' => array( 'recapcha_login', '=', true ),
            ),
            array(
                'id'       => 'ch_login_link',
                'type'     => 'switch',
                'title'    => 'تغییر لینک دکمه ورود',
                'subtitle' => 'از این بخش برای اتصال دکمه ورود به صفحه ای خاص استفاده نمایید',
                'default'  => false,
                'required' => array( 'show_user_btn', '=', true ),
            ),
            array(
                'id'       => 'login_link',
                'type'     => 'text',
                'title' => 'تغییر لینک صفحه ورود',
                'Subtitle' => 'لینک صفحه به صورت کامل',
                'description' => 'مثال: http://example.com/login',
                'default'  => '#',
                'required' => array( 'ch_login_link', '=', true ),
            ),
            array(
                'id'       => 'ch_register_link',
                'type'     => 'switch',
                'title'    => 'لینک دکمه ثبت نام',
                'subtitle' => 'از این بخش برای اتصال دکمه ثبت نام به صفحه ای خاص استفاده نمایید',
                'default'  => false,
                'required' => array( 'show_user_btn', '=', true ),
            ),
            array(
                'id'       => 'register_link',
                'type'     => 'text',
                'title' => 'لینک صفحه ثبت نام',
                'subtitle' => 'لینک صفحه به صورت کامل',
                'description' => 'مثال: http://example.com/register',
                'default'  => '#',
                'required' => array( 'ch_register_link', '=', true ),
            ),
             array(
                'id'       => 'login_image',
                'type'     => 'media',
                'url'      => true,
                'readonly' => false,
                'title'    => 'جایگزینی تصویر صفحه ورود',
                'compiler' => 'true',
                'desc'     => 'تصویری را برای جایگزینی تصویر موجود در صفحه ورود بارگذاری نمایید',
                'subtitle' => __( 'اندازه مناسب: 402 در 331', 'redux-framework-demo' ),
                'default'  => array( 'url' => get_template_directory_uri()."/images/login.svg" ),
            ),
            array(
                'id'       => 'register_image',
                'type'     => 'media',
                'url'      => true,
                'readonly' => false,
                'title'    => 'جایگزینی تصویر صفحه ثبت نام',
                'compiler' => 'true',
                'desc'     => 'تصویری را برای جایگزینی تصویر موجود در صفحه ثبت نام بارگذاری نمایید',
                'subtitle' => __( 'اندازه مناسب: 402 در 331', 'redux-framework-demo' ),
                'default'  => array( 'url' => get_template_directory_uri()."/images/register.svg" ),
            ),
            array(
                'id'       => 'blog_menu',
                'type'     => 'switch',
                'title'    => 'دکمه وبلاگ',
                'subtitle' => 'نمایش دکمه وبلاگ در بخش منوی بالای سایت',
                'default'  => true,
            ),
            array(
                'id'       => 'blog_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fas' ),
                'title'    => 'آیکن دکمه',
                'class'    => ' font-icons fas',
                'default'  => 'fa fa-file-alt',
                'options'  => $iconArray,
                'required' => array( 'blog_menu', '=', true ),
            ),
            array(
                'id'       => 'blog_color',
                'type'     => 'select',
                'title' => 'رنگ',
                'options'  => array(
                    'btn-info'  =>  'آبی',
                    'btn-warning' =>  'زرد',
                    'btn-success'  =>  'سبز',
                    'btn-danger'  =>  'قرمز'
                ),
                'default'  => 'btn-success',
                'required' => array( 'blog_menu', '=', true ),
            ),
            array(
                'id'       => 'blog_text',
                'type'     => 'text',
                'title' => 'متن دکمه',
                'default'  => 'وبلاگ',
                'required' => array( 'blog_menu', '=', true ),
            ),
            array(
                'id'       => 'blog_link',
                'type'     => 'text',
                'title' => 'لینک دکمه',
                'default'  => '#',
                'required' => array( 'blog_menu', '=', true ),
            ),
            array(
                'id'       => 'show_bread',
                'type'     => 'switch',
                'title'    => 'بخش نان ریزه ها',
                'subtitle' => 'مایش بخش نان ریزه ها (لینک های تو در توی نشان دهنده مسیر)',
                'default'  => true,
            ),
            array(
                'id'       => 'show_loading_bar',
                'type'     => 'switch',
                'title'    => 'نوار بارگذاری',
                'subtitle' => 'نمایش نوار بارگذاری در بالای سایت',
                'default'  => true,
            ),
            array(
                'id'       => 'show_msg',
                'type'     => 'switch',
                'title'    => 'بخش اعلان',
                'subtitle' => 'نمایش بخش اعلان',
                'default'  => true,
            ),
            array(
                'id'=>'site_msg',
                'type' => 'textarea',
                'title' => 'متن پیام',
                'default' => 'به وب سایت ما خوش آمدید',
                'allowed_html' => array(
                    'a' => array(
                        'href' => array(),
                        'title' => array()
                    ),
                    'br' => array(),
                    'em' => array(),
                    'strong' => array()
                ),
                'required' => array( 'show_msg', '=', true ),
            ),
            array(
                'id'       => 'msg_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fas' ),
                'title'    => 'آیکن',
                'class'    => ' font-icons fas',
                'default'  => 'fa fa-bell',
                'options'  => $iconArray,
                'required' => array( 'show_msg', '=', true ),
            ),
            array(
                'id'       => 'msg_btn',
                'type'     => 'switch',
                'title' => 'نمایش دکمه اعلان',
                'default'  => false,
                'required' => array( 'show_msg', '=', true ),
            ),
            array(
                'id'       => 'msg_btn_color',
                'type'     => 'select',
                'title' => 'رنگ',
                'options'  => array(
                    'btn-info'  =>  'آبی',
                    'btn-warning' =>  'زرد',
                    'btn-success'  =>  'سبز',
                    'btn-danger'  =>  'قرمز'
                ),
                'default'  => 'btn-success',
                'required' => array( 'msg_btn', '=', true ),
            ),
            array(
                'id'       => 'msg_btn_text',
                'type'     => 'text',
                'title' => 'متن دکمه',
                'default'  => 'مشاهده',
                'required' => array( 'msg_btn', '=', true ),
            ),
            array(
                'id'       => 'msg_btn_link',
                'type'     => 'text',
                'title' => 'لینک دکمه',
                'default'  => '#',
                'required' => array( 'msg_btn', '=', true ),
            ),
            array(
                'id'       => 'user_close',
                'type'     => 'switch',
                'title' => 'قابلیت بسته شدن توسط کاربر',
                'default'  => true,
                'required' => array( 'show_msg', '=', true ),
            ),
            array(
            'id'       => 'msg_bgcolor',
            'type'     => 'color',
            'title'    => 'رنگ پس زمینه',
            'default'  => '#455A64',
            'validate' => 'color',
            'transparent' => false,
            'required' => array( 'show_msg', '=', true ),
            ),
            array(
            'id'       => 'msg_fcolor',
            'type'     => 'color',
            'title'    => 'رنگ متن پیام',
            'default'  => '#ffffff',
            'validate' => 'color',
            'transparent' => false,
            'required' => array( 'show_msg', '=', true ),
            ),
            array(
                'id'       => 'show_contact',
                'type'     => 'switch',
                'title' => 'اطلاعات تماس',
                'subtitle' => 'نمایش اطلاعات تماس',
                'default'  => true,
                'required' => array( 'header_nav', '!=', true ),
            ),
            array(
                'id'       => 'site_tel',
                'type'     => 'text',
                'title' => 'تلفن تماس',
                'default'  => '09111111111',
                'required' => array( 'show_contact', '=', true ),
            ),
            array(
                'id'       => 'site_email',
                'type'     => 'text',
                'title' => 'پست الکترونیک',
                'default'  => 'test@test.com',
                'required' => array( 'show_contact', '=', true ),
            ),
            array(
                'id'       => 'header_nav',
                'type'     => 'switch',
                'title' => 'نمایش منوی هدر',
                'subtitle' => 'نمایش منو به جای بخش اطلاعات تماس در بالای سایت',
                'default'  => false,
            ),
        )
    ) );

        Redux::setSection( $opt_name, array(
        'title'      => 'سایر تنظیمات',
        'icon'       => 'el el-cog',
        'id'         => 'side-setting',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'side_type',
                'type'     => 'image_select',
                'title'    => 'محل سایدبار',
                'subtitle' => 'محل قرارگیری سایدبار را مشخص نمایید.',
                'desc'     => '',
                'options'  => array(
                    '1' => array(
                        'alt' => 'سمت چپ',
                        'img' => ReduxFramework::$_url . 'assets/img/2cl.png'
                    ),
                    '2' => array(
                        'alt' => 'سمت راست',
                        'img' => ReduxFramework::$_url . 'assets/img/2cr.png'
                    )
                ),
                'default'  => '1'
            ),
            array(
                'id'       => 'show_side_mobile',
                'type'     => 'switch',
                'title' => 'نمایش سایدبار',
                'subtitle' => 'مشخص کنید که ساید بار در حالت تبلت و موبایل نمایش داده شود',
                'default'  => false,
            ),
            array(
                'id'       => 'sticky_side',
                'type'     => 'switch',
                'title' => 'سایدبار چسبان',
                'subtitle' => 'در این حالت ابزارک ها و بخش محتوا هنگام پیمایش صفحه به صورت ثابت میمانند تا فضای خالی ایجاد نشود',
                'default'  => true,
            ),
            array(
                'id'       => 'info_bar',
                'type'     => 'switch',
                'title' => 'نوار اطلاعات سایت',
                'subtitle' => 'نمایش بخش اطلاعات در قسمت فوتر جهت نمایش تعداد کاربران، خریدها و...',
                'default'  => false,
            ),
            array(
                'id'       => 'info_bar_prods',
                'type'     => 'switch',
                'title' => 'نمایش تعداد محصولات',
                'default'  => true,
                'required' => array( 'info_bar', '=', true ),
            ),
            array(
                'id'       => 'info_bar_sales',
                'type'     => 'switch',
                'title' => 'نمایش تعداد خریدها',
                'default'  => true,
                'required' => array( 'info_bar', '=', true ),
            ),
            array(
                'id'       => 'info_bar_users',
                'type'     => 'switch',
                'title' => 'نمایش تعداد کاربران',
                'default'  => true,
                'required' => array( 'info_bar', '=', true ),
            ),
            array(
                'id'       => 'info_bar_posts',
                'type'     => 'switch',
                'title' => 'نمایش تعداد نوشته ها',
                'default'  => true,
                'required' => array( 'info_bar', '=', true ),
            ),
            array(
            'id'       => 'info_bg_color',
            'type'     => 'color',
            'title'    => 'رنگ پس زمینه اطلاعات',
            'default'  => '#4A148C',
            'validate' => 'color',
            'transparent' => false,
            'required' => array( 'info_bar', '=', true ),
            ),
            array(
            'id'       => 'info_text_color',
            'type'     => 'color',
            'title'    => 'رنگ متن اطلاعات',
            'default'  => '#fff',
            'validate' => 'color',
            'transparent' => false,
            'required' => array( 'info_bar', '=', true ),
            ),
            array(
                'id'       => 'show_return_top',
                'type'     => 'switch',
                'title' => 'دکمه بازگشت به بالا',
                'subtitle' => 'نمایش دکمه بازگشت به بالا',
                'default'  => true,
            ),
            array(
                'id'       => 'show_cart_btn',
                'type'     => 'switch',
                'title' => 'دکمه سبد خرید',
                'subtitle' => 'نمایش دکمه سبد خرید',
                'default'  => true,
            ),
            array(
                'id'       => 'cart_btn_bottom',
                'type'     => 'text',
                'title' => 'فاصله از پایین',
                'default'  => '40',
                'required' => array( 'show_cart_btn', '=', true ),
            ),
            array(
                'id'       => 'cart_btn_left',
                'type'     => 'text',
                'title' => 'فاصله از چپ',
                'default'  => '20',
                'required' => array( 'show_cart_btn', '=', true ),
            ),
            array(
                'id'       => 'show_return_top',
                'type'     => 'switch',
                'title' => 'دکمه بازگشت به بالا',
                'subtitle' => 'نمایش دکمه بازگشت به بالا',
                'default'  => true,
            ),
            array(
                'id'       => 'return_top_bottom',
                'type'     => 'text',
                'title' => 'فاصله از پایین',
                'default'  => '40',
                'required' => array( 'show_return_top', '=', true ),
            ),
            array(
                'id'       => 'return_top_right',
                'type'     => 'text',
                'title' => 'فاصله از راست',
                'default'  => '20',
                'required' => array( 'show_return_top', '=', true ),
            ),
            array(
                'id'       => 'show_addr',
                'type'     => 'switch',
                'title' => 'بخش آدرس',
                'subtitle' => 'نمایش بخش آدرس در فوتر سایت',
                'default'  => false,
            ),
            array(
                'id'       => 'show_faddr',
                'type'     => 'switch',
                'title' => 'نمایش آدرس',
                'subtitle' => 'نمایش آدرس در فوتر سایت',
                'default'  => true,
                'required' => array( 'show_addr', '=', true ),
            ),
            array(
                'id'       => 'addr_text',
                'type'     => 'text',
                'title' => 'متن آدرس',
                'default'  => 'استان تهران، شهر تهران، خیابان مرکزی، ساختمان مرکزی، پلاک 7',
                'required' => array( 'show_faddr', '=', true ),
            ),
            array(
                'id'       => 'show_ftel',
                'type'     => 'switch',
                'title' => 'نمایش شماره',
                'subtitle' => 'نمایش شماره در فوتر سایت',
                'default'  => false,
                'required' => array( 'show_addr', '=', true ),
            ),
            array(
                'id'       => 'show_fmail',
                'type'     => 'switch',
                'title' => 'نمایش ایمیل',
                'subtitle' => 'نمایش ایمیل در فوتر سایت',
                'default'  => false,
                'required' => array( 'show_addr', '=', true ),
            ),
            array(
                'id'       => 'show_apps',
                'type'     => 'switch',
                'title' => 'دکمه های اپلیکیشن',
                'subtitle' => 'نمایش دکمه های اپلیکیشن در فوتر سایت',
                'default'  => false,
                'required' => array( 'show_addr', '=', true ),
            ),
            array(
                'id'       => 'and_link',
                'type'     => 'text',
                'title' => 'لینک آندروید',
                'default'  => '',
                'required' => array( 'show_apps', '=', true ),
            ),
            array(
                'id'       => 'ios_link',
                'type'     => 'text',
                'title' => 'لینک ios',
                'default'  => '',
                'required' => array( 'show_apps', '=', true ),
            ),
            array(
                'id'=>'footer_text',
                'type' => 'textarea',
                'title' => 'متن کپی رایت',
                'subtitle' => 'متن موجود در قسمت فوتر سایت را تغییر دهید.',
                'default' => 'تمامی حقوق برای سایت ما محفوظ است.',
                'allowed_html' => array(
                    'a' => array(
                        'href' => array(),
                        'title' => array()
                    ),
                    'br' => array(),
                    'em' => array(),
                    'strong' => array()
                ),
            ),
            array(
                'id'       => 'tag_number',
                'type'     => 'text',
                'title' => 'تعداد برچسب های ابزارک',
                'subtitle' => 'تعداد برچسب هایی که در ابزارک ابر برچسب نمایش داده می شوند.',
                'default'  => 32,
            ),
            array(
                'id'       => 'show_abar',
                'type'     => 'switch',
                'title' => 'عدم نمایش نوار مدیریت',
                'subtitle' => 'عدم نمایش نوار مدیریت در هنگام مشاهده سایت',
                'default'  => true,
            ),
            array(
                'id'       => 'show_abar_admin',
                'type'     => 'switch',
                'title' => 'نمایش فقط برای مدیر',
                'subtitle' => 'نمایش نوار مدیریت فقط برای مدیر سایت',
                'default'  => true,
                'required' => array( 'show_abar', '=', true ),
            ),
            array(
                'id'       => 'show_page_loading',
                'type'     => 'switch',
                'title' => 'نمایش بارگذاری',
                'subtitle' => 'نمایش حالت بارگذاری هنگام لود صفحات',
                'default'  => true,
            ),
            array( 
                'id'       => 'load_img',
                'type'     => 'select_image',
                'title'    => 'تصویر بارگذاری',
                'subtitle' => 'انتخاب تصویر بارگذاری',
                'options'  => Array(
                    Array (
                         'alt'  => 'تصویر 1',
                         'img'  => ReduxFramework::$_url .'assets/img/loading/loader0.gif',
                    ),
                    Array (
                         'alt'  => 'تصویر 2',
                         'img'  => ReduxFramework::$_url .'assets/img/loading/loader1.gif',
                    ),
                    Array (
                         'alt'  => 'تصویر 3',
                         'img'  => ReduxFramework::$_url .'assets/img/loading/loader2.gif',
                    ),
                    Array (
                         'alt'  => 'تصویر 4',
                         'img'  => ReduxFramework::$_url .'assets/img/loading/loader3.gif',
                    ),
                    Array (
                         'alt'  => 'تصویر 5',
                         'img'  => ReduxFramework::$_url .'assets/img/loading/loader4.gif',
                    ),
                    Array (
                         'alt'  => 'تصویر 6',
                         'img'  => ReduxFramework::$_url .'assets/img/loading/loader5.gif',
                    ),
                    Array (
                         'alt'  => 'تصویر 7',
                         'img'  => ReduxFramework::$_url .'assets/img/loading/loader6.gif',
                    ),
                    Array (
                         'alt'  => 'تصویر 8',
                         'img'  => ReduxFramework::$_url .'assets/img/loading/loader7.gif',
                    ),
                    Array (
                         'alt'  => 'تصویر 9',
                         'img'  => ReduxFramework::$_url .'assets/img/loading/loader8.gif',
                    ),
                    Array (
                         'alt'  => 'تصویر 10',
                         'img'  => ReduxFramework::$_url .'assets/img/loading/loader9.gif',
                    ),
                    Array (
                         'alt'  => 'تصویر 11',
                         'img'  => ReduxFramework::$_url .'assets/img/loading/loader10.gif',
                    )
                    
                ),
                'required' => array( 'show_page_loading', '=', true ),
                'default'  => ReduxFramework::$_url .'assets/img/loading/loader0.gif'
            ),
            array(
                'id'       => 'footer_nav',
                'type'     => 'switch',
                'title' => 'نمایش منوی فوتر',
                'subtitle' => 'نمایش منو به جای بخش شبکه های اجتماعی در پایین سایت',
                'default'  => false,
            ),
        )
    ) );
    Redux::setSection( $opt_name, array(
        'title'      => 'تغییر عبارت ها',
        'icon'       => 'el el-text-width',
        'id'         => 'ch-texts',
        'desc'       => 'از این بخش می توانید جهت تغییر عبارت های موجود در پوسته به عبارت دلخواه استفاده نمایید.',
        'subsection' => true,
        'fields'     => array(
            array(
               'id' => 'section-header',
               'type' => 'section',
               'title' => 'عبارت های بخش هدر',
               'indent' => true,
           ),
            array(
                'id'       => 'text_shop',
                'type'     => 'text',
                'title' => 'فروشگاه',
                'default'  => 'فروشگاه',
            ),
            array(
                'id'       => 'text_blog',
                'type'     => 'text',
                'title' => 'وبلاگ',
                'default'  => 'وبلاگ',
            ),
            array(
                'id'       => 'text_search',
                'type'     => 'text',
                'title' => 'جستجو ...',
                'default'  => 'جستجو ...',
            ),
            array(
                'id'       => 'text_date',
                'type'     => 'text',
                'title' => 'امروز:',
                'default'  => 'امروز:',
            ),
            array(
                'id'       => 'text_login',
                'type'     => 'text',
                'title' => 'ورود',
                'default'  => 'ورود',
            ),
            array(
                'id'       => 'text_register',
                'type'     => 'text',
                'title' => 'ثبت نام',
                'default'  => 'ثبت نام',
            ),
            array(
                'id'       => 'text_reg_hint',
                'type'     => 'text',
                'title' => 'جهت استفاده از تمامی امکانات سایت ثبت نام کنید',
                'default'  => 'جهت استفاده از تمامی امکانات سایت ثبت نام کنید',
            ),
            array(
                'id'     => 'section-head-end',
                'type'   => 'section',
                'indent' => false,
           ),
            array(
               'id' => 'section-umenu',
               'type' => 'section',
               'title' => 'عبارت های منوی کاربری',
               'indent' => true,
           ),
            array(
                'id'       => 'text_uac',
                'type'     => 'text',
                'title' => 'حساب کاربری',
                'default'  => 'حساب کاربری',
            ),
            array(
                'id'       => 'text_uhi',
                'type'     => 'text',
                'title' => 'تاریخچه سفارشات',
                'default'  => 'تاریخچه سفارشات',
            ),
            array(
                'id'       => 'text_udl',
                'type'     => 'text',
                'title' => 'دانلودها',
                'default'  => 'دانلودها',
            ),
            array(
                'id'       => 'text_uadd',
                'type'     => 'text',
                'title' => 'آدرس ها',
                'default'  => 'آدرس ها',
            ),
            array(
                'id'       => 'text_ueac',
                'type'     => 'text',
                'title' => 'اطلاعات حساب کاربری',
                'default'  => 'اطلاعات حساب کاربری',
            ),
            array(
                'id'       => 'text_uwa',
                'type'     => 'text',
                'title' => 'کیف پول',
                'default'  => 'کیف پول',
            ),
            array(
                'id'       => 'text_ush',
                'type'     => 'text',
                'title' => 'سبد خرید',
                'default'  => 'سبد خرید',
            ),
            array(
                'id'       => 'text_bav',
                'type'     => 'text',
                'title' => 'فروشنده شوید!',
                'default'  => 'فروشنده شوید!',
            ),
            array(
                'id'       => 'text_ucl',
                'type'     => 'text',
                'title' => 'خروج',
                'default'  => 'خروج',
            ),
            array(
                'id'     => 'section-umenu-end',
                'type'   => 'section',
                'indent' => false,
           ),
            array(
               'id' => 'section-single',
               'type' => 'section',
               'title' => 'عبارت های صفحه محصول و مطلب',
               'indent' => true,
           ),
            array(
                'id'       => 'text_share',
                'type'     => 'text',
                'title' => 'اشتراک گذاری',
                'default'  => 'اشتراک گذاری',
            ),
            array(
                'id'       => 'text_pre',
                'type'     => 'text',
                'title' => 'پیش نمایش',
                'default'  => 'پیش نمایش',
            ),
            array(
                'id'       => 'text_special',
                'type'     => 'text',
                'title' => 'ویژه',
                'default'  => 'ویژه',
            ),
            array(
                'id'       => 'text_price',
                'type'     => 'text',
                'title' => 'قیمت',
                'default'  => 'قیمت',
            ),
            array(
                'id'       => 'text_add_shop',
                'type'     => 'text',
                'title' => 'افزودن به سبد خرید',
                'default'  => 'افزودن به سبد خرید',
            ),
            array(
                'id'       => 'text_coming',
                'type'     => 'text',
                'title' => 'به زودی ...',
                'default'  => 'به زودی ...',
            ),
            array(
                'id'       => 'text_free_logged',
                'type'     => 'text',
                'title' => 'دانلود این فایل فقط برای اعضا سایت فعال می باشد',
                'default'  => 'دانلود این فایل فقط برای اعضا سایت فعال می باشد',
            ),
            array(
                'id'       => 'text_buy_this',
                'type'     => 'text',
                'title' => 'خرید این محصول',
                'default'  => 'خرید این محصول',
            ),
            array(
                'id'       => 'text_down_this',
                'type'     => 'text',
                'title' => 'دانلود رایگان',
                'default'  => 'دانلود رایگان',
            ),
            array(
                'id'       => 'text_read_more',
                'type'     => 'text',
                'title' => 'مطالعه بیشتر',
                'default'  => 'مطالعه بیشتر',
            ),
            array(
                'id'       => 'text_tags',
                'type'     => 'text',
                'title' => 'برچسبها',
                'default'  => 'برچسبها',
            ),
            array(
                'id'     => 'section-single-end',
                'type'   => 'section',
                'indent' => false,
           ),
            array(
               'id' => 'section-dlbox',
               'type' => 'section',
               'title' => 'عبارت های باکس دانلود در صفحه مطلب',
               'indent' => true,
           ),
            array(
                'id'       => 'text_dl',
                'type'     => 'text',
                'title' => 'دانلود',
                'default'  => 'دانلود',
            ),
            array(
                'id'       => 'text_size',
                'type'     => 'text',
                'title' => 'حجم فایل',
                'default'  => 'حجم فایل',
            ),
            array(
                'id'       => 'text_pass',
                'type'     => 'text',
                'title' => 'کلمه عبور',
                'default'  => 'کلمه عبور',
            ),
            array(
                'id'       => 'text_hdl',
                'type'     => 'text',
                'title' => 'راهنمای دانلود',
                'default'  => 'راهنمای دانلود',
            ),
            array(
                'id'     => 'section-dlbox-end',
                'type'   => 'section',
                'indent' => false,
           ),
            array(
               'id' => 'section-general',
               'type' => 'section',
               'title' => 'عبارت های عمومی',
               'indent' => true,
           ),
            array(
                'id'       => 'text_more',
                'type'     => 'text',
                'title' => 'همه',
                'default'  => 'همه',
            ),
            array(
                'id'       => 'text_more_text',
                'type'     => 'text',
                'title' => 'ادامه مطلب',
                'default'  => 'ادامه مطلب',
            ),
            array(
                'id'       => 'text_home',
                'type'     => 'text',
                'title' => 'خانه',
                'default'  => 'خانه',
            ),
            array(
                'id'       => 'text_not_found',
                'type'     => 'text',
                'title' => 'موردی پیدا نشد',
                'default'  => 'موردی پیدا نشد',
            ),
            array(
                'id'       => 'text_admin',
                'type'     => 'text',
                'title' => 'مدیر سایت',
                'default'  => 'مدیر سایت',
            ),
            array(
                'id'       => 'text_seller',
                'type'     => 'text',
                'title' => 'فروشنده',
                'default'  => 'فروشنده',
            ),
            array(
                'id'       => 'text_customer',
                'type'     => 'text',
                'title' => 'خریدار',
                'default'  => 'خریدار',
            ),
            array(
                'id'       => 'text_free',
                'type'     => 'text',
                'title' => 'رایگان',
                'default'  => 'رایگان',
            ),
            array(
                'id'       => 'text_coming_soon',
                'type'     => 'text',
                'title' => 'به زودی',
                'default'  => 'به زودی',
            ),
            array(
                'id'       => 'text_buy',
                'type'     => 'text',
                'title' => 'خرید',
                'default'  => 'خرید',
            ),
            array(
                'id'     => 'section-general-end',
                'type'   => 'section',
                'indent' => false,
           ), 
        )
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => 'محصولات و مطالب',
        'id'         => 'menu_product',
        'desc'       => 'موارد مربوط به صفحه محصولات و مطالب را تنظیم نمایید.',
        'icon'       => 'el el-shopping-cart',
        'fields'     => array(
            array(
                'id'       => 'single_type',
                'type'     => 'image_select',
                'title'    => 'طرح صفحه محصول',
                'subtitle' => 'طرح صفحه محصول را از حالت ساده یا تب بندی شده مشخص نمایید (در حالت EDD)',
                'options'  => array(
                    '1' => array(
                        'alt' => 'ساده',
                        'img' => ReduxFramework::$_url . 'assets/img/sd1.png'
                    ),
                    '2' => array(
                        'alt' => 'تب بندی شده',
                        'img' => ReduxFramework::$_url . 'assets/img/sd2.png'
                    )
                ),
                'default'  => '1'
            ),
            array(
                'id'       => 'square_thumb',
                'type'     => 'switch',
                'title' => 'تصویر شاخص مربعی',
                'description' => 'با تغییر این گزینه یکبار تمامی تصاویر شاخص باید توسط افزونه regenerate thumbnails دوباره تولید شوند.',
                'subtitle' => 'با فعال کردن این گزینه تصاویر شاخص محصولات به حالت مربع تغییر میکند.',
                'default'  => false,
            ),
            array(
                'id'       => 'square_widget',
                'type'     => 'switch',
                'title' => 'استایل مربع به جای دایره',
                'subtitle' => 'با فعال شدن این گزینه تصاویر شاخص ابزارک ها به حالت مربع نمایش داده می شود.',
                'default'  => true,
            ),
            array(
                'id'       => 'edd_side',
                'type'     => 'switch',
                'title' => 'سایدبار جداگانه EDD',
                'subtitle' => 'با فعال سازی این گزینه سایدبار جداگانه ای برای صفحه محصولات EDD فعال می شود.',
                'default'  => false,
            ),
            array(
                'id'       => 'site_schema',
                'type'     => 'switch',
                'title' => 'کدهای Schema',
                'subtitle' => 'افزودن کدهای Schema به بخش های محصول و مطالب',
                'default'  => true,
            ),
            array(
                'id'       => 'show_archive_desc',
                'type'     => 'switch',
                'title' => 'نمایش توضیحات دسته بندی ها',
                'subtitle' => 'نمایش توضیحات دسته بندی ها در پایین صفحه (در صورت تکمیل این بخش از ویرایش دسته بندی)',
                'default'  => true,
            ),
            array(
                'id'       => 'slide_img',
                'type'     => 'switch',
                'title' => 'نمایش LightBox تصاویر',
                'subtitle' => 'نمایش تصاویر لینک شده به تصویر به صورت بزرگتر با کلیک',
                'default'  => true,
            ),
            array(
                'id'       => 'show_author_box',
                'type'     => 'switch',
                'title' => 'نمایش بلاک نویسنده مطلب',
                'subtitle' => 'نمایش یک بلاک جهت اطلاعات نویسنده مطالب در صفحه نوشته',
                'default'  => false,
            ),
            array(
                'id'       => 'show_post_thumb',
                'type'     => 'switch',
                'title' => 'تصویر شاخص نوشته',
                'subtitle' => 'نمایش تصویر شاخص نوشته در بالای محتوای نوشته',
                'default'  => false,
            ),
            array(
                'id'       => 'show_vcover_thumb',
                'type'     => 'switch',
                'title' => 'نمایش تصویر شاخص مطالب و محصولات به عنوان کاور ویدیوها',
                'default'  => true,
            ),
            array(
                'id'       => 'show_author_user',
                'type'     => 'switch',
                'title' => 'نمایش نام کاربری نویسنده',
                'subtitle' => 'نمایش نام کاربری نویسنده زیر نام نمایشی',
                'default'  => false,
            ),
            array(
                'id'       => 'show_excerpt',
                'type'     => 'switch',
                'title' => 'نمایش خلاصه مطلب',
                'subtitle' => 'نمایش خلاصه مطلب در زیر عنوان نوشته ها در صفحه اصلی و صفحات آرشیو',
                'default'  => false,
            ),
            array(
                'id'       => 'show_related_p',
                'type'     => 'switch',
                'title' => 'محصولات مشابه',
                'subtitle' => 'نمایش بخش محصولات مشابه در صفحه محصول',
                'default'  => true,
            ),
            array(
                'id'       => 'related_p_title',
                'type'     => 'text',
                'title' => 'عنوان بلاک',
                'default'  => 'محصولات مشابه',   
                'required' => array( 'show_related_p', '=', true ),
            ),
            array(
                'id'       => 'related_p_count',
                'type'     => 'text',
                'title' => 'تعداد محصولات',
                'default'  => 8,   
                'required' => array( 'show_related_p', '=', true ),
            ),
            array(
                'id'       => 'related_p_by',
                'type'     => 'select',
                'title' => 'نمایش محصولات مشابه بر اساس',
                'options'  => array(
                    'download_tag'  =>  'تگ محصول',
                    'download_category' =>  'دسته بندی محصول'
                ),
                'default'  => 'download_tag',
                'required' => array( 'show_related_p', '=', true ),
            ),
            array(
                'id'       => 'show_related_s',
                'type'     => 'switch',
                'title' => 'مطالب مشابه',
                'subtitle' => 'نمایش بخش مطالب مشابه در صفحه مطالب',
                'default'  => true,
            ),
            array(
                'id'       => 'related_s_title',
                'type'     => 'text',
                'title' => 'عنوان بلاک',
                'default'  => 'مطالب مشابه',   
                'required' => array( 'show_related_s', '=', true ),
            ),
            array(
                'id'       => 'related_s_count',
                'type'     => 'text',
                'title' => 'تعداد مطالب',
                'default'  => 8,   
                'required' => array( 'show_related_s', '=', true ),
            ),
            array(
                'id'       => 'related_s_by',
                'type'     => 'select',
                'title' => 'نمایش مطالب مشابه بر اساس',
                'options'  => array(
                    'post_tag'  =>  'تگ مطلب',
                    'category' =>  'دسته بندی مطلب'
                ),
                'default'  => 'post_tag',
                'required' => array( 'show_related_s', '=', true ),
            ),
            array(
                'id'       => 'toman_currency',
                'type'     => 'switch',
                'title' => 'قیمت تومان',
                'subtitle' => 'نمایش قیمت محصولات به تومان (در حالت EDD)',
                'default'  => true,
            ),
            array(
                'id'       => 'currency_sep',
                'type'     => 'switch',
                'title' => 'جداکننده اعداد',
                'subtitle' => 'جدا کننده اعداد به صورت سه رقم، سه رقم (در حالت EDD)',
                'default'  => true,
            ),
            array(
                'id'       => 'free_price',
                'type'     => 'switch',
                'title' => 'قیمت رایگان',
                'subtitle' => 'نمایش عبارت رایگان به جای صفر در محصولات رایگان',
                'default'  => true,
            ),
            array(
                'id'       => 'free_logged',
                'type'     => 'switch',
                'title' => 'دانلود برای اعضا',
                'subtitle' => 'دانلود فایلهای با قیمت رایگان فقط برای اعضا ',
                'default'  => false,
            ),
            array(
                'id'       => 'free_logged_link',
                'type'     => 'text',
                'title' => 'لینک متن',
                'subtitle'  => 'متن نمایش داده شده به آدرس خاصی لینک شود؟ در صورت بدون لینک بودن خالی رها کنید', 
                'default'  => '',
                'required' => array( 'free_logged', '=', true ),
            ),
            array(
                'id'       => 'show_buy_fixed',
                'type'     => 'switch',
                'title' => 'دکمه خرید چسبان',
                'subtitle' => 'نمایش دکمه خرید به صورت ثابت در حالت موبایل و در صفحه محصولات',
                'default'  => true,
            ),
            array(
                'id'       => 'social_share',
                'type'     => 'switch',
                'title' => 'اشتراک گذاری',
                'subtitle' => 'قابلیت اشتراک گذاری مطالب در شبکه های اجتماعی',
                'default'  => true,
            ),
            array(
                'id'       => 'star_rating',
                'type'     => 'switch',
                'title' => 'امتیازدهی',
                'subtitle' => 'فعال سازی امتیازدهی ستاره ای',
                'default'  => true,
            ),
            array(
                'id'       => 'text_summ',
                'type'     => 'switch',
                'title' => 'نمایش متن خلاصه',
                'subtitle' => 'با انتخاب این گزینه متن توضیحات در حالت موبایل به صورت خلاصه نمایش داده میشود',
                'default'  => true,
            ),
            array(
                'id'       => 'show_msg_help',
                'type'     => 'switch',
                'title' => 'راهنمای خرید محصول',
                'subtitle' => 'نمایش بلاکی جهت نمایش متن راهنمای خرید',
                'default'  => true,
            ),
            array(
                'id'       => 'msg_title',
                'type'     => 'text',
                'title' => 'عنوان راهنما',
                'default'  => 'راهنمای خرید:',   
                'required' => array( 'show_msg_help', '=', true ),
            ),
            array(
                'id'      => 'msg_help',
                'type'    => 'editor',
                'title'   => 'متن راهنما',
                'default' => '<ul>
                <li>لینک دانلود فایل بلافاصله بعد از پرداخت وجه به نمایش در خواهد آمد.</li>
                <li>همچنین لینک دانلود به ایمیل شما ارسال خواهد شد به همین دلیل ایمیل خود را به دقت وارد نمایید.</li>
                <li>ممکن است ایمیل ارسالی به پوشه اسپم یا Bulk ایمیل شما ارسال شده باشد.</li>
                <li>در صورتی که به هر دلیلی موفق به دانلود فایل مورد نظر نشدید با ما تماس بگیرید.</li>
                </ul>',
                'args'    => array(
                    'wpautop'       => false,
                    'media_buttons' => false,
                    'textarea_rows' => 5,
                    'teeny'         => false,
                    'quicktags'     => true,
                ),
                'required' => array( 'show_msg_help', '=', true ),
            ),
            array(
                'id'       => 'show_dl_logged',
                'type'     => 'switch',
                'title'    => 'نمایش لینک های باکس دانلود به کابران وارد شده',
                'default'  => false,
            ),
            array(
                'id'       => 'dl_help_title',
                'type'     => 'text',
                'title' => 'عنوان راهنمای دانلود باکس',
                'subtitle' => 'در صورت فعال سازی باکس دانلود در مطالب این بخش به عنوان راهنمای دانلود نمایش داده می شود',
                'default'  => 'راهنمای دانلود',
            ), 
            array(
                'id'      => 'dl_help_text',
                'type'    => 'editor',
                'title'   => 'متن راهنما',
                'default' => '<ul>
                <li>جهت دانلود بهتر از نرم افزارهای مدیریت دانلود استفاده نمایید.</li>
                <li>در صورت وجود پسورد آن را به صورت مستقیم وارد نمایید و از کپی کردن خودداری کنید.</li>
                <li>در صورت مشاهده ارور در فایل های فشرده آخرین نسخه Winrar را نصب نمایید.</li>
                </ul>',
                'args'    => array(
                    'wpautop'       => false,
                    'media_buttons' => false,
                    'textarea_rows' => 5,
                    'teeny'         => false,
                    'quicktags'     => true,
                ),
            ),
            array(
                'id'       => 'dl_box_pass',
                'type'     => 'text',
                'title' => 'پسورد پیش فرض دانلود باکس',
                'subtitle' => 'برای هر مطلب می توانید در صفحه مطلب هم جداگانه تنظیم کنید',
                'default'  => 'www.example.com',
            ),
            array(
                'id'       => 'show_post_tags',
                'type'     => 'switch',
                'title' => 'تگ محصولات و مطالب',
                'subtitle' => 'نمایش تگ محصولات و مطالب',
                'default'  => true,
            ),
            array(
                'id'       => 'edd_ext',
                'type'     => 'select',
                'title' => 'پسوندهای مجاز EDD',
                'subtitle' => 'در حالت EDD',
                'desc' => 'این نوع پسوند فایل ها در حالت دانلود به زور در بخش پیکربندی EDD به صورت لینک مستقیم قابل دانلود هستند',
                'multi'    => true,
                'options'  => array("c" => "c","m" => "m","7z" => "7z","ai" => "ai","cs" => "cs","db" => "db","gz" => "gz","js" => "js","pl" => "pl","ps" => "ps","py" => "py","rm" => "rm","ra" => "ra","3dm" => "3dm","3g2" => "3g2","3gp" => "3gp","8bi" => "8bi","aif" => "aif","app" => "app","asf" => "asf","asx" => "asx","avi" => "avi","bak" => "bak","bat" => "bat","bin" => "bin","bmp" => "bmp","cab" => "cab","cer" => "cer","cfg" => "cfg","cgi" => "cgi","com" => "com","cpl" => "cpl","cpp" => "cpp","dbf" => "dbf","dbx" => "dbx","deb" => "deb","dll" => "dll","dmg" => "dmg","dmp" => "dmp","doc" => "doc","csr" => "csr","css" => "css","csv" => "csv","cur" => "cur","dat" => "dat","drv" => "drv","drw" => "drw","dtd" => "dtd","dwg" => "dwg","dxf" => "dxf","efx" => "efx","eps" => "eps","exe" => "exe","fla" => "fla","flv" => "flv","fnt" => "fnt","fon" => "fon","gam" => "gam","gho" => "gho","gpx" => "gpx","hqx" => "hqx","iff" => "iff","ini" => "ini","iso" => "iso","jar" => "jar","m3u" => "m3u","m4a" => "m4a","max" => "max","mdb" => "mdb","mid" => "mid","mim" => "mim","mov" => "mov","mp3" => "mp3","mp4" => "mp4","mpa" => "mpa","mpg" => "mpg","msg" => "msg","msi" => "msi","nes" => "nes","ori" => "ori","otf" => "otf","jsp" => "jsp","key" => "key","kml" => "kml","lnk" => "lnk","log" => "log","pct" => "pct","pdb" => "pdb","pdf" => "pdf","pif" => "pif","pkg" => "pkg","pps" => "pps","ppt" => "ppt","prf" => "prf","psd" => "psd","qxd" => "qxd","qxp" => "qxp","rar" => "rar","rels" => "rels","rom" => "rom","rpm" => "rpm","rss" => "rss","rtf" => "rtf","sav" => "sav","sdf" => "sdf","sit" => "sit","sql" => "sql","svg" => "svg","swf" => "swf","sys" => "sys","thm" => "thm","tif" => "tif","tmp" => "tmp","ttf" => "ttf","txt" => "txt","uue" => "uue","vb" => "vb","vcd" => "vcd","vcf" => "vcf","vob" => "vob","wav" => "wav","wks" => "wks","wma" => "wma","wmv" => "wmv","wpd" => "wpd","wps" => "wps","wsf" => "wsf","xll" => "xll","xls" => "xls","xml" => "xml","yuv" => "yuv","zip" => "zip","docx" => "docx","indd" => "indd","java" => "java","part" => "part","pptx" => "pptx","sitx" => "sitx","zipx" => "zipx","xlsx" => "xlsx","pages" => "pages","accdb" => "accdb","class" => "class","toast" => "toast","plugin" => "plugin","gadget" => "gadget","tar.gz" => "tar.gz","torrent" => "torrent","keychain" => "keychain","pspimage" => "pspimage")
            ),
            array(
               'id' => 'section-start',
               'type' => 'section',
               'title' => 'زمینه های محصول',
               'subtitle' => 'زمینه های محصول را مطابق نیاز خود ویرایش نمایید.',
               'indent' => true,
           ),
            array(
                'id'       => 'show_fone',
                'type'     => 'switch',
                'title' => 'نمایش فیلد اول',
                'default'  => true,
            ),
            array(
                'id'       => 'fone',
                'type'     => 'text',
                'title' => 'فیلد اول',
                'default'  => 'نوع فایل',   
                'required' => array( 'show_fone', '=', true ),
            ),
            array(
                'id'       => 'fone_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fas' ),
                'title'    => 'آیکن فیلد اول',
                'class'    => ' font-icons fas',
                'default'  => 'fa fa-file-alt',
                'options'  => $iconArray,
                'required' => array( 'show_fone', '=', true ),
            ),
            array(
                'id'       => 'show_ftwo',
                'type'     => 'switch',
                'title' => 'نمایش فیلد دوم',
                'default'  => true,
            ),
            array(
                'id'       => 'ftwo',
                'type'     => 'text',
                'title' => 'فیلد دوم',
                'default'  => 'حجم فایل',   
                'required' => array( 'show_ftwo', '=', true ),
            ),
            array(
                'id'       => 'ftwo_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fas' ),
                'title'    => 'آیکن فیلد دوم',
                'class'    => ' font-icons fas',
                'default'  => 'fa fa-save',
                'options'  => $iconArray,
                'required' => array( 'show_ftwo', '=', true ),
            ),
            array(
                'id'       => 'show_fthree',
                'type'     => 'switch',
                'title' => 'نمایش فیلد سوم',
                'default'  => true,
            ),
            array(
                'id'       => 'edit_fthree',
                'type'     => 'switch',
                'title' => 'ویرایش فیلد سوم',
                'subtitle' => 'نمایش مقدار مورد نظر به جای نمایش نویسنده مطلب',
                'default'  => false,
                'required' => array( 'show_fthree', '=', true ),
            ),
            array(
                'id'       => 'fthree',
                'type'     => 'text',
                'title' => 'فیلد سوم',
                'default'  => 'نویسنده',
                'required' => array( 'edit_fthree', '=', true ),
            ),
            array(
                'id'       => 'fthree_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fas' ),
                'title'    => 'آیکن فیلد سوم',
                'class'    => ' font-icons fas',
                'default'  => 'fa fa-user',
                'options'  => $iconArray,
                'required' => array( 'edit_fthree', '=', true ),
            ),
            array(
                'id'       => 'show_ffour',
                'type'     => 'switch',
                'title' => 'نمایش فیلد چهارم',
                'default'  => true,
            ),
            array(
                'id'       => 'edit_ffour',
                'type'     => 'switch',
                'title' => 'ویرایش فیلد چهارم',
                'subtitle' => 'نمایش مقدار مورد نظر به جای نمایش تاریخ انتشار مطلب',
                'default'  => false,
                'required' => array( 'show_ffour', '=', true ),
            ),
            array(
                'id'       => 'ffour',
                'type'     => 'text',
                'title' => 'فیلد چهارم',
                'default'  => 'تاریخ انتشار',
                'required' => array( 'edit_ffour', '=', true ),
            ),
            array(
                'id'       => 'ffour_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fas' ),
                'title'    => 'آیکن فیلد چهارم',
                'class'    => ' font-icons fas',
                'default'  => 'fa fa-calendar',
                'options'  => $iconArray,
                'required' => array( 'edit_ffour', '=', true ),
            ),
            array(
                'id'       => 'show_ffive',
                'type'     => 'switch',
                'title' => 'نمایش فیلد پنجم',
                'default'  => true,
            ),
            array(
                'id'       => 'edit_ffive',
                'type'     => 'switch',
                'title' => 'ویرایش فیلد پنجم',
                'subtitle' => 'نمایش مقدار مورد نظر به جای نمایش دسته بندی های مطلب',
                'default'  => false,
                'required' => array( 'show_ffive', '=', true ),
            ),
            array(
                'id'       => 'ffive',
                'type'     => 'text',
                'title' => 'فیلد پنجم',
                'default'  => 'دسته بندی',
                'required' => array( 'edit_ffive', '=', true ),
            ),
            array(
                'id'       => 'ffive_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fas' ),
                'title'    => 'آیکن فیلد پنجم',
                'class'    => ' font-icons fas',
                'default'  => 'fa fa-folder-open',
                'options'  => $iconArray,
                'required' => array( 'edit_ffive', '=', true ),
            ),
             array(
                'id'       => 'show_fsix',
                'type'     => 'switch',
                'title' => 'نمایش فیلد ششم',
                'default'  => true,
            ),
            array(
                'id'       => 'edit_fsix',
                'type'     => 'switch',
                'title' => 'ویرایش فیلد ششم',
                'subtitle' => 'نمایش مقدار مورد نظر به جای نمایش بازدید مطلب',
                'default'  => false,
                'required' => array( 'show_fsix', '=', true ),
            ),
            array(
                'id'       => 'show_dcount',
                'type'     => 'switch',
                'title' => 'نمایش تعداد خرید',
                'subtitle' => 'نمایش تعداد خرید به جای بازدید، جهت تغییر آیکن و عنوان ویرایش فیلد را بزنید و ذخیره کنید و سپس ویرایش را خاموش کنید',
                'default'  => false,
                'required' => array( 'show_fsix', '=', true ),
            ),
            array(
                'id'       => 'fsix',
                'type'     => 'text',
                'title' => 'فیلد ششم',
                'default'  => 'تعداد بازدید',
                'required' => array( 'edit_fsix', '=', true ),
            ),
            array(
                'id'       => 'fsix_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fas' ),
                'title'    => 'آیکن فیلد ششم',
                'class'    => ' font-icons fas',
                'default'  => 'fa fa-eye',
                'options'  => $iconArray,
                'required' => array( 'edit_fsix', '=', true ),
            ),
            array(
                'id'     => 'section-end',
                'type'   => 'section',
                'indent' => false,
           ),
           array(
               'id' => 'post-section-start',
               'type' => 'section',
               'title' => 'ویژگی های نوشته',
               'subtitle' => 'ویژگی های نوشته از قبیل میزان بازدید، تاریخ انتشار و .. را مدیریت نمایید.',
               'indent' => true,
           ),
           array(
                'id'       => 'show_post_author',
                'type'     => 'switch',
                'title' => 'نمایش نام نویسنده',
                'default'  => true,
           ),
           array(
                'id'       => 'show_post_date',
                'type'     => 'switch',
                'title' => 'نمایش تاریخ انتشار',
                'default'  => true,
           ),
           array(
                'id'       => 'show_post_cat',
                'type'     => 'switch',
                'title' => 'نمایش دسته بندی',
                'default'  => true,
           ),
           array(
                'id'       => 'show_post_view',
                'type'     => 'switch',
                'title' => 'نمایش میزان بازدید',
                'default'  => true,
           ),
           array(
                'id'     => 'post-section-end',
                'type'   => 'section',
                'indent' => false,
           ),
           array(
                'id'       => 'show_scomm',
                'type'     => 'switch',
                'title' => 'نمایش نقش نظر دهنده',
                'subtitle' => 'نمایش عبارت فروشنده و خریدار در کنار نام نظر دهنده',
                'default'  => true,
            ),
        ),
    ) );
    
    
    Redux::setSection( $opt_name, array(
        'title'      => 'تنظیمات ووکامرس',
        'id'         => 'menu_woo',
        'desc'       => 'در صورت استفاده از قالب با افزونه ووکامرس تنظیمات مربوطه را از این بخش انجام دهید.',
        'icon'       => 'el el-wordpress',
        'fields'     => array(
            array(
                'id'       => 'woo_mode',
                'type'     => 'switch',
                'title' => 'حالت ووکامرس',
                'subtitle' => 'در صورتی که از قالب با افزونه ووکامرس استفاده میکنید این گزینه را فعال کنید تا بخش های مختلف قالب با ووکامرس سازگار شود.',
                'default'  => false,
            ),
            ),
    ) );
    

    Redux::setSection( $opt_name, array(
        'title'      => 'شبکه های اجتماعی',
        'id'         => 'menu_social',
        'desc'       => 'لینک صفحات اجتماعی سایت را در فوتر وارد نمایید.',
        'icon'       => 'el el-facebook',
        'fields'     => array(
            array(
                'id'       => 'so_facebook',
                'type'     => 'switch',
                'title' => 'فیسبوک',
                'default'  => true,
            ),
            array(
                'id'       => 'so_facebook_link',
                'type'     => 'text',
                'title' => 'لینک',
                'default'  => '#',                
                'required' => array( 'so_facebook', '=', true ),
            ),
            array(
                'id'       => 'so_google',
                'type'     => 'switch',
                'title' => 'گوگل پلاس',
                'default'  => true,
            ),
            array(
                'id'       => 'so_google_link',
                'type'     => 'text',
                'title' => 'لینک',
                'default'  => '#',
                'required' => array( 'so_google', '=', true ),
            ),
            array(
                'id'       => 'so_twitter',
                'type'     => 'switch',
                'title' => 'توئیتر',
                'default'  => true,
            ),
            array(
                'id'       => 'so_twitter_link',
                'type'     => 'text',
                'title' => 'لینک',
                'default'  => '#',
                'required' => array( 'so_twitter', '=', true ),
            ),
            array(
                'id'       => 'so_twitter',
                'type'     => 'switch',
                'title' => 'توئیتر',
                'default'  => true,
            ),
            array(
                'id'       => 'so_twitter_link',
                'type'     => 'text',
                'title' => 'لینک',
                'default'  => '#',
                'required' => array( 'so_twitter', '=', true ),
            ),
            array(
                'id'       => 'so_youtube',
                'type'     => 'switch',
                'title' => 'یوتوب',
                'default'  => true,
            ),
            array(
                'id'       => 'so_youtube_link',
                'type'     => 'text',
                'title' => 'لینک',
                'default'  => '#',
                'required' => array( 'so_youtube', '=', true ),
            ),
            array(
                'id'       => 'so_dribble',
                'type'     => 'switch',
                'title' => 'دریبل',
                'default'  => true,
            ),
            array(
                'id'       => 'so_dribble_link',
                'type'     => 'text',
                'title' => 'لینک',
                'default'  => '#',
                'required' => array( 'so_dribble', '=', true ),
            ),
            array(
                'id'       => 'so_linkedin',
                'type'     => 'switch',
                'title' => 'لینکداین',
                'default'  => true,
            ),
            array(
                'id'       => 'so_linkedin_link',
                'type'     => 'text',
                'title' => 'لینک',
                'default'  => '#',
                'required' => array( 'so_linkedin', '=', true ),
            ),
            array(
                'id'       => 'so_instagram',
                'type'     => 'switch',
                'title' => 'اینستاگرام',
                'default'  => true,
            ),
            array(
                'id'       => 'so_instagram_link',
                'type'     => 'text',
                'title' => 'لینک',
                'default'  => '#',
                'required' => array( 'so_instagram', '=', true ),
            ),
            array(
                'id'       => 'so_cloob',
                'type'     => 'switch',
                'title' => 'کلوب',
                'default'  => true,
            ),
            array(
                'id'       => 'so_cloob_link',
                'type'     => 'text',
                'title' => 'لینک',
                'default'  => '#',
                'required' => array( 'so_cloob', '=', true ),
            ),
            array(
                'id'       => 'so_telegram',
                'type'     => 'switch',
                'title' => 'تلگرام',
                'default'  => true,
            ),
            array(
                'id'       => 'so_telegram_link',
                'type'     => 'text',
                'title' => 'لینک',
                'default'  => '#',
                'required' => array( 'so_telegram', '=', true ),
            ),
            array(
                'id'       => 'so_aparat',
                'type'     => 'switch',
                'title' => 'آپارات',
                'default'  => true,
            ),
            array(
                'id'       => 'so_aparat_link',
                'type'     => 'text',
                'title' => 'لینک',
                'default'  => '#',
                'required' => array( 'so_aparat', '=', true ),
            ),
            array(
                'id'       => 'so_gap',
                'type'     => 'switch',
                'title' => 'گپ',
                'default'  => false,
            ),
            array(
                'id'       => 'so_gap_link',
                'type'     => 'text',
                'title' => 'لینک',
                'default'  => '#',
                'required' => array( 'so_gap', '=', true ),
            ),
            array(
                'id'       => 'so_eitaa',
                'type'     => 'switch',
                'title' => 'ایتا',
                'default'  => false,
            ),
            array(
                'id'       => 'so_eitaa_link',
                'type'     => 'text',
                'title' => 'لینک',
                'default'  => '#',
                'required' => array( 'so_eitaa', '=', true ),
            ),
            array(
                'id'       => 'so_bisphone',
                'type'     => 'switch',
                'title' => 'بیسفون',
                'default'  => false,
            ),
            array(
                'id'       => 'so_bisphone_link',
                'type'     => 'text',
                'title' => 'لینک',
                'default'  => '#',
                'required' => array( 'so_bisphone', '=', true ),
            ),
            array(
                'id'       => 'so_bale',
                'type'     => 'switch',
                'title' => 'بله',
                'default'  => false,
            ),
            array(
                'id'       => 'so_bale_link',
                'type'     => 'text',
                'title' => 'لینک',
                'default'  => '#',
                'required' => array( 'so_bale', '=', true ),
            ),
            array(
                'id'       => 'so_soroush',
                'type'     => 'switch',
                'title' => 'سروش',
                'default'  => false,
            ),
            array(
                'id'       => 'so_soroush_link',
                'type'     => 'text',
                'title' => 'لینک',
                'default'  => '#',
                'required' => array( 'so_soroush', '=', true ),
            ),
            array(
                'id'       => 'so_igap',
                'type'     => 'switch',
                'title' => 'آی گپ',
                'default'  => false,
            ),
            array(
                'id'       => 'so_igap_link',
                'type'     => 'text',
                'title' => 'لینک',
                'default'  => '#',
                'required' => array( 'so_igap', '=', true ),
            ),
            array(
                'id'       => 'so_pinterest',
                'type'     => 'switch',
                'title' => 'پینترست',
                'default'  => false,
            ),
            array(
                'id'       => 'so_pinterest_link',
                'type'     => 'text',
                'title' => 'لینک',
                'default'  => '#',
                'required' => array( 'so_pinterest', '=', true ),
            ),
        ),
    ) );
    Redux::setSection( $opt_name, array(
        'title'      => 'سایر گزینه ها',
        'id'         => 'menu_example',
        'desc'       => 'تنظیمات سایر گزینه ها',
        'icon'       => 'el el-css',
        'fields'     => array(
            array(
                'id'       => 'custom_css',
                'type'     => 'ace_editor',
                'title'    => 'شیوه نامه سفارشی',
                'subtitle' => 'کدهای شیوه نامه سفارشی خود را به سرعت به قالب اضافه نمایید.',
                'mode'     => 'css',
                'theme'    => 'chrome'
            ),
            array(
                'id'       => 'header_codes',
                'type'     => 'ace_editor',
                'title'    => 'اسکریپت هدر',
                'subtitle' => 'کدهایی که نیاز دارید به بخش هدر قالب اضافه نمایید (مانند متاتگ ها) در اینجا وارد نمایید.',
                'mode'     => 'javascript',
                'theme'    => 'chrome'
            ),
            array(
                'id'       => 'footer_codes',
                'type'     => 'ace_editor',
                'title'    => 'اسکریپت فوتر',
                'subtitle' => 'کدهایی که نیاز دارید به فوتر قالب اضافه نمایید (مانند گوگل آنالیز) در اینجا وارد نمایید.',
                'mode'     => 'javascript',
                'theme'    => 'chrome'
            ),
        ),
    ) );
    /*
     * <--- END SECTIONS
     */


    /*
     *
     * YOU MUST PREFIX THE FUNCTIONS BELOW AND ACTION FUNCTION CALLS OR ANY OTHER CONFIG MAY OVERRIDE YOUR CODE.
     *
     */

    /*
    *
    * --> Action hook examples
    *
    */

    // If Redux is running as a plugin, this will remove the demo notice and links
    //add_action( 'redux/loaded', 'remove_demo' );

    // Function to test the compiler hook and demo CSS output.
    // Above 10 is a priority, but 2 in necessary to include the dynamically generated CSS to be sent to the function.
    //add_filter('redux/options/' . $opt_name . '/compiler', 'compiler_action', 10, 3);

    // Change the arguments after they've been declared, but before the panel is created
    //add_filter('redux/options/' . $opt_name . '/args', 'change_arguments' );

    // Change the default value of a field after it's been set, but before it's been useds
    //add_filter('redux/options/' . $opt_name . '/defaults', 'change_defaults' );

    // Dynamically add a section. Can be also used to modify sections/fields
    //add_filter('redux/options/' . $opt_name . '/sections', 'dynamic_section');

    /**
     * This is a test function that will let you see when the compiler hook occurs.
     * It only runs if a field    set with compiler=>true is changed.
     * */
    if ( ! function_exists( 'compiler_action' ) ) {
        function compiler_action( $options, $css, $changed_values ) {
            echo '<h1>The compiler hook has run!</h1>';
            echo "<pre>";
            print_r( $changed_values ); // Values that have changed since the last save
            echo "</pre>";
            //print_r($options); //Option values
            //print_r($css); // Compiler selector CSS values  compiler => array( CSS SELECTORS )
        }
    }

    /**
     * Custom function for the callback validation referenced above
     * */
    if ( ! function_exists( 'redux_validate_callback_function' ) ) {
        function redux_validate_callback_function( $field, $value, $existing_value ) {
            $error   = false;
            $warning = false;

            //do your validation
            if ( $value == 1 ) {
                $error = true;
                $value = $existing_value;
            } elseif ( $value == 2 ) {
                $warning = true;
                $value   = $existing_value;
            }

            $return['value'] = $value;

            if ( $error == true ) {
                $field['msg']    = 'your custom error message';
                $return['error'] = $field;
            }

            if ( $warning == true ) {
                $field['msg']      = 'your custom warning message';
                $return['warning'] = $field;
            }

            return $return;
        }
    }

    /**
     * Custom function for the callback referenced above
     */
    if ( ! function_exists( 'redux_my_custom_field' ) ) {
        function redux_my_custom_field( $field, $value ) {
            print_r( $field );
            echo '<br/>';
            print_r( $value );
        }
    }

    /**
     * Custom function for filtering the sections array. Good for child themes to override or add to the sections.
     * Simply include this function in the child themes functions.php file.
     * NOTE: the defined constants for URLs, and directories will NOT be available at this point in a child theme,
     * so you must use get_template_directory_uri() if you want to use any of the built in icons
     * */
    if ( ! function_exists( 'dynamic_section' ) ) {
        function dynamic_section( $sections ) {
            //$sections = array();
            $sections[] = array(
                'title'  => __( 'Section via hook', 'redux-framework-demo' ),
                'desc'   => __( '<p class="description">This is a section created by adding a filter to the sections array. Can be used by child themes to add/remove sections from the options.</p>', 'redux-framework-demo' ),
                'icon'   => 'el el-paper-clip',
                // Leave this as a blank section, no options just some intro text set above.
                'fields' => array()
            );

            return $sections;
        }
    }

    /**
     * Filter hook for filtering the args. Good for child themes to override or add to the args array. Can also be used in other functions.
     * */
    if ( ! function_exists( 'change_arguments' ) ) {
        function change_arguments( $args ) {
            //$args['dev_mode'] = true;

            return $args;
        }
    }

    /**
     * Filter hook for filtering the default value of any given field. Very useful in development mode.
     * */
    if ( ! function_exists( 'change_defaults' ) ) {
        function change_defaults( $defaults ) {
            $defaults['str_replace'] = 'Testing filter hook!';

            return $defaults;
        }
    }

    /**
     * Removes the demo link and the notice of integrated demo from the redux-framework plugin
     */
    if ( ! function_exists( 'remove_demo' ) ) {
        function remove_demo() {
            // Used to hide the demo mode link from the plugin page. Only used when Redux is a plugin.
            if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
                remove_filter( 'plugin_row_meta', array(
                    ReduxFrameworkPlugin::instance(),
                    'plugin_metalinks'
                ), null, 2 );

                // Used to hide the activation notice informing users of the demo panel. Only used when Redux is a plugin.
                remove_action( 'admin_notices', array( ReduxFrameworkPlugin::instance(), 'admin_notices' ) );
            }
        }
    }

function removeDemoModeLink() { // Be sure to rename this function to something more unique
    if ( class_exists('ReduxFrameworkPlugin') ) {
        remove_filter( 'plugin_row_meta', array( ReduxFrameworkPlugin::get_instance(), 'plugin_metalinks'), null, 2 );
    }
    if ( class_exists('ReduxFrameworkPlugin') ) {
        remove_action('admin_notices', array( ReduxFrameworkPlugin::get_instance(), 'admin_notices' ) );    
    }
}
add_action('init', 'removeDemoModeLink');