<?php
/**
 * Search results are contained within a div.searchwp-live-search-results
 * which you can style accordingly as you would any other element on your site
 *
 * Some base styles are output in wp_footer that do nothing but position the
 * results container and apply a default transition, you can disable that by
 * adding the following to your theme's functions.php:
 *
 * add_filter( 'searchwp_live_search_base_styles', '__return_false' );
 *
 * There is a separate stylesheet that is also enqueued that applies the default
 * results theme (the visual styles) but you can disable that too by adding
 * the following to your theme's functions.php:
 *
 * wp_dequeue_style( 'searchwp-live-search' );
 *
 * You can use ~/searchwp-live-search/assets/styles/style.css as a guide to customize
 */
?>

<?php
global $az_data;
if ( have_posts() ) : ?>
	<?php while ( have_posts() ) : the_post(); ?>
		<?php $post_type = get_post_type(); ?>
		<div class="searchwp-live-search-result" role="option" id="" aria-selected="false">
			<p><a href="<?php echo esc_url( get_permalink() ); ?>">
                <span class="re-img">
                    <?php if ( has_post_thumbnail()) :  ?>
      <?php the_post_thumbnail( 'widget-img' ); ?>
      <?php else: ?>
      <img src="<?php echo esc_url( get_template_directory_uri() ); ?>/images/mtumb.png" class="post-tumb"/>
      <?php endif; ?>
                </span>
                <span class="re-desc">
                <span class="re-title"><?php the_title(); ?></span>
                <span class="re-subtitle">
                     <?php
                    if($post_type == 'page'){
                        echo 'در صفحات ';
                    }
                    elseif($post_type == 'post') {
                        echo 'در ' . $az_data['text_blog'] . ' - ';
                        $i=0;
                        foreach((wp_get_object_terms(get_the_id(),'category')) as $category) { if($i!=0) break; echo 'دسته بندی: ' . $category->name . ' '; $i++; }
                    }
                    elseif($post_type == 'download') {
                        echo 'در ' . $az_data['text_shop'] . ' - ';
                        $i=0;
                        
                        foreach((wp_get_object_terms(get_the_id(),'download_category')) as $category) { if($i!=0) break; echo 'دسته بندی: ' . $category->name . ' '; $i++; }
                    }
                    elseif($post_type == 'product') {
                        echo 'در ' . $az_data['text_shop'] . ' - ';
                        $i=0;
                        foreach((wp_get_object_terms(get_the_id(),'product_cat')) as $category) { if($i!=0) break; echo 'دسته بندی: ' . $category->name . ' '; $i++; }
                    }
                    ?>
                </span>
                </span>
			</a></p>
		</div>
	<?php endwhile; ?>
<?php else : ?>
	<p class="searchwp-live-search-no-results" role="option">
		موردی پیدا نشد
	</p>
<?php endif; ?>
