<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: Hosseinkhani.ir
*/
   // Exit if accessed directly
   if (!defined('ABSPATH')) {
    exit;
}

// Creating the widget
   class wauthor_widget extends WP_Widget {
   
   function __construct() {
   
   parent::__construct(
   
   // Base ID of your widget
   
   'wauthor_widget',
   
    
   
   // Widget name will appear in UI
   
   __('اطلاعات فروشنده (آذین فایل)', 'wauthor'),
   
    
   
   // Widget description
   
   array( 'description' => __( 'نمایش پروفایل فروشنده در صفحه محصولات', 'wauthor' ), )
   
   );
   
   }
   
    
   
   // Creating widget front-end
   
   // This is where the action happens
   
   public function widget( $args, $instance ) {
    
   if (is_singular('download')) {
   
   $title = apply_filters( 'widget_title', $instance['title'] );
   
   // before and after widget arguments are defined by themes
   
   echo $args['before_widget'];
   
   if ( ! empty( $title ) )
   
   echo $args['before_title'] . $title . $args['after_title'];
   
   // This is where you run the code and display the output
      $author = get_post_field( 'post_author', get_the_ID() );
   ?>
   <div class="wauthor col-12">
      <div class="uavatar">
       <?php echo get_avatar($author , 128, '' , get_the_author_meta('display_name',$author )); ?>
       </div>
       <div class="col-12">
        <div class="row author-name">
           <?php echo  get_the_author_meta('display_name',$author ); ?>
       </div>
       <div class="col-12 aut-btn">
            <a href="<?php echo get_author_posts_url( $author ); ?>"><i class="fas fa-user"></i> مشاهده پروفایل</a></div>
        <div class="row author-det">
           <div class="col-12 author-attr">
               <i class="fas fa-shopping-bag"></i> <?php echo count_user_posts( $author , "download"  ) ?> محصول
           </div>
           <div class="col-12 author-attr">
               <i class="fas fa-file-alt"></i> <?php echo count_user_posts( $author , "post"  ) ?> نوشته
           </div>
           <div class="col-12 author-attr">
               <i class="fas fa-user-plus"></i> عضویت <?php echo parsidate('y/m/d', get_the_author_meta('user_registered',$author ),$lang='per'); ?>
           </div>
       </div>
        </div>
        </div>
   <?php
   
   echo $args['after_widget'];
   }
   }
   
    
   
   // Widget Backend
   
   public function form( $instance ) {
   
   if ( isset( $instance[ 'title' ] ) ) {
   
   $title = $instance[ 'title' ];
   
   }
   
   else {
   
   $title = __( 'فروشنده', 'wauthor' );
   
   }
   
   // Widget admin form
   
   ?>
<p>
   <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:' ); ?></label>
   <input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
</p>
<?php
   }
   
    
   
   // Updating widget replacing old instances with new
   
   public function update( $new_instance, $old_instance ) {
   
   $instance = array();
   
   $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
   
   return $instance;
   
   }
   
   } // Class wpb_widget ends here
   
    
   
   // Register and load the widget
   
   function wauthor_load_widget() {
   
   register_widget( 'wauthor_widget' );
   
   }
   
   add_action( 'widgets_init', 'wauthor_load_widget' );   