<?php
namespace Elementor;

class Ads_Image extends Widget_Base
{
    public function get_name()
    {
        return 'ads-image';
    }
    
    public function get_title()
    {
        return 'بنر تبلیغاتی';
    }
    
    public function get_icon()
    {
        return 'fas fa-image';
    }
    
    public function get_categories()
    {
        return [ 'azin-file' ];
    }
    
    protected function _register_controls()
    {
        $this->start_controls_section(
            'section_title',
            [
                'label' => 'بنر تبلیغاتی',
            ]
        );
        
        $this->add_control(
            'img_title',
            [
                'label' => 'عنوان تصویر',
                'label_block' => true,
                'type' => Controls_Manager::TEXT,
                'placeholder' => 'عنوان تصویر را وارد نمایید',
                'default' => '#',
            ]
        );
        
        $this->add_control(
            'img_link',
            [
                'label' => 'پیوند تصویر',
                'type' => Controls_Manager::URL,
                'placeholder' => 'https://your-link.com',
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );
        
        $this->add_control(
            'image',
            [
                'label' => 'انتخاب تصویر',
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );
        
        $this->end_controls_section();
    }
    
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $target = $settings['img_link']['is_external'] ? ' target="_blank"' : '';
        $nofollow = $settings['img_link']['nofollow'] ? ' rel="nofollow"' : ''; ?>
        <div class="ads-con hovers">
            <a href="<?php echo $settings['img_link']['url']; ?>" title="<?php echo $settings['img_title']; ?>"<?php if (!empty($target)) { echo $target;} ?> <?php if (!empty($nofollow)) { echo $nofollow; } ?>>
				<figure>
					<img src="<?php echo $settings['image']['url']; ?>" alt="<?php echo $settings['img_title']; ?>" class="ads-banner">
				</figure>
            </a>
		</div>
         <?php
    }
}