<?php
namespace Elementor;

class Azin_Blog_Posts_Block extends Widget_Base {
	
	public function get_name() {
		return 'azin-blog-posts-block';
	}
	
	public function get_title() {
		return 'بلاک پست های وبلاگ';
	}
	
	public function get_icon() {
		return 'fas fa-file-alt';
	}
	
	public function get_categories() {
		return [ 'azin-file' ];
	}
	
	protected function _register_controls() {
		require get_template_directory() . '/includes/widgets/fa.php';
		$post_cat = array();
		$categories = get_terms("category");
		if ( !empty( $categories ) && !is_wp_error( $categories ) ){
			foreach ( $categories as $category ) {
				$post_cat[ $category->term_id ] = $category->name;
			}
		}

		$this->start_controls_section(
			'section_title',
			[
				'label' => 'بلاک پست های وبلاگ',
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => 'عنوان',
				'label_block' => true,
				'default' => 'مطالب',
				'type' => Controls_Manager::TEXT,
				'placeholder' => 'عنوان را وارد نمایید',
			]
		);

		$this->add_control(
			'post_sort',
			[
				'label' => 'مرتب سازی مطالب',
				'type' => Controls_Manager::SELECT,
				'default' => 'latest',
				'options' => [
					'latest'  => 'آخرین مطالب',
					'random' => 'مطالب تصادفی',
					'viewed' => 'مطالب پربازدید',
				],
			]
		);

		$this->add_control(
			'post_cat',
			[
				'label' => 'دسته بندی مطالب',
				'type' => Controls_Manager::SELECT2,
				'options' => $post_cat,
			]
		);

		$this->add_control(
			'post_icon',
			[
				'label' => 'آیکن',
				'type' => Controls_Manager::SELECT2,
				'options' => $icons_font_awesome,
				'default' => 'file-alt'
			]
		);

		$this->add_control(
			'auto_play',
			[
				'label' => 'حرکت خودکار',
				'type' => Controls_Manager::SWITCHER,
				'label_on' => 'روشن',
				'label_off' => 'خاموش',
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'post_loop',
			[
				'label' => 'تکرار مطالب',
				'type' => Controls_Manager::SWITCHER,
				'label_on' => 'روشن',
				'label_off' => 'خاموش',
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'ptotalcount',
			[
				'label' => 'تعداد مطالب',
				'type' => Controls_Manager::NUMBER,
				'min' => 8,
				'max' => 20,
				'step' => 1,
				'default' => 8,
			]
		);

		$this->add_control(
			'pcount',
			[
				'label' => 'تعداد ستون مطالب',
				'type' => Controls_Manager::NUMBER,
				'min' => 3,
				'max' => 5,
				'step' => 1,
				'default' => 4,
			]
		);

		$this->end_controls_section();
	}
	
	protected function render() {
		global $az_data;
		$settings = $this->get_settings_for_display();
		$post_cat = $settings['post_cat']; ?>
        <div class="rcon">
			<div class="post-block m-product">
				<div class="post-title">
					<h3>
						<?php if($post_cat != '') { ?><a href="<?php echo get_category_link($post_cat); ?>"><?php } ?>
							<i class="fas fa-<?php echo $settings['post_icon']; ?>"></i>
							<?php echo $settings['title']; ?>
						<?php if($post_cat != '') { ?></a><?php } ?>
					</h3>
					<?php if($post_cat != '') { ?>
					<a class="float-left morebtn" href="<?php echo get_category_link($post_cat); ?>">
					<?php echo $az_data['text_more']; ?>
					<i class="fas fa-chevron-left"></i></a>
					<?php } ?>
				</div>
			<?php
			$post_sort = $settings['post_sort'];
				switch ($post_sort) {
					case 'latest':
						$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'order' => 'DESC'  );
						break;
					case 'viewed':
						$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'meta_key' => 'post_views_count',
						'orderby' => 'meta_value_num',
						'order' => 'DESC'  );
						break;
					case 'random':
						$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'orderby'        => 'rand'  );
						break;
					default:
					$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'order' => 'DESC'  );
					}
					if ( $post_cat ) {
						$args['tax_query'] = array(
							array(
							'taxonomy' => 'category',
							'field' => 'term_id',
							'terms' => $post_cat
							)
						);
					}
				$postsquery = new \WP_Query( $args );
			?>
			
			<?php if ( $postsquery->have_posts() ) { ?>
				<div class="owl-carousel" <?php if ('yes' === $settings['post_loop']) {
						echo 'data-itemloop="true"';
					} else {
						echo 'data-itemloop="false"';
					} ?> <?php if ('yes' === $settings['auto_play']) {
						echo 'data-itemplay="true"';
					} else {
						echo 'data-itemplay="false"';
					} ?> data-itemscount="<?php echo $settings['pcount']; ?>">
			<?php while ( $postsquery->have_posts() ) : $postsquery->the_post(); ?>
					<div class="item">
						<div class="rcol">
							<div class="r-box r-box-view">
								<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
								<div class="figure">
									<div class="fig">
									<span class="fig-price"><span><?php echo $az_data['text_more_text']; ?></span></span> 
									<?php p_mimg() ?>
									</div>
									<div class="figcaption">
										<?php the_title(); ?>
									</div>
								</div>
								</a>
							</div>
						</div>
					</div>
			<?php endwhile; ?>
				</div>
			<?php 
			} else {		
			echo 'لطفا ابتدا نوشته ای را اضافه نمایید.';}
			wp_reset_postdata();
			?>
			</div>
   		</div>
        <?php

	}

}