<?php
namespace Elementor;

class Azin_Blog_Posts extends Widget_Base {
	
	public function get_name() {
		return 'azin-blog-posts';
	}
	
	public function get_title() {
		return 'پست های وبلاگ';
	}
	
	public function get_icon() {
		return 'fas fa-file-alt';
	}
	
	public function get_categories() {
		return [ 'azin-file' ];
	}
	
	protected function _register_controls() {
		require get_template_directory() . '/includes/widgets/fa.php';
		$post_cat = array();
		$categories = get_terms("category");
		if ( !empty( $categories ) && !is_wp_error( $categories ) ){
			foreach ( $categories as $category ) {
				$post_cat[ $category->term_id ] = $category->name;
			}
		}

		$this->start_controls_section(
			'section_title',
			[
				'label' => 'پست های وبلاگ',
			]
		);

		$this->add_control(
			'ptotalcount',
			[
				'label' => 'تعداد مطالب',
				'type' => Controls_Manager::NUMBER,
				'min' => 8,
				'max' => 24,
				'step' => 1,
				'default' => 8,
			]
		);

		$this->add_control(
			'pcount',
			[
				'label' => 'تعداد ستون مطالب',
				'type' => Controls_Manager::NUMBER,
				'min' => 3,
				'max' => 4,
				'step' => 1,
				'default' => 4,
			]
		);

		$this->end_controls_section();
	}
	
	protected function render() {
		global $az_data;
		$settings = $this->get_settings_for_display();
		$col = ($settings['pcount'] == 3 ? 'col-md-4 col-6' : 'col-md-3 col-6');

		$product_args = array(
                        'posts_per_page' => $settings['ptotalcount'],
                        'post_type' => 'post',
                        'post_status' => 'publish',
                        'order' => 'DESC'  );

  		$products = new \WP_Query($product_args); ?>
		<div class="row">
		<?php if ($products->have_posts()) : ?>
			<?php while ($products->have_posts()) : $products->the_post(); ?>
			<div role="main" class="<?php echo $col; ?> pcon" id="post-<?php the_ID(); ?>">
				<a href="<?php the_permalink() ?>" class="vi-img-res-box">
				<div class="product">
					<div class="post-img">
						<div class="post-icon">
						<span class="price"><i class="fas fa-file-alt"></i><?php echo $az_data['text_more_text']; ?></span>
						</div>
						<?php p_img() ?>
						<div class="prod-price price pt-price">
						<i class="fas fa-calendar price-icon"></i>
						<?php echo get_the_date('j F Y'); ?>
						</div>
					</div>
					<div class="col-12">
						<div class="col-10 prod-name pt-name">
						<h2 title="<?php the_title(); ?>"><?php the_title(); ?></h2>
						</div>
					</div>
					<?php if ($az_data['show_excerpt']) { ?>
					<div class="col-12 pdesc">
						<?php the_excerpt(); ?>
					</div>
					<?php } ?>
				</div>
				</a>
			</div>
			<?php endwhile; ?>
			<div class="col-12">
				<?php $all_link = get_home_url(). '/?post_type=post&s='; ?>
				<a href="<?php echo $all_link; ?>" class="btn btn-outline-success btn-lg btn-view-all" title="مشاهده تمامی مطالب">
					<i class="fas fa-file-alt" aria-hidden="true"></i>
					مشاهده تمامی مطالب
					<i class="fas fa-angle-left" aria-hidden="true"></i>
				</a>
			</div>
		<?php else : ?>
			<div class="alert alert-warning alert-dismissible anote"><strong><span class="fas fa-bell" aria-hidden="true">
				</span> <?php echo $az_data['text_not_found']; ?></strong>
			</div>
		<?php endif;
		wp_reset_postdata(); ?>
		</div>
        <?php
	}
}