<?php
namespace Elementor;

class Our_Service_Box extends Widget_Base {
	
	public function get_name() {
		return 'our-service-box';
	}
	
	public function get_title() {
		return 'باکس خدمات';
	}
	
	public function get_icon() {
		return 'fas fa-th-large';
	}
	
	public function get_categories() {
		return [ 'azin-file' ];
	}
	
	protected function _register_controls() {
		require get_template_directory() . '/includes/widgets/fa.php';
		$this->start_controls_section(
			'section_title',
			[
				'label' => 'باکس خدمات',
			]
		);
		
		$this->add_control(
			'title_one',
			[
				'label' => 'عنوان اول',
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => 'عنوان اول را وارد نمایید',
                'default' => 'پرداخت امن',
			]
		);

		$this->add_control(
			'subtitle_one',
			[
				'label' => 'زیر عنوان اول',
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => 'زیر عنوان اول را وارد نمایید',
                'default' => 'توسط کارت های عضو شتاب',
			]
        );
		
		$this->add_control(
			'icon_one',
			[
				'label' => 'آیکن اول',
				'type' => Controls_Manager::SELECT2,
				'options' => $icons_font_awesome,
				'default' => 'credit-card'
			]
		);
        
        $this->add_control(
			'title_two',
			[
				'label' => 'عنوان دوم',
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => 'عنوان دوم را وارد نمایید',
                'default' => 'بازگشت وجه',
			]
		);

		$this->add_control(
			'subtitle_two',
			[
				'label' => 'زیر عنوان دوم',
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => 'زیر عنوان دوم را وارد نمایید',
                'default' => 'ضمانت بازگشت وجه تا 7 روز',
			]
        );
		
		$this->add_control(
			'icon_two',
			[
				'label' => 'آیکن دوم',
				'type' => Controls_Manager::SELECT2,
				'options' => $icons_font_awesome,
				'default' => 'calendar-check'
			]
		);
        
        $this->add_control(
			'title_three',
			[
				'label' => 'عنوان سوم',
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => 'عنوان سوم را وارد نمایید',
                'default' => 'تضمین کیفیت',
			]
		);

		$this->add_control(
			'subtitle_three',
			[
				'label' => 'زیر عنوان سوم',
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => 'زیر عنوان سوم را وارد نمایید',
                'default' => 'ضمانت تضمین کیفیت',
			]
        );
        
		$this->add_control(
			'icon_three',
			[
				'label' => 'آیکن سوم',
				'type' => Controls_Manager::SELECT2,
				'options' => $icons_font_awesome,
				'default' => 'certificate'
			]
		);
        
        $this->add_control(
			'title_four',
			[
				'label' => 'عنوان چهارم',
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => 'عنوان چهارم را وارد نمایید',
                'default' => 'پشتیبانی',
			]
		);

		$this->add_control(
			'subtitle_four',
			[
				'label' => 'زیر عنوان چهارم',
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => 'زیر عنوان چهارم را وارد نمایید',
                'default' => '24 ساعته 7 روز هفته',
			]
        );
		
		$this->add_control(
			'icon_four',
			[
				'label' => 'آیکن چهارم',
				'type' => Controls_Manager::SELECT2,
				'options' => $icons_font_awesome,
				'default' => 'question-circle'
			]
		);

		$this->add_control(
			'title_five',
			[
				'label' => 'عنوان پنجم (آین آیکن فقط در حالت تمام صفحه و حالت دسکتاپ نمایش داده می شود))',
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => 'عنوان پنجم را وارد نمایید',
                'default' => 'دانلود آسان',
			]
		);

		$this->add_control(
			'subtitle_five',
			[
				'label' => 'زیر عنوان پنجم',
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => 'زیر عنوان پنجم را وارد نمایید',
                'default' => 'بعد از پرداخت وجه',
			]
        );
		
		$this->add_control(
			'icon_five',
			[
				'label' => 'آیکن پنجم',
				'type' => Controls_Manager::SELECT2,
				'options' => $icons_font_awesome,
				'default' => 'download'
			]
		);
        
		$this->end_controls_section();
	}
	
	protected function render() {

        $settings = $this->get_settings_for_display();
        
		?>
		<!-- Services -->
            <div class="row ser-row">
				<div class="col ser-col">
					<div class="ser-con">
						<div class="col-md-3 col-12 ser-icon sone">
							<i class="fas fa-<?php echo $settings['icon_one']; ?>"></i>
						</div>
						<div class="col-md-9 col-12 ser-det">
							<span class="ser-title"><?php echo $settings['title_one']; ?></span>
							<span class="ser-desc hidden-xs"><?php echo $settings['subtitle_one']; ?></span>
						</div>
					</div>
				</div>
				<div class="col ser-col">
					<div class="ser-con">
						<div class="col-md-3 col-12 ser-icon stwo">
							<i class="fas fa-<?php echo $settings['icon_two']; ?>"></i>
						</div>
						<div class="col-md-9 col-12 ser-det">
							<span class="ser-title"><?php echo $settings['title_two']; ?></span>
							<span class="ser-desc hidden-xs"><?php echo $settings['subtitle_two']; ?></span>
						</div>
					</div>
				</div>
				<div class="col ser-col">
					<div class="ser-con">
						<div class="col-md-3 col-12 ser-icon sthree">
							<i class="fas fa-<?php echo $settings['icon_three']; ?>"></i>
						</div>
						<div class="col-md-9 col-12 ser-det">
							<span class="ser-title"><?php echo $settings['title_three']; ?></span>
							<span class="ser-desc hidden-xs"><?php echo $settings['subtitle_three']; ?></span>
						</div>
					</div>
				</div>
				<div class="col ser-col">
					<div class="ser-con">
						<div class="col-md-3 col-12 ser-icon sfour">
							<i class="fas fa-<?php echo $settings['icon_four']; ?>"></i>
						</div>
						<div class="col-md-9 col-12 ser-det">
							<span class="ser-title"><?php echo $settings['title_four']; ?></span>
							<span class="ser-desc hidden-xs"><?php echo $settings['subtitle_four']; ?></span>
						</div>
					</div>
				</div>
				<div class="col ser-col five-ser">
					<div class="ser-con">
						<div class="col-md-3 col-12 ser-icon sfive">
							<i class="fas fa-<?php echo $settings['icon_five']; ?>"></i>
						</div>
						<div class="col-md-9 col-12 ser-det">
							<span class="ser-title"><?php echo $settings['title_five']; ?></span>
							<span class="ser-desc hidden-xs"><?php echo $settings['subtitle_five']; ?></span>
						</div>
					</div>
				</div>
			</div>
        <!-- Services -->
		 <?php

	}

}