<?php
namespace Elementor;

class Slider extends Widget_Base {
	
	public function get_name() {
		return 'slider';
	}
	
	public function get_title() {
		return 'اسلایدر';
	}
	
	public function get_icon() {
		return 'fas fa-file-image';
	}
	
	public function get_categories() {
		return [ 'azin-file' ];
	}
	
	protected function _register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => 'اسلایدر',
			]
		);
		
		$slider = new Repeater();

		$slider->add_control(
			'slide_title', [
				'label' => 'عنوان اسلاید',
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$slider->add_control(
			'slide_description',
			[
						'label' => 'توضیح اسلاید',
						'type' => Controls_Manager::TEXT,
						'label_block' => true,
					]
		);


		$slider->add_control(
			'slide_link',
			[
				'label' => 'پیوند اسلاید',
				'type' => Controls_Manager::URL,
				'placeholder' => 'https://your-link.com',
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => true,
					'nofollow' => true,
				],
			]
        );
        
        $slider->add_control(
			'slide_image',
			[
				'label' => 'انتخاب تصویر',
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'slides',
			[
				'label' => 'اسلایدها',
				'type' => Controls_Manager::REPEATER,
				'fields' => $slider->get_controls(),
				'default' => [
					[
						'slide_title' => 'عنوان اسلاید',
						'slide_link' => 'https://your-link.com',
					],
				],
				'title_field' => '{{{ slide_title }}}',
			]
		);

		$this->add_control(
			'show_arrows',
			[
				'label' => 'نمایش فلش ها',
				'type' => Controls_Manager::SWITCHER,
				'label_on' => 'روشن',
				'label_off' => 'خاموش',
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'auto_play',
			[
				'label' => 'حرکت خودکار',
				'type' => Controls_Manager::SWITCHER,
				'label_on' => 'روشن',
				'label_off' => 'خاموش',
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'time',
			[
				'label' => 'سرعت حرکت',
				'type' => Controls_Manager::NUMBER,
				'min' => 1000,
				'max' => 20000,
				'step' => 1000,
				'default' => 8000,
			]
		);
        
		$this->end_controls_section();
	}
	
	protected function render() {

        $settings = $this->get_settings_for_display();
        
		?>
		<!-- start slider -->
		<div class="scon">
			<div class="slide-con">
				<?php if ( $settings['slides'] ) { ?>
				<div class="slider_container"> 
					<div class="slider owl-carousel" <?php if ( 'yes' === $settings['show_arrows'] ) { echo 'data-itemnavs="true"'; } else { echo 'data-itemnavs="false"'; } ?> <?php if ( 'yes' === $settings['auto_play'] ) { echo 'data-itemplay="true"'; } else { echo 'data-itemplay="false"'; } ?> data-itemtime="<?php echo $settings['time']; ?>">
						<?php 
						foreach (  $settings['slides'] as $item ) {
							$target = $item['slide_link']['is_external'] ? ' target="_blank"' : '';
							$nofollow = $item['slide_link']['nofollow'] ? ' rel="nofollow"' : ''; ?>
								<div class="item">
									<a href="<?php echo $item['slide_link']['url']; ?>" aria-label="<?php echo $item['slide_title']; ?>">
										<img src="<?php echo $item['slide_image']['url']; ?>" alt="<?php echo $item['slide_title']; ?>">
									</a>
									<?php if ($item['slide_title'] != '') { ?>
										<div class="caption hidden-xs"><?php echo $item['slide_title']; ?>
											<div class="desc"><?php echo $item['slide_description']; ?></div>
										</div>
									<?php } ?>
								</div>
						<?php } ?>
					</div>
				</div>
				<?php } else { 
					echo 'لطفا ابتدا اسلایدی را از بخش تنظیمات پوسته اضافه نمایید.'; } ?>
			</div>
		</div>
		<!-- end slider -->
        <?php
	}
}