<?php
namespace Elementor;

class Special_Offer extends Widget_Base {
	
	public function get_name() {
		return 'special-offer';
	}
	
	public function get_title() {
		return 'پیشنهاد شگفت انگیز';
	}
	
	public function get_icon() {
		return 'fas fa-star';
	}
	
	public function get_categories() {
		return [ 'azin-file' ];
	}
	
	protected function _register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => 'پیشنهاد شگفت انگیز',
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => 'عنوان',
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => 'عنوان را وارد نمایید',
                'default' => 'پیشنهاد شگفت انگیز',
			]
		);

        $this->add_control(
			'auto_play',
			[
				'label' => 'حرکت خودکار',
				'type' => Controls_Manager::SWITCHER,
				'label_on' => 'روشن',
				'label_off' => 'خاموش',
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'time',
			[
				'label' => 'سرعت حرکت خودکار',
				'type' => Controls_Manager::NUMBER,
				'min' => 1000,
				'max' => 20000,
				'step' => 1000,
				'default' => 8000,
			]
		);
        
		$this->end_controls_section();
	}
	
	protected function render() {
        global $az_data;
        $settings = $this->get_settings_for_display();
        
        if (az_woo()) {
            $specialpost = new \WP_Query(array(
                'posts_per_page' => 5,
                'post_type' => 'product',
                'post_status' => 'publish',
                'post__in' => array_merge( array( 0 ), wc_get_product_ids_on_sale() ),
                'meta_query' => array(
                 'relation' => 'AND',
                 array(
                     'key' => 'file_spsale',
                     'value' => 1,
                     'compare' => '='
                 )
                 ),
                'order' => 'DESC'  )); ?>
      <div class="scon">
        <div class="spslider-con woo-special">
        <?php if ($specialpost->have_posts()) { ?>
        <div class="slide-progress"></div>
         <div class="spslider owl-carousel" <?php if ('yes' === $settings['auto_play']) { echo 'data-itemplay="true"'; } else { echo 'data-itemplay="false"'; } ?> data-itemtime="<?php echo $settings['time']; ?>">
            <?php while ($specialpost->have_posts()) : $specialpost->the_post();
            $product = wc_get_product(get_the_ID());
            if($product->is_type( 'variable' )) {
                $r_price = $product->get_variation_regular_price( 'min' ). get_woocommerce_currency_symbol();
                $s_price = $product->get_variation_sale_price( 'min' ). get_woocommerce_currency_symbol();
            } else {
                $r_price = $product->get_regular_price(). get_woocommerce_currency_symbol();
                $s_price = $product->get_sale_price(). get_woocommerce_currency_symbol();
            } ?>
            <div class="item row">
                <?php if ($az_data['square_thumb']) {
                    $spimg = 'col-md-4 col-12';
                    $spdesc = 'col-md-8 col-12';
                } else {
                    $spimg = 'col-md-6 col-12';
                    $spdesc = 'col-md-6 col-12';
                }
                ?>
                <div class="<?php echo $spimg; ?> sp-img">
                    <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
                        <?php p_img(); ?>
                    </a>
                </div>
                <div class="<?php echo $spdesc; ?> sp-desc">
                    <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
                        <div class="col-12 sp-stitle">
                            <?php echo $settings['title']; ?>
                        </div>
                        <div class="col-12 sp-title">
                            <i class="fas fa-chevron-left" aria-hidden="true"></i><?php the_title(); ?>
                        </div>
                        <div class="col-12 sp-rprice">
                            <span class="woo-rprice">
                                <?php echo wc_price($r_price); ?>
                            </span>
                        </div>
                        <div class="col-12 sp-sprice">
                            <span>
                                <?php echo wc_price($s_price); ?>
                            </span>
                            <span class="sp-discount"><?php echo disw_price(get_the_ID()); ?></span>
                        </div>
                        <div class="col-12 sp-btn">
                            <?php
                            if($product->is_type( 'variable' )) {
                                $children_ids = $product->get_children();
                                $children_id = $children_ids[0];
                                $date = get_post_meta( $children_id, '_sale_price_dates_to', true );
                            } else {
                                $date = get_post_meta( get_the_ID(), '_sale_price_dates_to', true );
                            }
                            if ($date) {
                                $date += 24*60*60;
                                $sale_price_date = ($date) ? date('Y/m/d', $date) : ''; ?>
                            <div class="salecount" data-countdown="<?php echo $sale_price_date; ?>"></div>
                        <?php
                            } else { ?>
                            <div class="btn btn-blue">
                                <i class="fas fa-shopping-cart" aria-hidden="true"></i>
                                خرید محصول
                            </div>
                        <?php } ?>
                        </div>
                    </a>
                </div>
             </div>
              <?php endwhile; ?>
            </div>
        <?php
        } else {
            echo '<div class="not-found">فایلی با شرایط مورد نظر یافت نشد.</div>';
        }
            wp_reset_postdata(); ?>
        </div>
      </div>
         <?php
        } else {
            $specialpost = new \WP_Query(array(
                   'posts_per_page' => 5,
                   'post_type' => 'download',
                   'post_status' => 'publish',
                   'meta_key' => 'file_spsale',
                   'meta_value' => 1,
                   'order' => 'DESC'  ));
 ?>
            <div class="scon">
        <div class="spslider-con">
        <?php if ( $specialpost->have_posts() ) { ?>
        <div class="slide-progress"></div>
         <div class="spslider owl-carousel" <?php if ('yes' === $settings['auto_play']) { echo 'data-itemplay="true"'; } else { echo 'data-itemplay="false"'; } ?> data-itemtime="<?php echo $settings['time']; ?>">
               <?php while ( $specialpost->have_posts() ) : $specialpost->the_post(); ?>
             <div class="item col-12">
                <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
                 <?php if ($az_data['square_thumb']) {
                    $spimg = 'col-md-4 col-12';
                    $spdesc = 'col-md-8 col-12';
                } else {
                    $spimg = 'col-md-6 col-12';
                    $spdesc = 'col-md-6 col-12';
                }
                ?>
                 <div class="<?php echo $spimg; ?> sp-img">
                 <?php p_img(); ?>
             </div>
             <div class="<?php echo $spdesc; ?> sp-desc">
                <div class="col-12 sp-stitle">
                    <?php echo $settings['title']; ?>
                </div>
                <div class="col-12 sp-title">
                     <i class="fas fa-chevron-left" aria-hidden="true"></i><?php the_title(); ?>
                </div>
                <div class="col-12 sp-rprice">
                     <span><?php 
                         $saleprice = edd_format_amount(rwmb_meta( 'file_saleprice', '' , get_the_ID() ));
                         echo '<del>'.$saleprice.' تومان</del>'; 
                     ?></span>
                </div>
                <div class="col-12 sp-sprice">
                     <span><?php 
                    $price = edd_price(get_the_ID(),false);
                    $price = preg_replace("/<([a-z][a-z0-9]*)[^>]*?(\/?)>/i",'<$1$2>', $price);
                    echo $price;
                    ?></span>
                    <span class="sp-discount"><?php echo dis_price(get_the_ID()); ?></span>
                </div>
                <div class="col-12 sp-btn">
                    <div class="btn btn-blue">
                        <i class="fas fa-shopping-cart" aria-hidden="true"></i>
                        خرید محصول
                    </div>
                </div>
             </div>
                 </a>
             </div>
              <?php endwhile; ?>
          </div>
                <?php  } else {echo '<div class="not-found">فایلی با شرایط مورد نظر یافت نشد.</div>';}
                     wp_reset_postdata();
                     ?>
          </div>
      </div>
        <?php }
	}

}