<?php
namespace Elementor;

class Azin_Woo_Products_Block extends Widget_Base {

	public function get_name() {
		return 'azin-woo-products-block';
	}
	
	public function get_title() {
		return 'بلاک محصولات ووکامرس';
	}
	
	public function get_icon() {
		return 'fas fa-shopping-cart';
	}
	
	public function get_categories() {
		return [ 'azin-file' ];
	}
	
	protected function _register_controls() {
		require get_template_directory() . '/includes/widgets/fa.php';
		$prod_cat = array();
		$categories = get_terms("product_cat");
		if ( !empty( $categories ) && !is_wp_error( $categories ) ){
		foreach ( $categories as $category ) {
		$prod_cat[ $category->term_id ] = $category->name;
		}
		}

		$this->start_controls_section(
			'section_title',
			[
				'label' => 'بلاک محصولات ووکامرس',
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => 'عنوان',
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => 'محصولات',
				'placeholder' => 'عنوان را وارد نمایید',
			]
		);

		$this->add_control(
			'prod_sort',
			[
				'label' => 'مرتب سازی محصولات',
				'type' => Controls_Manager::SELECT,
				'default' => 'latest',
				'options' => [
					'latest'  => 'جدیدترین محصولات',
					'random' => 'محصولات تصادفی',
					'viewed' => 'محصولات پربازدید',
					'saled' => 'محصولات پرفروش',
					'discounted' => 'محصولات تخفیف خورده',
					'special' => 'محصولات ویژه',
				],
			]
		);

		$this->add_control(
			'prod_cat',
			[
				'label' => 'دسته بندی محصولات',
				'type' => Controls_Manager::SELECT2,
				'options' => $prod_cat,
			]
		);

		$this->add_control(
			'prod_icon',
			[
				'label' => 'آیکن',
				'type' => Controls_Manager::SELECT2,
				'options' => $icons_font_awesome,
				'default' => 'shopping-cart'
			]
		);

		$this->add_control(
			'auto_play',
			[
				'label' => 'حرکت خودکار',
				'type' => Controls_Manager::SWITCHER,
				'label_on' => 'روشن',
				'label_off' => 'خاموش',
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'prod_loop',
			[
				'label' => 'تکرار محصولات',
				'type' => Controls_Manager::SWITCHER,
				'label_on' => 'روشن',
				'label_off' => 'خاموش',
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'ptotalcount',
			[
				'label' => 'تعداد محصولات',
				'type' => Controls_Manager::NUMBER,
				'min' => 8,
				'max' => 20,
				'step' => 1,
				'default' => 8,
			]
		);

		$this->add_control(
			'pcount',
			[
				'label' => 'تعداد ستون محصولات',
				'type' => Controls_Manager::NUMBER,
				'min' => 3,
				'max' => 5,
				'step' => 1,
				'default' => 4,
			]
		);

		$this->end_controls_section();
	}
	
	protected function render() {
        global $az_data;
        $settings = $this->get_settings_for_display();
        $prod_cat = $settings['prod_cat']; ?>
        <div class="rcon">
			<div class="post-block m-product">
				<div class="post-title">
					<h3>
						<?php if ($prod_cat != '') { ?><a href="<?php echo get_category_link($prod_cat); ?>"><?php } ?>
							<i class="fas fa-<?php echo $settings['prod_icon']; ?>"></i>
							<?php echo $settings['title']; ?>
						<?php if ($prod_cat != '') { ?></a><?php } ?>
					</h3>
					<?php if ($prod_cat != '') { ?>
					<a class="float-left morebtn" href="<?php echo get_category_link($prod_cat); ?>">
					<?php echo $az_data['text_more']; ?>
					<i class="fas fa-chevron-left"></i></a>
					<?php } ?>
				</div>
			<?php
            $prod_sort = $settings['prod_sort'];

			if($prod_sort != 'special'){
			switch ($prod_sort) {
				case 'latest':
					$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'product',
					'post_status' => 'publish',
					'order' => 'DESC'  );
					break;
				case 'saled':
					$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'product',
					'post_status' => 'publish',
					'meta_key' => 'total_sales',
                    'orderby' => 'meta_value_num',
                    'order' => 'DESC'  );
					break;
				case 'discounted':
					$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'product',
					'post_status' => 'publish',
					'meta_query' => array(
                    array(
                        'key' => '_sale_price',
                        'value'   => array(''),
                        'compare' => 'NOT IN'
                    )
                    ),
                    'order' => 'DESC'  );
					break;
				case 'viewed':
					$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'product',
					'post_status' => 'publish',
					'meta_key' => 'post_views_count',
                    'orderby' => 'meta_value_num',
                    'order' => 'DESC'  );
					break;
				case 'random':
					$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'product',
					'post_status' => 'publish',
					'orderby'        => 'rand'  );
					break;
				default:
				$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'product',
					'post_status' => 'publish',
					'order' => 'DESC'  );
				}
				if ( $prod_cat ) {
					$args['tax_query'] = array(
						array(
						'taxonomy' => 'product_cat',
						'field' => 'term_id',
						'terms' => $prod_cat
						)
					);
				}
			}
			elseif ($prod_sort == 'special') {
				$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'product',
					'post_status' => 'publish',
					'meta_query' => array(
                    array(
						'key' => 'file_special',
						'compare' => '=',
						'value' => 1,
						'type' => 'numeric'
					),
                    ),
					'order' => 'DESC'  );
			}

			$productsquery = new \WP_Query( $args );
		?>
		
		<?php if ( $productsquery->have_posts() ) { ?>
		<div class="owl-carousel" <?php if ('yes' === $settings['prod_loop']) {
						echo 'data-itemloop="true"';
					} else {
						echo 'data-itemloop="false"';
					} ?> <?php if ('yes' === $settings['auto_play']) {
						echo 'data-itemplay="true"';
					} else {
						echo 'data-itemplay="false"';
					} ?> data-itemscount="<?php echo $settings['pcount']; ?>">
        <?php while ( $productsquery->have_posts() ) : $productsquery->the_post(); ?>
			<div class="item">
				<div class="rcol">
					<div class="r-box r-box-view">
					<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
						<div class="figure">
							<div class="fig">
							<span class="fig-price"><span>
							<?php $product = new \WC_Product(get_the_ID()); 
							echo $product->get_price_html(); ?></span></span> 
							<?php p_mimg() ?>
							<?php if(rwmb_meta( 'file_special' )){ ?>
							<span class="special" aria-hidden="true"><?php echo $az_data['text_special']; ?></span>
							<?php } ?>
							</div>
							<div class="figcaption">
								<?php the_title(); ?>
							</div>
						</div>
					</a>
					</div>
				</div>
			</div>
        <?php endwhile; ?>
        </div>
		<?php 
		} else {		
		echo 'لطفا ابتدا نوشته ای را اضافه نمایید.';}
		wp_reset_postdata();
		?>
        </div>
   		</div>
        <?php

	}

}