<?php
namespace Elementor;

class Azin_Woo_Products extends Widget_Base {

	public function get_name() {
		return 'azin-woo-products';
	}
	
	public function get_title() {
		return 'محصولات ووکامرس';
	}
	
	public function get_icon() {
		return 'fas fa-shopping-cart';
	}
	
	public function get_categories() {
		return [ 'azin-file' ];
	}
	
	protected function _register_controls() {
		require get_template_directory() . '/includes/widgets/fa.php';
		$prod_cat = array();
		$categories = get_terms("product_cat");
		if ( !empty( $categories ) && !is_wp_error( $categories ) ){
		foreach ( $categories as $category ) {
		$prod_cat[ $category->term_id ] = $category->name;
		}
		}

		$this->start_controls_section(
			'section_title',
			[
				'label' => 'محصولات ووکامرس',
			]
		);

		$this->add_control(
			'ptotalcount',
			[
                'label' => 'تعداد مطالب',
                'type' => Controls_Manager::NUMBER,
                'min' => 8,
                'max' => 24,
                'step' => 1,
                'default' => 8,
            ]
		);

        $this->add_control(
            'pcount',
            [
                'label' => 'تعداد ستون مطالب',
                'type' => Controls_Manager::NUMBER,
                'min' => 3,
                'max' => 4,
                'step' => 1,
                'default' => 4,
            ]
		);
		
		$this->add_control(
			'prod_sort',
			[
				'label' => 'مرتب سازی محصولات',
				'type' => Controls_Manager::SELECT,
				'default' => 'latest',
				'options' => [
					'latest'  => 'جدیدترین محصولات',
					'random' => 'محصولات تصادفی',
					'viewed' => 'محصولات پربازدید',
					'saled' => 'محصولات پرفروش',
					'discounted' => 'محصولات تخفیف خورده',
					'special' => 'محصولات ویژه',
				],
			]
		);

		$this->add_control(
			'prod_cat',
			[
				'label' => 'دسته بندی محصولات',
				'type' => Controls_Manager::SELECT2,
				'options' => $prod_cat,
			]
		);


		$this->end_controls_section();
	}
	
	protected function render() {
        global $az_data;
        $settings = $this->get_settings_for_display();
        $col = ($settings['pcount'] == 3 ? 'col-md-4 col-6' : 'col-md-3 col-6');
		$prod_sort = $settings['prod_sort'];
		$prod_cat = $settings['prod_cat'];
		
		if($prod_sort != 'special'){
			switch ($prod_sort) {
				case 'latest':
					$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'product',
					'post_status' => 'publish',
					'order' => 'DESC'  );
					break;
				case 'saled':
					$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'product',
					'post_status' => 'publish',
					'meta_key' => 'total_sales',
                    'orderby' => 'meta_value_num',
                    'order' => 'DESC'  );
					break;
				case 'discounted':
					$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'product',
					'post_status' => 'publish',
					'meta_query' => array(
                    array(
                        'key' => '_sale_price',
                        'value'   => array(''),
                        'compare' => 'NOT IN'
                    )
                    ),
                    'order' => 'DESC'  );
					break;
				case 'viewed':
					$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'product',
					'post_status' => 'publish',
					'meta_key' => 'post_views_count',
                    'orderby' => 'meta_value_num',
                    'order' => 'DESC'  );
					break;
				case 'random':
					$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'product',
					'post_status' => 'publish',
					'orderby'        => 'rand'  );
					break;
				default:
				$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'product',
					'post_status' => 'publish',
					'order' => 'DESC'  );
				}
				if ( $prod_cat ) {
					$args['tax_query'] = array(
						array(
						'taxonomy' => 'product_cat',
						'field' => 'term_id',
						'terms' => $prod_cat
						)
					);
				}
			} elseif ($prod_sort == 'special') {
				$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'product',
					'post_status' => 'publish',
					'meta_query' => array(
                    array(
						'key' => 'file_special',
						'compare' => '=',
						'value' => 1,
						'type' => 'numeric'
					),
                    ),
					'order' => 'DESC'  );
			}

        $products = new \WP_Query($args); ?>
		<div class="row">
		<?php if ($products->have_posts()) : $i = 1; ?>
			<?php while ($products->have_posts()) : $products->the_post(); ?>
			<div role="main" class="<?php echo $col;?> pcon" id="post-<?php the_ID(); ?>">
				<a href="<?php the_permalink() ?>" title="<?php the_title(); ?>" class="vi-img-res-box">
				<div class="product">
					<div class="post-img">
						<div class="post-icon">
						<span class="price"><?php posticon(get_the_ID()); ?></span>
						</div>
						<?php p_img() ?>
						<?php
							if (rwmb_meta('file_special')) { ?>
							<span class="special" aria-hidden="true"><?php echo $az_data['text_special']; ?></span>
							<?php } ?>
						<div class="prod-price price pt-price">
						<i class="fas fa-database price-icon"></i>
						<?php $product = new \WC_Product(get_the_ID()); ?>
						<?php echo $product->get_price_html(); ?>
						</div>
					</div>
					<div class="col-12">
						<div class="col-10 prod-name pt-name">
						<h2 title="<?php the_title(); ?>"><?php the_title(); ?></h2>
						</div>
					</div>
					<?php if ($az_data['show_excerpt']) { ?>
					<div class="col-12 pdesc">
						<?php the_excerpt(); ?>
					</div>
					<?php } ?>
				</div>
				</a>
			</div>
			<?php $i+=1; ?>
			<?php endwhile; ?>
			<div class="col-12">
				<?php if ($prod_cat != '') {
					 	$all_link = get_category_link($prod_cat);
					 } else {
						$all_link = get_home_url(). '/?post_type=product&s=';
					 } ?>
				<a href="<?php echo $all_link; ?>" class="btn btn-outline-success btn-lg btn-view-all" title="مشاهده تمامی محصولات">
					<i class="fas fa-shopping-cart" aria-hidden="true"></i>
					مشاهده تمامی محصولات
					<i class="fas fa-angle-left" aria-hidden="true"></i>
				</a>
			</div>
			<?php else : ?>
				<div class="alert alert-warning alert-dismissible anote"><strong><span class="fas fa-bell" aria-hidden="true">
					</span> <?php echo $az_data['text_not_found']; ?></strong>
				</div>
		<?php endif;
		wp_reset_postdata(); ?>
		</div>
        <?php

	}

}