<?php

//Add Woocommerce theme support
add_action('after_setup_theme','woocommerce_support');

function woocommerce_support() {
	add_theme_support( 'woocommerce' );
}

/**
 * Change number or products per row to 3
 */
add_filter('loop_shop_columns', 'loop_columns', 999);
if (!function_exists('loop_columns')) {
	function loop_columns() {
		return 3; // 3 products per row
	}
}

/**
 * Change number of products that are displayed per page (shop page)
 */
add_filter( 'loop_shop_per_page', 'new_loop_shop_per_page', 20 );

function new_loop_shop_per_page( $cols ) {
  $cols = get_option('posts_per_page');
  return $cols;
}

// Remove each style one by one
add_filter( 'woocommerce_enqueue_styles', 'jk_dequeue_styles' );
function jk_dequeue_styles( $enqueue_styles ) {
	unset( $enqueue_styles['woocommerce-general-rtl-css'] );	// Remove the gloss
	return $enqueue_styles;
}

/**
* @snippet Display &quot;FREE&quot; if WooCommerce Product Price is Zero or Empty - WooCommerce
* @how-to Watch tutorial @ https://businessbloomer.com/?p=19055
* @sourcecode https://businessbloomer.com/?p=73147
* @author Rodolfo Melogli
* @testedwith WooCommerce 3.4
*/
 
add_filter( 'woocommerce_get_price_html', 'aprice_free_zero_empty', 100, 2 );
  
function aprice_free_zero_empty( $price, $product ){
global $az_data;
if(rwmb_meta( 'file_coming','', $product->get_id() )) {
    $price= "<span>".$az_data['text_coming_soon']."</span>";
} else {    
if ( '' === $product->get_price() || 0 == $product->get_price() && $az_data['free_price'] ) {
    $price = '<span class="woocommerce-Price-amount amount">'.$az_data['text_free'].'</span>';
} 
}
return $price;
}

/**
 * Change several of the breadcrumb defaults
 */
add_filter( 'woocommerce_breadcrumb_defaults', 'az_woocommerce_breadcrumbs' );
function az_woocommerce_breadcrumbs() {
    return array(
            'delimiter'   => ' &#47; ',
            'wrap_before' => '<nav class="breadcrumbs" itemprop="breadcrumb">',
            'wrap_after'  => '</nav>',
            'before'      => '',
            'after'       => '',
            'home'        => _x( 'Home', 'breadcrumb', 'woocommerce' ),
        );
}

/**
 * Remove the breadcrumbs 
 */
add_action( 'init', 'woo_remove_wc_breadcrumbs' );
function woo_remove_wc_breadcrumbs() {
    remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0 );
}

//Add Woocommerce star rating top of the product page
function waproduct_add_star_rating()
{
global $woocommerce, $product;
$average = $product->get_average_rating();
$review_count = $product->get_review_count();
echo '<div class="star-rating"><span style="width:'.floor( ( $average / 5 ) * 100 ) . '%"></span></div>';
if($average!= 0){
echo '<div style="display: none;" itemprop="aggregateRating" itemscope="" itemtype="http://schema.org/AggregateRating">
<meta itemprop="bestRating" content="5">
<meta itemprop="ratingValue" content="'.floor($average).'">
<meta itemprop="ratingCount" content="'.$review_count.'">
</div>';
}
}

/**
 * Show cart contents / total Ajax
 */
add_filter( 'woocommerce_add_to_cart_fragments', 'woocommerce_header_add_to_cart_fragment' );

function woocommerce_header_add_to_cart_fragment( $fragments ) {
	global $woocommerce;
	ob_start();
	?>
	<span class="header-cart edd-cart-quantity badge">
    <?php echo $woocommerce->cart->cart_contents_count; ?></span>
	<?php
	$fragments['span.edd-cart-quantity'] = ob_get_clean();
	return $fragments;
}

//Total Sales of woocommerce products
function az_woo_get_total_sales() {
$total_orders = count(wc_get_orders( array(
    'status' => 'completed',
    'return' => 'ids',
    'limit' => -1,
)));
return $total_orders;
}

//Woo dis price
function disw_price ($id){
    $product = wc_get_product( $id );
    if($product->is_type( 'variable' )){
        $r_price = $product->get_variation_regular_price( 'min' );
        $s_price = $product->get_variation_sale_price( 'min' );
    } else {
        $r_price = $product->get_regular_price();
        $s_price = $product->get_sale_price();
    }
    $d_price = (int)$r_price - (int)$s_price;
    $t_price = round(($d_price/$r_price)*100);
    return '<span>'. $t_price .'٪ تخفیف</span>';
    return $t_price;
}

//Check product is free
function azin_woo_free( $id ){
$product = wc_get_product( $id );
if ( '' === $product->get_price() || 0 == $product->get_price() && defined( 'SOMDN_PATH' )) {
    return true;
} else {
    return false;
}
}

//Set template of Dokan
if( class_exists( 'WeDevs_Dokan' ) ) { 
add_filter( 'page_template', 'dokan_page_template' );
function dokan_page_template( $page_template ) {
    global $post;
    $post_id = $post->ID;
    if($post_id === dokan_get_option( 'dashboard', 'dokan_pages' ) ) {
            $page_template = get_stylesheet_directory() . '/dashboard.php'; 
    } 
    return $page_template;
}
}

function azin_before_account_navigation(){
    $azin_before = '<div class="row"><div class="col-lg-3 col-12 dashboard-con">
                     <div class="dashboard-menu-con">';
    $user = wp_get_current_user(); 
	$azin_before .= get_avatar(get_current_user_id() , 120,'' ,$user->display_name );
    $azin_before .='<span class="side-uname">'. $user->display_name .'</span>';
	if (class_exists('WooWallet'))
	{
        $wallet = woo_wallet()->wallet->get_wallet_balance( get_current_user_id() );
        $azin_before .= '<span class="m-wallet">موجودی کیف پول: '.$wallet.'</span>';
    }
    echo $azin_before;
}
function azin_after_account_navigation() {
    echo '</div></div>';
}
add_action('woocommerce_before_account_navigation', 'azin_before_account_navigation');
add_action('woocommerce_after_account_navigation', 'azin_after_account_navigation');



//Add Affiliate link to my account page
if( class_exists( 'Affiliate_WP' ) ) {
add_filter ( 'woocommerce_account_menu_items', 'affiliate_one_more_link' );
function affiliate_one_more_link( $menu_links ){
	$new = array( 'affiliate-wp' => 'همکاری در فروش' ); 
	$menu_links = array_slice( $menu_links, 0, 5, true ) 
	+ $new 
	+ array_slice( $menu_links, 1, NULL, true );
	return $menu_links;
}

add_filter( 'woocommerce_get_endpoint_url', 'affiliate_hook_endpoint', 10, 4 );
function affiliate_hook_endpoint( $url, $endpoint, $value, $permalink ){
	if( $endpoint === 'affiliate-wp' ) {
		$url = esc_url( affwp_get_affiliate_area_page_url() );
	}
	return $url;
}
}

add_action('dokan_dashboard_wrap_start', 'azin_dokan_dashboard_wrap_start', 10);
function azin_dokan_dashboard_wrap_start(){
    global $az_data;
 ?>
    <section class="single-con">
        <article role="main" id="post-<?php the_ID(); ?>">
<?php }

add_action('dokan_dashboard_wrap_end', 'azin_dokan_dashboard_wrap_end', 10);
function azin_dokan_dashboard_wrap_end(){
 ?>
        </article>
    </section>
<?php }

//Add WooCommerce the_excerpt before the_content
add_filter('the_content', 'azin_before_woo_content');
function azin_before_woo_content($content) {
    global $post;
    if(is_product() && !empty($post->post_excerpt))
    {
        $beforecontent = '<blockquote class="prod-excerpt blockquote">';
        $beforecontent .= '<i class="fas fa-pen-square" aria-hidden="true"></i>';
        $beforecontent .= $post->post_excerpt;
        $beforecontent .= '</blockquote>';
        $content = $beforecontent . $content;
        return $content;
    } else {
        return $content;
    }
}