<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: Hosseinkhani.ir
*/
   // Exit if accessed directly
   if (!defined('ABSPATH')) {
    exit;
}

class EDD_Random_downloads_widget extends WP_Widget {
      public function __construct() {
         $widget_ops = array('classname' => 'edd-random-downloads_widget', 'description' => 'نمایش تصادفی محصولات' );
         parent::__construct('edd-random-downloads', 'محصولات تصادفی (آذین فایل)', $widget_ops);
         $this->alt_option_name = 'edd-random-downloads_widget';
      }
      function widget($args, $instance) {
        extract( $args );
            $title = apply_filters( 'widget_title', empty($instance['title']) ? 'محصولات تصادفی' : $instance['title'], $instance, $this->id_base); 
            if (!$number = absint($instance['number'])) {
            $number = 5;
        }
        $randposts = get_posts('orderby=rand&numberposts='.$number.'&post_type=product');
          global $post;
          global $product;
          global $az_data;
            //save the current post
            $temp=$post;
   			echo $before_widget;
   			// Widget title
   			echo $before_title;
   			echo $instance["title"];
   			echo $after_title;
   		echo "<ul>\n";	
         if( $randposts ){
   		foreach($randposts as $post){
            setup_postdata($post); 
   		?>
<li class="edd-random-post-item">
   <div class="post-image">
      <?php if ( has_post_thumbnail()) :  ?>
      <?php the_post_thumbnail( 'widget-img' ); ?>
      <?php else: ?>
      <img src="<?php echo esc_url( get_template_directory_uri() ); ?>/images/mtumb.png" alt="<?php the_title_attribute(); ?>" class="post-tumb"/>
      <?php endif; ?>
   </div>
   <div class="w-details">
      <a  href="<?php the_permalink(); ?>" rel="bookmark" title="<?php the_title_attribute(); ?>">
      <?php the_title();?>
      </a>
      <br />
      <span class="w-price"><?php $product = new WC_Product(get_the_ID()); 
												echo $product->get_price_html(); ?></span>
   </div>
</li>
<?php
   }
    $post=$temp;
   }
   else
   {
      echo $az_data['text_not_found'];
   }
    wp_reset_postdata();
   echo "</ul>\n";
   echo $after_widget;
   }
   public function update( $new_instance, $old_instance ) {
   $instance = $old_instance;
   $instance['title'] = sanitize_text_field( $new_instance['title'] );
   $instance['number'] = (int) $new_instance['number'];
   return $instance;
   }
   public function form( $instance ) {
   $title     = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
   $number    = isset( $instance['number'] ) ? absint( $instance['number'] ) : 5;
   ?>
<p><label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:' ); ?></label>
   <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $title; ?>" />
</p>
<p><label for="<?php echo $this->get_field_id( 'number' ); ?>"><?php _e( 'Number of posts to show:' ); ?></label>
   <input class="tiny-text" id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" type="number" step="1" min="1" value="<?php echo $number; ?>" size="3" />
</p>
<?php
   }
   }
   // register EDD Recent downloads Widget
   add_action( 'widgets_init', function() {return register_widget("EDD_Random_downloads_widget");} );
      