<?php
/**
 * @see http://tgmpluginactivation.com/configuration/ for detailed documentation.
 *
 * @package    TGM-Plugin-Activation
 * @subpackage Example
 * @version    2.6.1 for parent theme Azinfile
 * @author     Thomas Griffin, Gary Jones, Juliette Reinders Folmer
 * @copyright  Copyright (c) 2011, Thomas Griffin
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       https://github.com/TGMPA/TGM-Plugin-Activation
 */

require_once get_template_directory() . '/plugins/class-tgm-plugin-activation.php';

add_action( 'tgmpa_register', 'tgmpa_register_required_plugins' );

function tgmpa_register_required_plugins() {
	/*
	 * Array of plugin arrays. Required keys are name and slug.
	 * If the source is NOT from the .org repo, then source is also required.
	 */
	$az_data[] = '';
	global $az_data;
	if ( $az_data['woo_mode'] ) {
	$plugins = array(
		// This is an example of how to include a plugin from the WordPress Plugin Repository.
		array(
			'name'      => 'ووکامرس',
			'slug'      => 'woocommerce',
			'required'  => true,
		),
		array(
			'name'      => 'ووکامرس پارسی',
			'slug'      => 'persian-woocommerce',
			'required'  => true,
		),
		array(
			'name'      => 'صفحه ساز المنتور',
			'slug'      => 'elementor',
			'required'  => true,
		),
		array(
			'name'      => 'دانلودهای رایگان ووکامرس',
			'slug'      => 'download-now-for-woocommerce',
			'required'  => false,
		),
		array(
			'name'      => 'پارسی دیت',
			'slug'      => 'wp-parsidate',
			'required'  => true,
		),
	);
} else {
    $plugins = array(
		// This is an example of how to include a plugin from the WordPress Plugin Repository.
		array(
			'name'      => 'ایزی دیجیتال دانلودز',
			'slug'      => 'easy-digital-downloads',
			'required'  => true,
		),
        array(
        'version'            => '1.0.7',
        'name'               => 'پنل مشتریان EDD', // The plugin name.
        'slug'               => 'EDD-Customer-Dashboard', // The plugin slug (typically the folder name).
        'source'             => get_template_directory() . '/plugins/EDD-Customer-Dashboard.zip', // The plugin source.
        ),
		array(
			'name'      => 'ثبت نام خودکار EDD',
			'slug'      => 'edd-auto-register',
			'required'  => true,
		),
		array(
			'name'      => 'پارسی دیت',
			'slug'      => 'wp-parsidate',
			'required'  => true,
		),
		array(
			'name'      => 'دانلود رایگان EDD',
			'slug'      => 'easy-digital-downloads-free-link',
			'required'  => false,
		),
	);
}
	$config = array(
		'id'           => 'tgmpa',                 // Unique ID for hashing notices for multiple instances of TGMPA.
		'default_path' => '',                      // Default absolute path to bundled plugins.
		'menu'         => 'tgmpa-install-plugins', // Menu slug.
		'parent_slug'  => 'themes.php',            // Parent menu slug.
		'capability'   => 'edit_theme_options',    // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
		'has_notices'  => true,                    // Show admin notices or not.
		'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
		'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
		'is_automatic' => false,                   // Automatically activate plugins after installation or not.
		'message'      => '',                      // Message to output right before the plugins table.
	);

	tgmpa( $plugins, $config );
}
