<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: Hosseinkhani.ir
*/

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}
get_header();
?>

<div class="container-fluid main-con">
    <main class="container">

    <?php azin_bread(); ?>
        
      <div class="row main<?php side_type(); ?>" id="main" <?php if ($az_data['site_schema']) { ?>itemscope itemtype="https://schema.org/Blog" <?php } ?>>

<div class="<?php echo p_sidebar(get_the_ID()); if ($az_data['sticky_side']) { echo ' pcol'; }?>">
    
    <!-- start head banner -->
    <?php if ($az_data['show_post_head_banner']) { ?>
    <div class="foot-con hovers">
        <a href="<?php echo $az_data['post_head_banner_link']; ?>" aria-label="<?php echo $az_data['post_head_banner_title']; ?>">
            <figure><img src="<?php echo $az_data['post_head_banner']['url']; ?>" alt="<?php echo $az_data['post_head_banner_title']; ?>" class="foot-banner" /></figure>
        </a>
    </div>
    <?php }?>
    <!-- end head banner -->

    <?php if ( have_posts() ) : ?>
    <?php while ( have_posts() ) : the_post(); ?>
    <article role="main" class="scon" id="post-<?php the_ID(); ?>" <?php if($az_data['site_schema']) {?>itemprop="blogPost" itemscope itemtype="https://schema.org/BlogPosting"
        <?php } ?>>
        <?php if($az_data['site_schema']) {?>
        <link itemprop="mainEntityOfPage" href="<?php the_permalink(); ?>" />
        <meta itemprop="image" content="<?php the_post_thumbnail_url(); ?>">
        <span itemprop="publisher" itemscope itemtype="https://schema.org/Organization">
            <span itemprop="logo" itemscope itemtype="https://schema.org/ImageObject">
                <meta itemprop="url" content="<?php echo $az_data['site_logo']['url']; ?>">
                <meta itemprop="width" content="140">
                <meta itemprop="height" content="60">
            </span>
            <meta itemprop="name" content="<?php edd_az(); bloginfo('name'); ?>">
        </span>
        <?php } ?>
        <div class="s-product">
            <header>
                    <div class="post-title">
                        <h1 <?php if($az_data['site_schema']) { ?>itemprop="name headline"
                            <?php } ?>><i aria-hidden="true" class="fas fa-pen-square"></i>
                            <?php the_title(); ?>
                        </h1>
                        <div class="post-extra">
                            <?php if( function_exists("df_star_ratings") && ($az_data['star_rating']) ) { ?>
                            <div class="rating">
                                <?php echo df_star_ratings(get_the_ID()); ?>
                            </div>
                            <?php } ?>
                            <?php if ($az_data['social_share']) { ?>
                            <span tabindex="0" class="share-btn" data-toggle="modal" data-target="#shareModal"><i class="fas fa-share-alt"></i></span>
                            <?php } ?>
                        </div>
                    </div>
            </header>
            <div class="post-con" <?php if($az_data['site_schema']) {?>itemprop="articleBody"<?php } ?>>
                <?php if ( has_post_thumbnail() && $az_data['show_post_thumb']) { ?>
                    <div class="post-thumb">
                        <?php the_post_thumbnail('larg'); ?>
                    </div>
                <?php } ?>
                <?php if ($az_data['text_summ']) { ?>
                <div class="single-text">
                    <?php } ?>
                    <?php the_content();?>
                    <?php
                        $defaults = array(
                            'before'           => '<div class="text-center apage-break">',
                            'after'            => '</div>',
                            'link_before'      => '',
                            'link_after'       => '',
                            'next_or_number'   => 'text',
                            'separator'        => ' ',
                            'nextpagelink'     => '<span class="btn btn-primary">صفحه بعد <i aria-hidden="true" class="fas fa-angle-left"></i></span>',
                            'previouspagelink' => '<span class="btn btn-primary"><i aria-hidden="true" class="fas fa-angle-right"></i> صفحه قبل</span>',
                            'pagelink'         => '%',
                            'echo'             => 1
                        );
                        wp_link_pages($defaults); ?>
                    <?php if ($az_data['text_summ']) { ?>
                    <p class="read-more"><a href="#" class="sbutton">
                            <?php echo $az_data['text_read_more']; ?></a></p>
                </div>
                <?php } ?>
                <footer class="details">
                        <?php if(rwmb_meta( 'file_dbox' )) { ?>
                        <!--DL Box-->
                        <div class="dlbox">
                            <div class="dltitle">
                                <i class="fas fa-download"></i>
                                <?php echo $az_data['text_dl']; ?>
                                <?php echo rwmb_meta( 'file_fname', $args, $post->ID ); ?>
                            </div>
                            <?php if( $az_data['show_dl_logged'] && !is_user_logged_in()) {?>
                                <div class="dl-login-msg">
                                    برای مشاهده لینک های دانلود
                                   <a <?php if (!$az_data['ch_login_link']) { echo 'href="#" data-toggle="modal" data-target="#login"';
                                    } else {
                                        echo 'href="' .$az_data['login_link'].'"';
                                    } ?>>
                                        وارد شوید
                                    </a>
                                    یا
                                    <a <?php if (!$az_data['ch_register_link']) {
                                    if (az_woo()) {
                                        echo 'href="' .esc_url(home_url()).'/my-account"';
                                    } else {
                                        echo 'href="' .esc_url(home_url()).'/register"';
                                    }
                                    } else {
                                        echo 'href="' .$az_data['register_link'].'"';
                                    } ?> title="<?php echo $az_data['text_reg_hint']; ?>">
                                        ثبت نام
                                    </a>
                                    نمایید.
                                </div>
                            <?php } else { ?>
                            <div class="links">
                                <?php 
                                $urls = rwmb_meta( 'file_furl', $args, $post->ID );
                                $box_type = rwmb_meta( 'file_box_type', $args, $post->ID );
                                if ( !empty( $urls ) ) {
                                    if ($box_type=='box_part' || $box_type == '') {
                                    foreach ( $urls as $urls ) {
                                        if (filter_var($urls, FILTER_VALIDATE_URL) === FALSE) {
                                            echo '<div class="plain"><i class="fas fa-chain"></i>'.$urls.'</div>';
                                        } else {
                                        $url_name = str_replace('%20', ' ', basename($urls));
                                        $url_name = str_replace('-', ' ', $url_name); 
                                        echo '<a href="'.$urls.'" title="'.$url_name.'" class="flink"><i class="fas fa-caret-left"></i>'.$url_name.'</a>';
                                        }
                                    }
                                    } elseif ($box_type=='box_single') {
                                    foreach ( $urls as $url ) {
                                        if (filter_var($url, FILTER_VALIDATE_URL)) {
                                            echo '<a href="'.$url.'"';
                                        } else {
                                        echo 'title="'.$url.'" class="flink"><i class="fas fa-caret-left"></i>'.$url.'</a>';
                                        }
                                    }
                                    }
                                } ?>
                            </div>
                            <?php } ?>

                            <div class="row fdet">
                                <div class="col-md-4 sdet">
                                    <i class="fas fa-save"></i>
                                    <span aria-hidden="true" data-toggle="tooltip" data-placement="top" title="" data-original-title="<?php echo $az_data['text_size']; ?>"><?php echo rwmb_meta( 'file_fsize', $args, $post->ID ); ?></span>
                                </div>
                                <div class="col-md-4 sdet">
                                    <i class="fas fa-lock"></i>
                                    <span aria-hidden="true" data-toggle="tooltip" data-placement="top" title="" data-original-title="<?php echo $az_data['text_pass']; ?>">
                                        <?php echo rwmb_meta( 'file_fpass', $args, $post->ID ); ?>
                                    </span>
                                </div>
                                <div class="col-md-4 sdet">
                                    <span class="dhelp" data-toggle="modal" data-target="#dhelp">
                                        <i class="fas fa-question-circle"></i>
                                        <span aria-hidden="true" data-toggle="tooltip" data-placement="top" title="" data-original-title="<?php echo $az_data['text_hdl']; ?>"><?php echo $az_data['text_hdl']; ?></span>
                                    </span>
                                </div>
                            </div>
                            <!-- Modal -->
                            <div class="modal fade" id="dhelp">
                            <div class="modal-dialog modal-dialog-centered">
                                <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title">
                                        <?php echo $az_data['dl_help_title']; ?>
                                    </h4>
                                    <button type="button" class="close" data-dismiss="modal">
                                        <i class="fas fa-times" aria-hidden="true"></i>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <?php echo $az_data['dl_help_text']; ?>
                                </div>
                                </div>
                            </div>
                            </div>
                            <!-- Modal -->
                        </div>
                        <!--DL Box-->
                        <?php } ?>
                        <!-- Article Attr -->
                        <div class="row">
                            <?php if($az_data['show_post_author']) { ?>
                            <div class="col pattr" <?php if($az_data['site_schema']) {?>itemprop="author" itemscope itemtype="https://schema.org/Person"<?php } ?>>
                                <i class="col-2 fas fa-user po-picon"></i>
                                <span class="col-10" lang="fa" dir="rtl">
                                    <a class="author-link" href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ); ?>">
                                        <span <?php if($az_data['site_schema']) {?> itemprop="name"<?php } ?>>
                                            <?php the_author(); ?>
                                        </span>
                                    </a>
                                </span>
                            </div>
                            <?php } ?>
                            
                            <?php if($az_data['show_post_date']) { ?>
                            <div class="col pattr">
                                <i class="col-2 fas fa-calendar po-picon"></i>
                                <span class="col-10">
                                    <?php if($az_data['site_schema']) { ?>
                                    <time datetime="<?php echo gregdate(" c", eng_number(get_the_time('c')));?>" itemprop="datePublished"><?php } ?>
                                        <?php echo get_the_date('j F Y'); ?>
                                    <?php if($az_data['site_schema']) { ?>
                                    </time>
                                    <?php } ?>
                                    <?php if($az_data['site_schema']) { ?>
                                        <meta content="<?php echo gregdate(" c", eng_number(get_the_time('c')));?>" itemprop="dateModified">
                                    <?php } ?>
                                </span>
                            </div>
                            <?php } ?>

                            <?php if($az_data['show_post_cat']) { ?>
                            <div class="col pattr">
                                <i class="col-2 fas fa-folder-open po-picon"></i>
                                <span class="col-10">
                                    <?php the_category( '، ' ); ?>
                                </span>
                            </div>
                            <?php } ?>

                            <?php if($az_data['show_post_view']) { ?>
                            <div class="col pattr">
                                <i class="col-2 fas fa-eye po-picon"></i>
                                <span class="col-10" lang="fa" dir="rtl">
                                    <?php setPostViews(get_the_ID()); ?>
                                    <?php echo getPostViews(get_the_ID()); ?>
                                </span>
                            </div>
                            <?php } ?>
                        </div>
                        <?php if ($az_data['show_post_tags'] && has_tag()) { ?>
                            <div class="p-tags" <?php if ($az_data['site_schema']) {?>itemprop="keywords"
                                <?php } ?>>
                                <p>
                                    <?php the_tags('<span class="fas fa-tags"></span>&nbsp;'.$az_data['text_tags'].'&nbsp;', '&nbsp;', ''); ?>
                                </p>
                            </div>
                        <?php } ?>
                </footer>
            </div>
        </div>
    </article>

    <?php if ($az_data['show_author_box']) { ?>
    <div class="rcon">
        <div class="author-page">
            <div class="row">
                <div class="col-md-2 col-12 uavatar">
                    <?php $author = get_post_field( 'post_author', get_the_ID() ); ?>
                    <?php echo get_avatar($author , 128, '',get_the_author_meta('display_name',$author )); ?>
                </div>
                <div class="col-md-10 col-12">
                    <div class="author-name">
                        <?php echo get_the_author_meta('display_name',$author); ?>
                        <?php if($az_data['show_author_user']) { ?>
                        <span class="author-uname">
                            <?php echo get_the_author_meta('user_login', $author); ?>
                        </span>
                        <?php } ?>
                    </div>
                    <div class="author-bio">
                        <?php echo get_the_author_meta('description',$author); ?>
                    </div>
                    <div class="row author-det">
                        <div class="col-md-4 col-12 author-attr">
                            <i class="fas fa-shopping-bag"></i>
                            <?php if (az_woo()) { ?>
                                <?php echo count_user_posts( $author , "product"  ) ?>
                            <?php } else { ?>
                                <?php echo count_user_posts( $author , "download"  ) ?>
                            <?php } ?>
                            محصول
                        </div>
                        <div class="col-md-4 col-12 author-attr">
                            <i class="fas fa-file-alt"></i>
                            <?php echo count_user_posts( $author , "post"  ) ?> نوشته
                        </div>
                        <div class="col-md-4 col-12 author-attr">
                            <i class="fas fa-user-plus"></i> عضویت
                            <?php echo parsidate('y/m/d',get_the_author_meta('user_registered',$author ),$lang='per'); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php } ?>

    <?php if ($az_data['show_related_s']) { ?>
    <!-- begin custom related loop, isa -->
    <?php
              $custom_taxterms = wp_get_object_terms( $post->ID, $az_data['related_s_by'], array('fields' => 'ids') );
            $args = array(
            'post_type' => 'post',
            'post_status' => 'publish',
            'posts_per_page' => $az_data['related_s_count'],
            'orderby' => 'rand',
            'tax_query' => array(
                array(
                    'taxonomy' => $az_data['related_s_by'],
                    'field' => 'id',
                    'terms' => $custom_taxterms
                )
            ),
            'post__not_in' => array ($post->ID),
            );
            $related_items = new WP_Query( $args );
             if ($related_items->have_posts()) { ?>
    <div class="rcon">
        <div class="m-product">
                    <div class="post-title">
                        <h3><i aria-hidden="true" class="fas fa-file-alt"></i>
                            <?php echo $az_data['related_s_title']; ?>
                        </h3>
                    </div>
            <div class="owl-carousel nauto-play">
                <?php
                while ( $related_items->have_posts() ) : $related_items->the_post();
                ?>
                <div class="item">
                    <div class="rcol">
                        <div class="r-box r-box-view">
                            <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
                                <div class="figure">
                                    <div class="fig">
                                        <span class="fig-price"><span>
                                                <?php echo $az_data['text_more_text']; ?></span></span>
                                        <?php p_mimg() ?>
                                    </div>
                                    <div class="figcaption">
                                        <?php the_title(); ?>
                                    </div>
                                </div>
                            </a>
                        </div>
                    </div>
                </div>
                <?php endwhile;
                     wp_reset_postdata();
                     ?>
            </div>
        </div>
    </div>
    <!-- end custom related loop -->
    <?php }} ?>
    <?php endwhile; ?>

    <!-- start foot banner -->
    <?php if ($az_data['show_post_foot_banner']) { ?>
    <div class="row">
        <div class="col-12 foot-con hovers">
            <a href="<?php echo $az_data['post_foot_banner_link']; ?>" aria-label="<?php echo $az_data['post_foot_banner_title']; ?>">
                <figure><img src="<?php echo $az_data['post_foot_banner']['url']; ?>" alt="<?php echo $az_data['post_foot_banner_title']; ?>" class="foot-banner" /></figure>
            </a>
        </div>
    </div>
    <?php }?>
    <!-- end foot banner -->
    <?php if ($az_data['show_ads_banner1'] && $az_data['show_ads_banner1_down']) { ?>
        <!-- start ads banner #1 -->
        <?php require_once AZ_DIR .'/includes/ads-banner.php'; ?>
        <!-- end ads banner #1 -->
    <?php  } ?>

    <?php if ($az_data['show_ads_banner2'] && $az_data['show_ads_banner2_down']) { ?>
        <!-- start ads banner #2 -->
        <?php require_once AZ_DIR .'/includes/ads-banner-t.php'; ?>
        <!-- end ads banner #2 -->
    <?php } ?>

    <?php
	if ( comments_open() ) : ?>
    <div class="comments-con">
        <div class="comments-list">
            <?php comments_template(); ?>
        </div>
    </div>
    <?php endif; ?>
    <?php endif; ?>
</div>
<?php if((rwmb_meta( 'file_wside' ) != 1) && (rwmb_meta( 'file_wside' ) != 'noside')) { ?>
<aside class="col-lg-3 side-bar<?php if (!$az_data['show_side_mobile']) {echo ' hidden-sm hidden-xs';} if ($az_data['sticky_side']) { echo ' side-sticky'; }?>">
    <?php get_template_part('right-sidebar'); ?>
</aside>
<?php } ?>

</div>
</main>
</div>

<?php get_footer();