<!doctype html>
<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: Hosseinkhani.ir
*/
   // Exit if accessed directly
   if (!defined('ABSPATH')) {
       exit;
   }
global $az_data;
edd_az();
?>
<html <?php language_attributes(); ?>>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=<?php bloginfo('charset'); ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <meta name="theme-color" content="<?php echo '#'.$az_data['custom_color']; ?>" />
    <title>
        <?php bloginfo('name'); ?> |
        <?php is_front_page() ? bloginfo('description') : wp_title(''); ?>
    </title>
    <link rel="shortcut icon" href="<?php echo $az_data['site_favicon']['url']; ?>" type="image/x-icon" />
    <link rel="stylesheet" media="screen" type="text/css" href="<?php echo esc_url(get_template_directory_uri()); ?>/css/bootstrap-rtl.min.css">
    <link rel="stylesheet" media="screen" type="text/css" href="<?php echo esc_url(get_template_directory_uri()); ?>/css/fontawesome.min.css">
    <link rel="stylesheet" media="screen" type="text/css" href="<?php bloginfo('stylesheet_url'); ?>" />
</head>

<body style="background-color: <?php echo '#'.$az_data['custom_color']; ?>">
    <div class="container-fluid">
        <div class="row">
            <div class="container under">
                <h1> <a href="<?php echo esc_url(home_url()); ?>" title="<?php bloginfo('name');?> | <?php bloginfo('description'); ?>" rel="home"> <img src="<?php echo $az_data['site_logo_retina']['url']; ?>" alt="<?php bloginfo('name');?> | <?php bloginfo('description'); ?>" title="<?php bloginfo('name');?> | <?php bloginfo('description'); ?>" /></a>
                </h1>
                <h2>
                    <?php echo $az_data['maintenance_title']; ?>
                </h2>
                <h3>
                    <?php echo $az_data['maintenance_msg']; ?>
                </h3>
            </div>
        </div>
    </div>
</body>

</html>