<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;
global $az_data;

// Ensure visibility.
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}
?>

<div role="main" class="col-md-4 col-6 pcon" id="post-<?php the_ID(); ?>">
      <a href="<?php the_permalink() ?>" title="<?php the_title(); ?>" class="vi-img-res-box">
       <div class="product">
         <div class="post-img">
            <div class="post-icon">
               <span class="price"><?php posticon(get_the_ID()); ?></span>
            </div>
            <?php p_img() ?>
              <?php 
                   if(rwmb_meta( 'file_special' )){ ?>
                <span class="special" aria-hidden="true"><?php echo $az_data['text_special']; ?></span>
                <?php } ?>
            <div class="prod-price price pt-price">
               <i class="fas fa-database price-icon"></i>
               <?php echo $product->get_price_html(); ?>
            </div>
         </div>
         <div class="col-12">
            <div class="col-10 prod-name pt-name">
               <h2 title="<?php the_title(); ?>"><?php the_title(); ?></h2>
            </div>
         </div>
         <?php if($az_data['show_excerpt']) { ?>
         <div class="col-12 pdesc">
            <?php the_excerpt(); ?>
         </div>
         <?php } ?>
      </div>
       </a>
   </div>
