<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

/**
 * Hook: woocommerce_before_single_product.
 *
 * @hooked wc_print_notices - 10
 */
do_action( 'woocommerce_before_single_product' );

if ( post_password_required() ) {
	echo get_the_password_form(); // WPCS: XSS ok.
	return;
}
global $az_data;
global $product;
?>

<!-- start head banner -->
<?php if ($az_data['show_down_head_banner']) { ?>
<div class="foot-con hovers">
    <a href="<?php echo $az_data['down_head_banner_link']; ?>" aria-label="<?php echo $az_data['down_head_banner_title']; ?>">
        <figure><img src="<?php echo $az_data['down_head_banner']['url']; ?>" alt="<?php echo $az_data['down_head_banner_title']; ?>" class="foot-banner" /></figure>
    </a>
</div>
<?php } ?>
<!-- end head banner -->

<!-- start services -->
<?php if ($az_data['show_services'] && $az_data['show_services_prod']) { require_once AZ_DIR .'/includes/services.php'; } ?>
<!-- end services -->

<article class="row" <?php if($az_data['site_schema']) {?>itemscope itemtype="http://schema.org/Product"<?php } ?>>
    <?php if($az_data['site_schema']) { ?>
    <link itemprop="mainEntityOfPage" href="<?php the_permalink(); ?>" />
    <meta itemprop="image" content="<?php the_post_thumbnail_url(); ?>" >
    <?php } ?>
    <div role="main" class="col-12 scon" id="post-<?php the_ID(); ?>">
        <div class="s-product">
            <header class="post-row">
                <div class="post-title">
                    <h1 <?php if($az_data['site_schema']) {?>itemprop="name"
                        <?php } ?>><i aria-hidden="true" class="fas fa-<?php $posticon = (rwmb_meta('file_p_type') != '' ? rwmb_meta('file_p_type') : 'download'); echo $posticon; ?>"></i>
                        <?php the_title(); ?>
                    </h1>
                    <div class="post-extra">
                        <?php if( function_exists("df_star_ratings") && ($az_data['star_rating']) ) { ?>
                        <div class="rating">
                            <?php waproduct_add_star_rating(); ?>
                        </div>
                        <?php } ?>
                        <?php if ($az_data['social_share']) { ?>
                            <span tabindex="0" class="share-btn" data-toggle="modal" data-target="#shareModal"><i class="fas fa-share-alt"></i></span>
                        <?php } ?>
                        <?php if (rwmb_meta( 'file_pre' ) != '') { ?>
                        <a href="<?php echo rwmb_meta( 'file_pre' ); ?>" data-title="<?php echo $az_data['text_pre']; ?>" target="_blank">
                            <span class="pre-btn" data-toggle="tooltip" data-placement="top" title="<?php echo $az_data['text_pre']; ?>"><i class="fas fa-desktop"></i>
                                <span class="pre-text hidden-sm hidden-xs">
                                    <?php echo $az_data['text_pre']; ?></span>
                            </span>
                        </a>
                        <?php } ?>
                    </div>
                </div>
            </header>
            <?php if($az_data['square_thumb']) {
                $prodimg = 'col-lg-5 col-md-6 col-12';
                $proddet = 'col-lg-7 col-md-6 col-12 square_thumb';
            } else {
                $prodimg = 'col-lg-7 col-md-8 col-12';
                $proddet = 'col-lg-5 col-md-4 col-12 square_thumb';
            }
            ?>
            <div class="row product-details">
                <div class="<?php echo $prodimg; ?> prod-img si-img">
                    <?php 
                    if(rwmb_meta( 'file_special' )) { ?>
                    <span class="special" aria-hidden="true">
                        <?php echo $az_data['text_special']; ?></span>
                    <?php } ?>
                    <?php
                    //File Preview
                    $file_pre = rwmb_meta( 'file_pre_type' );
                    $images = $product->get_gallery_image_ids();
                    $videos = rwmb_meta( 'file_video' );
                    $aparat = rwmb_meta( 'file_aparat' );

                    if($file_pre == 'pre_aparat' && !empty($aparat))
                    {
                    echo '<div id="15305363563383534"><script type="text/JavaScript" src="https://www.aparat.com/embed/'.$aparat.'?data[rnddiv]=15305363563383534&data[responsive]=yes"></script></div>';
                    }
                    elseif($file_pre == 'pre_slides' && !empty($images))
                    { ?>
                        <div id="sp-slider" class="slider-pro">
                            <div class="sp-slides">
                                <?php foreach ( $images as $image ) {
                                    $image_url_full = wp_get_attachment_image_src($image, 'full')[0]; ?>
                                <div class="sp-slide">
                                    <a href="<?php echo $image_url_full; ?>" class="imgg" title="<?php the_title_attribute(); ?>">
                                        <img <?php if($az_data['site_schema']) {?>itemprop="image"<?php } ?> class="sp-image" src="<?php echo get_template_directory_uri(); ?>/images/blank.gif" data-src="<?php echo $image_url_full; ?>" data-small="<?php echo $image_url_full; ?>" data-medium="<?php echo $image_url_full; ?>" data-large="<?php echo $image_url_full; ?>" data-retina="<?php echo $image_url_full; ?>" />
                                    </a>
                                </div>
                                <?php } ?>
                            </div>
                            <div class="sp-thumbnails">
                                <?php $images = $product->get_gallery_attachment_ids(); 
                                foreach ( $images as $image ) { 
                                    $image_url = wp_get_attachment_image_src($image, 'single-download-m')[0]; ?>
                                <div class="sp-thumbnail">
                                    <div class="sp-thumbnail-image-container">
                                        <img class="sp-thumbnail-image" src="<?php echo $image_url; ?>"/>
                                    </div>
                                </div>
                                <?php } ?>
                            </div>
                        </div>
                        <?php 
                    }
                    else if ($file_pre == 'pre_video' && !empty($videos))
                    { 
                    echo do_shortcode('[video src="'.$videos.'"]');
                    } else { ?>
                    <?php if (has_post_thumbnail()) {  ?>
                    <a href="<?php the_post_thumbnail_url( 'full' ); ?>" class="imgg" title="<?php the_title_attribute(); ?>">
                        <img <?php if($az_data['site_schema']) {?>itemprop="image"
                        <?php } ?> src="<?php the_post_thumbnail_url( 'single-download' ); ?>" class="post-tumb" alt="
                        <?php the_title_attribute(); ?>"/>
                    </a>
                    <?php } else { ?>
                    <img <?php if($az_data['site_schema']) { ?>itemprop="image"<?php } ?> src="<?php echo esc_url( get_template_directory_uri() ); ?>/images/tumb.png" class="post-tumb" alt="<?php the_title_attribute(); ?>"/>
                    <?php } 
                    $audio = rwmb_meta ('file_audio');
                    if($file_pre == 'pre_music' && !empty($audio)) {
                    echo do_shortcode('[audio src="'.$audio.'"]');
                    } } ?>
                </div>
                <div class="<?php echo $proddet; ?> prod-det" <?php if($az_data['site_schema']) {?>itemprop="offers" itemscope itemtype="http://schema.org/Offer"
                    <?php } ?>>
                    <?php if($az_data['site_schema']) { ?>
                    <meta itemprop="priceCurrency" content="IRT">
                    <meta itemprop="price" content="<?php echo 
                    (int)$product->get_regular_price(get_the_ID()); ?>">
                    <link itemprop="availability" href="http://schema.org/InStock" />
                    <meta itemprop="url" content="<?php the_permalink(); ?>">
                    <?php } ?>
                    <?php if ($az_data['show_fone']) { ?>
                    <div class="prod-row col-12">
                        <div class="attr">
                            <span class="fas <?php echo $az_data['fone_icon']; ?> picon"></span>
                            <span class="attr-text">
                                <?php echo $az_data['fone']; ?></span>
                        </div>
                        <div class="attr-value">
                            <span>
                                <?php echo rwmb_meta( 'file_fone' ); ?></span>
                        </div>
                    </div>
                    <?php } ?>
                    <?php if ($az_data['show_ftwo']) { ?>
                    <div class="prod-row col-12">
                        <div class="attr">
                            <span class="fas <?php echo $az_data['ftwo_icon']; ?> picon"></span>
                            <span class="attr-text">
                                <?php echo $az_data['ftwo']; ?></span>
                        </div>
                        <div class="attr-value">
                            <span>
                                <?php echo rwmb_meta( 'file_ftwo' ); ?></span>
                        </div>
                    </div>
                    <?php } ?>
                    <?php if ($az_data['show_fthree']) { ?>
                    <div class="prod-row col-12">
                        <div class="attr">
                            <span class="fas <?php echo $az_data['fthree_icon']; ?> picon"></span>
                            <span class="attr-text">
                                <?php echo $az_data['fthree']; ?></span>
                        </div>
                        <div class="attr-value">
                            <span>
                                <?php if($az_data['edit_fthree']) {echo rwmb_meta( 'file_fthree' );} else { ?><a class="author-link" href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ); ?>">
                                    <?php the_author(); ?></a>
                                <?php }  ?></span>
                        </div>
                    </div>
                    <?php } ?>
                    <?php if ($az_data['show_ffour']) { ?>
                    <div class="prod-row col-12">
                        <div class="attr">
                            <span class="fas <?php echo $az_data['ffour_icon']; ?> picon"></span>
                            <span class="attr-text">
                                <?php echo $az_data['ffour']; ?></span>
                        </div>
                        <div class="attr-value">
                            <span>
                                <?php if($az_data['edit_ffour']) {echo rwmb_meta( 'file_ffour' );} else { ?>
                                <?php echo get_the_date('j F Y'); ?>
                                <?php }  ?></span>
                        </div>
                    </div>
                    <?php } ?>
                    <?php if ($az_data['show_ffive']) { ?>
                    <div class="prod-row col-12">
                        <div class="attr">
                            <span class="fas <?php echo $az_data['ffive_icon']; ?> picon"></span>
                            <span class="attr-text">
                                <?php echo $az_data['ffive']; ?></span>
                        </div>
                        <div class="attr-value">
                            <span>
                                <?php if($az_data['edit_ffive']) {echo rwmb_meta( 'file_ffive' );} else { the_terms( $post->ID, 'product_cat', '', '، ', '' ); }  ?></span>
                        </div>
                    </div>
                    <?php } ?>
                    <?php if ($az_data['show_fsix']) { ?>
                    <div class="prod-row col-12">
                        <div class="attr">
                            <span class="fas <?php echo $az_data['fsix_icon']; ?> picon"></span>
                            <span class="attr-text">
                                <?php echo $az_data['fsix']; ?></span>
                        </div>
                        <div class="attr-value">
                            <span>
                                <?php setPostViews(get_the_ID()); if($az_data['edit_fsix']) {echo rwmb_meta( 'file_fsix' );} else { if($az_data['show_dcount']) {
                                
                                $count = get_post_meta($post->ID,'total_sales', true); echo $count .' فروش';
                                
                            } else {
                                echo getPostViews(get_the_ID()); }} 
                                ?></span>
                        </div>
                    </div>
                    <?php } ?>
                    <?php if(!rwmb_meta( 'file_coming' )) { ?>
                    <div class="prod-row col-12">
                        <span class="sprice">
                            <?php
                                $product = wc_get_product( $post->ID );
                                echo $product->get_price_html();
                            ?>
                        </span>
                    </div>
                    <?php } ?>
                    <div class="prod-add col-12">
                        <div class="col-12 add-col">
                            <?php if(!rwmb_meta( 'file_coming' )) {
                            if(azin_woo_free(get_the_ID())) { 
                            if($az_data['free_logged'] && !is_user_logged_in()) { 
                                if(!empty($az_data['free_logged_link'])) {
                                    echo '<a href="'.$az_data['free_logged_link'].'" title="ورود">';
                                }
                            echo '<span class="free-logged">'. $az_data['text_free_logged'].'</span>';
                                if(!empty($az_data['free_logged_link'])) {
                                    echo '</a>';
                                }
                            } 
                            else {
                            echo do_shortcode('[download_now id="'.get_the_ID().'" text="دانلود"]');
                            }
                            } else {
                                woocommerce_template_single_add_to_cart();
                            }
                            } else {
                            echo '<span class="coming">'. $az_data['text_coming'].'</span>';
                            } ?>
                        </div>
                    </div>
                </div>
            </div>
            
            <?php if ($az_data['show_buy_fixed']) { ?>
                <div class="btn btn-success buy-fixed">
                    <?php if(azin_woo_free(get_the_ID())) { ?>
                    <i class="fas fa-download"></i>&nbsp;
                    <?php echo $az_data['text_down_this']; ?>
                    <?php } else { ?>
                    <i class="fas fa-shopping-cart"></i>&nbsp;
                    <?php echo $az_data['text_buy_this']; ?>
                    <?php } ?>
                </div>
            <?php } ?>
        </div>
    <?php
        /**
         * Hook: woocommerce_before_single_product_summary.
         *
         * @hooked woocommerce_show_product_sale_flash - 10
         * @hooked woocommerce_show_product_images - 20
         */
        do_action( 'woocommerce_before_single_product_summary' );
    ?>

    <?php
        /**
         * Hook: woocommerce_after_single_product_summary.
         *
         * @hooked woocommerce_output_product_data_tabs - 10
         * @hooked woocommerce_upsell_display - 15
         * @hooked woocommerce_output_related_products - 20
         */
        do_action( 'woocommerce_after_single_product_summary' );
    ?>
    <?php do_action( 'woocommerce_after_single_product' ); ?>
</article>