<?php
/**
 * Related Products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/related.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.9.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
global $az_data;
global $product;
if ( $related_products ) : ?>

	<?php if ($az_data['show_related_p']) { ?>
    <!-- begin custom related loop, isa -->
    <?php
			if($az_data['related_p_by']=='download_tag'){
				$related_p_by = 'product_tag';
			}
			else{
				$related_p_by = 'product_cat';
			}
            $custom_taxterms = wp_get_object_terms( get_the_ID(), $related_p_by, array('fields' => 'ids') );
            $args = array(
            'post_type' => 'product',
            'post_status' => 'publish',
            'posts_per_page' => $az_data['related_p_count'],
            'orderby' => 'rand',
            'tax_query' => array(
                array(
                    'taxonomy' => $related_p_by,
                    'field' => 'id',
                    'terms' => $custom_taxterms
                )
            ),
            'post__not_in' => array (get_the_ID()),
            );
            $related_items = new WP_Query( $args ); ?>
			<?php
             if ($related_items->have_posts()) { 
				 ?>
        <div class="m-product">
                    <div class="post-title">
                        <h3><i aria-hidden="true" class="fas fa-shopping-bag"></i>
                            <?php echo $az_data['related_p_title']; ?>
                        </h3>
                    </div>
            <div class="owl-carousel nauto-play">
                <?php
                while ( $related_items->have_posts() ) : $related_items->the_post();
            ?>
                <div class="item">
                    <div class="rcol">
                        <div class="r-box r-box-view">
                            <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
                                <div class="figure">
                                    <div class="fig">
                                        <span class="fig-price">
											<span>
												<?php $product = new WC_Product(get_the_ID()); 
												echo $product->get_price_html(); ?></span>
											</span>
                                        <?php p_mimg() ?>
                                    </div>
                                    <div class="figcaption">
                                        <?php the_title(); ?>
                                    </div>
                                </div>
                            </a>
                        </div>
                    </div>
                </div>
                <?php endwhile;
                     wp_reset_postdata();
                     ?>
            </div>
        </div>
    <!-- end custom related loop -->
    <?php }} ?>

<?php endif; ?>

<!-- start foot banner -->
<?php if ($az_data['show_down_foot_banner']) { ?>
<div class="row">
<div class="col-12 foot-con hovers">
    <a href="<?php echo $az_data['down_foot_banner_link']; ?>" aria-label="<?php echo $az_data['down_foot_banner_title']; ?>">
        <figure>
            <img src="<?php echo $az_data['down_foot_banner']['url']; ?>" alt="<?php echo $az_data['down_foot_banner_title']; ?>" class="foot-banner" />
        </figure>
    </a>
</div>
</div>
<?php }?>
<!-- end foot banner -->
<?php if ($az_data['show_ads_banner1'] && $az_data['show_ads_banner1_down']) { ?>
<!-- start ads banner #1 -->
<?php require_once AZ_DIR .'/includes/ads-banner.php'; ?>
<!-- end ads banner #1 -->
<?php  } ?>

<?php if ($az_data['show_ads_banner2'] && $az_data['show_ads_banner2_down']) { ?>
<!-- start ads banner #2 -->
<?php require_once AZ_DIR .'/includes/ads-banner-t.php'; ?>
<!-- end ads banner #2 -->
<?php } ?>