<?php
/**
 * Description tab
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/tabs/description.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $post;
global $az_data;

$heading = esc_html( apply_filters( 'woocommerce_product_description_heading', __( 'Description', 'woocommerce' ) ) );

?>

<div class="col-12 down-con" <?php if($az_data['site_schema']) {?>itemprop="description"
                        <?php } ?>>
                        <?php if ($az_data['text_summ']) { ?>
                        <div class="single-text">
                            <?php } ?>
                            <?php the_content();?>
                            <?php
                                $defaults = array(
                                    'before'           => '<div class="text-center apage-break">',
                                    'after'            => '</div>',
                                    'link_before'      => '',
                                    'link_after'       => '',
                                    'next_or_number'   => 'text',
                                    'separator'        => ' ',
                                    'nextpagelink'     => '<span class="btn btn-primary">صفحه بعد <i aria-hidden="true" class="fas fa-angle-left"></i></span>',
                                    'previouspagelink' => '<span class="btn btn-primary"><i aria-hidden="true" class="fas fa-angle-right"></i> صفحه قبل</span>',
                                    'pagelink'         => '%',
                                    'echo'             => 1
                                );
                            wp_link_pages($defaults); ?>
                            <?php if ($az_data['text_summ']) { ?>
                            <p class="read-more"><a href="#" class="sbutton">
                                    <?php echo $az_data['text_read_more']; ?></a></p>
                        </div>
                        <?php } ?>
                        <?php if(rwmb_meta( 'file_dbox' )) { ?>
                        <!--DL Box-->
                        <div class="dlbox">
                            <div class="dltitle">
                                <i class="fas fa-download"></i>
                                <?php echo $az_data['text_dl']; ?>
                                <?php echo rwmb_meta( 'file_fname', $args, $post->ID ); ?>
                            </div>
                            <?php if( $az_data['show_dl_logged'] && !is_user_logged_in()) {?>
                                <div class="dl-login-msg">
                                    برای مشاهده لینک های دانلود
                                   <a <?php if (!$az_data['ch_login_link']) { echo 'href="#" data-toggle="modal" data-target="#login"';
                                    } else {
                                        echo 'href="' .$az_data['login_link'].'"';
                                    } ?>>
                                        وارد شوید
                                    </a>
                                    یا
                                    <a <?php if (!$az_data['ch_register_link']) {
                                    if (az_woo()) {
                                        echo 'href="' .esc_url(home_url()).'/my-account"';
                                    } else {
                                        echo 'href="' .esc_url(home_url()).'/register"';
                                    }
                                    } else {
                                        echo 'href="' .$az_data['register_link'].'"';
                                    } ?> title="<?php echo $az_data['text_reg_hint']; ?>">
                                        ثبت نام
                                    </a>
                                    نمایید.
                                </div>
                            <?php } else { ?>
                            <div class="links">
                                <?php 
                                $urls = rwmb_meta( 'file_furl', $args, $post->ID );
                                $box_type = rwmb_meta( 'file_box_type', $args, $post->ID );
                                if ( !empty( $urls ) ) {
                                    if ($box_type=='box_part' || $box_type == '') {
                                    foreach ( $urls as $urls ) {
                                        if (filter_var($urls, FILTER_VALIDATE_URL) === FALSE) {
                                            echo '<div class="plain"><i class="fas fa-chain"></i>'.$urls.'</div>';
                                        } else {
                                        $url_name = str_replace('%20', ' ', basename($urls));
                                        $url_name = str_replace('-', ' ', $url_name); 
                                        echo '<a href="'.$urls.'" title="'.$url_name.'" class="flink"><i class="fas fa-caret-left"></i>'.$url_name.'</a>';
                                        }
                                    }
                                    } elseif ($box_type=='box_single') {
                                    foreach ( $urls as $url ) {
                                        if (filter_var($url, FILTER_VALIDATE_URL)) {
                                            echo '<a href="'.$url.'"';
                                        } else {
                                        echo 'title="'.$url.'" class="flink"><i class="fas fa-caret-left"></i>'.$url.'</a>';
                                        }
                                    }
                                    }
                                } ?>
                            </div>
                            <?php } ?>

                            <div class="row fdet">
                                <div class="col-md-4 sdet">
                                    <i class="fas fa-save"></i>
                                    <span aria-hidden="true" data-toggle="tooltip" data-placement="top" title="" data-original-title="<?php echo $az_data['text_size']; ?>"><?php echo rwmb_meta( 'file_fsize', $args, $post->ID ); ?></span>
                                </div>
                                <div class="col-md-4 sdet">
                                    <i class="fas fa-lock"></i>
                                    <span aria-hidden="true" data-toggle="tooltip" data-placement="top" title="" data-original-title="<?php echo $az_data['text_pass']; ?>">
                                        <?php echo rwmb_meta( 'file_fpass', $args, $post->ID ); ?>
                                    </span>
                                </div>
                                <div class="col-md-4 sdet">
                                    <span class="dhelp" data-toggle="modal" data-target="#dhelp">
                                        <i class="fas fa-question-circle"></i>
                                        <span aria-hidden="true" data-toggle="tooltip" data-placement="top" title="" data-original-title="<?php echo $az_data['text_hdl']; ?>"><?php echo $az_data['text_hdl']; ?></span>
                                    </span>
                                </div>
                            </div>
                            <!-- Modal -->
                            <div class="modal fade" id="dhelp">
                            <div class="modal-dialog modal-dialog-centered">
                                <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title">
                                        <?php echo $az_data['dl_help_title']; ?>
                                    </h4>
                                    <button type="button" class="close" data-dismiss="modal">
                                        <i class="fas fa-times" aria-hidden="true"></i>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <?php echo $az_data['dl_help_text']; ?>
                                </div>
                                </div>
                            </div>
                            </div>
                            <!-- Modal -->
                        </div>
                        <!--DL Box-->
                        <?php } ?>
                        <?php if ($az_data['show_msg_help']) { ?>
                        <div class="alert alert-info msg-help col-12">
                            <strong><span class="fas fa-info-circle"></span>&nbsp;&nbsp;
                                <?php echo $az_data['msg_title']; ?></strong>
                            <?php echo $az_data['msg_help']; ?>
                        </div>
                        <?php } ?>
                    </div>
                    <footer>
                        <?php if ($az_data['show_post_tags']) { ?>
                        <?php the_terms( $post->ID, 'product_tag', '<div class="col-12 p-tags">
            <p><span class="fas fa-tags"></span>&nbsp;'.$az_data['text_tags'].'&nbsp;', '&nbsp;', '</p>
         </div>' ); ?>
                        <?php } ?>
                    </footer>